/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo.ui;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.ui.JREDialog;
import org.eclipse.oomph.jreinfo.ui.Messages;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.Request;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class JREController
implements ISelectionChangedListener {
    private static final String NO_JRE_FOUND = Messages.JREController_noJreFound;
    private final Label label;
    private final StructuredViewer viewer;
    private final Request.Handler downloadHandler;
    private String javaVersion;
    private int bitness = JREManager.BITNESS;
    private JREFilter jreFilter;
    private JRE jre;
    private boolean refreshing;

    public JREController(Label label, StructuredViewer viewer, Request.Handler downloadHandler) {
        this.label = label;
        this.viewer = viewer;
        this.downloadHandler = downloadHandler;
        if (viewer != null) {
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public final StructuredViewer getViewer() {
        return this.viewer;
    }

    public final String getJavaVersion() {
        return this.javaVersion;
    }

    public final void setJavaVersion(String javaVersion) {
        if (!ObjectUtil.equals((Object)this.javaVersion, (Object)javaVersion)) {
            this.javaVersion = javaVersion;
            if (this.label != null) {
                String text = "Java";
                if (!StringUtil.isEmpty((String)javaVersion)) {
                    text = String.valueOf(text) + " " + javaVersion + "+";
                    this.label.setToolTipText(NLS.bind((String)Messages.JREController_chooseJvm_tooltip, (Object)javaVersion));
                }
                text = String.valueOf(text) + " VM";
                this.setLabel(text);
            }
        }
        this.refresh();
    }

    public final int getBitness() {
        return this.bitness;
    }

    public final void setBitness(int bitness) {
        if (this.bitness != bitness) {
            this.bitness = bitness;
        }
        this.refresh();
    }

    public final JRE getJRE() {
        return this.jre;
    }

    public final void setJRE(JRE jre) {
        this.doSetJRE(jre);
        this.setSelection((ISelection)new StructuredSelection((Object)jre));
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection);
            UIUtil.clearTextSelection((Object)this.viewer);
        }
    }

    public void configureJREs() {
        JREDialog dialog = new JREDialog(this.getShell(), this.downloadHandler){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(false);
                }
            }

            protected void elementChanged(Object element) {
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(this.isMatchingJRE(element));
                }
            }

            private boolean isMatchingJRE(Object element) {
                if (element instanceof JRE) {
                    JRE jre = (JRE)element;
                    return JREController.this.jreFilter == null || jre.isMatch(JREController.this.jreFilter);
                }
                return false;
            }
        };
        dialog.setJREFilter(this.jreFilter);
        JRE jre = this.getDefaultSelection();
        if (jre != null) {
            dialog.setSelectedElement(jre);
        }
        if (dialog.open() == 0) {
            this.doSetJRE((JRE)dialog.getSelectedElement());
        }
        this.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object element = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof JRE) {
            this.doSetJRE((JRE)element);
            UIUtil.clearTextSelection((Object)this.viewer);
        } else {
            this.doSetJRE(null);
            if (element == NO_JRE_FOUND && !this.refreshing) {
                this.configureJREs();
            }
        }
    }

    public void refresh() {
        this.jreFilter = this.createJREFilter();
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                JREController.this.refreshing = true;
                try {
                    Object oldElement = JREController.this.viewer == null ? null : ((IStructuredSelection)JREController.this.viewer.getSelection()).getFirstElement();
                    JRE oldJRE = oldElement instanceof JRE ? (JRE)oldElement : JREController.this.jre;
                    List<JRE> jres = Arrays.asList(JREManager.INSTANCE.getAllJREs(JREController.this.jreFilter));
                    if (JREController.this.viewer != null) {
                        JREController.this.viewer.setInput(jres);
                    }
                    if (jres.isEmpty()) {
                        JREController.this.modelEmpty(true);
                    } else {
                        JREController.this.modelEmpty(false);
                        JRE selection = JREController.this.getDefaultJRE(JREController.this.javaVersion);
                        if (selection == null || !jres.contains(selection)) {
                            selection = null;
                            if (oldJRE != null && jres.contains(oldJRE)) {
                                selection = oldJRE;
                            }
                        }
                        if (selection == null || !jres.contains(selection)) {
                            for (JRE jre : jres) {
                                if (selection == null) {
                                    selection = jre;
                                    continue;
                                }
                                if (!jre.isCurrent()) continue;
                                selection = jre;
                                break;
                            }
                        }
                        JREController.this.setSelection((ISelection)new StructuredSelection((Object)selection));
                    }
                }
                finally {
                    JREController.this.refreshing = false;
                }
            }
        });
    }

    protected void setLabel(String text) {
        this.label.setText(text);
        this.label.getParent().layout();
    }

    protected JREFilter createJREFilter() {
        return new JREFilter(this.javaVersion, Integer.valueOf(this.bitness), null);
    }

    protected void modelEmpty(boolean empty) {
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (empty) {
                this.viewer.setInput(Collections.singletonList(NO_JRE_FOUND));
                this.setSelection((ISelection)new StructuredSelection((Object)NO_JRE_FOUND));
                control.setForeground(control.getDisplay().getSystemColor(3));
            } else {
                control.setForeground(null);
            }
        }
    }

    protected void jreChanged(JRE jre) {
    }

    protected Shell getShell() {
        return this.viewer.getControl().getShell();
    }

    protected JRE getDefaultSelection() {
        Object element = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof JRE) {
            return (JRE)element;
        }
        return null;
    }

    protected JRE getDefaultJRE(String javaVersion) {
        String javaHome;
        if (javaVersion != null && (javaHome = JREManager.INSTANCE.getDefaultJRE(this.bitness, javaVersion)) != null) {
            Map jres = JREManager.INSTANCE.getJREs();
            return (JRE)jres.get(new File(javaHome));
        }
        return null;
    }

    private void doSetJRE(JRE jre) {
        File javaHome;
        this.jre = jre;
        if (jre != null && (javaHome = jre.getJavaHome()) != null) {
            JREManager.INSTANCE.setDefaultJRE(this.bitness, this.javaVersion, javaHome.getAbsolutePath());
        }
        this.jreChanged(jre);
    }
}

