/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeItem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WelcomeParser
extends DefaultHandler {
    private static final String TAG_WELCOME_PAGE = "welcomePage";
    private static final String TAG_INTRO = "intro";
    private static final String TAG_ITEM = "item";
    private static final String TAG_BOLD = "b";
    private static final String TAG_ACTION = "action";
    private static final String TAG_PARAGRAPH = "p";
    private static final String TAG_TOPIC = "topic";
    private static final String ATT_TITLE = "title";
    private static final String ATT_FORMAT = "format";
    private static final String ATT_PLUGIN_ID = "pluginId";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ID = "id";
    private static final String ATT_HREF = "href";
    private static final String FORMAT_WRAP = "wrap";
    private static final char DELIMITER = '\n';
    private SAXParser parser;
    private String title;
    private WelcomeItem introItem;
    private ArrayList<WelcomeItem> items = new ArrayList();
    private String format;

    public WelcomeParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/namespaces", true);
        this.parser = factory.newSAXParser();
        this.parser.getXMLReader().setContentHandler(this);
        this.parser.getXMLReader().setDTDHandler(this);
        this.parser.getXMLReader().setEntityResolver(this);
        this.parser.getXMLReader().setErrorHandler(this);
    }

    public WelcomeItem getIntroItem() {
        return this.introItem;
    }

    public WelcomeItem[] getItems() {
        return this.items.toArray(new WelcomeItem[this.items.size()]);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isFormatWrapped() {
        return FORMAT_WRAP.equals(this.format);
    }

    public void parse(InputStream is) {
        try {
            this.parser.parse(new InputSource(is), (DefaultHandler)this);
        }
        catch (IOException | SAXException e) {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.WelcomeParser_parseException, (Throwable)e);
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.WelcomeParser_parseError, (IStatus)status);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals(TAG_WELCOME_PAGE)) {
            WelcomePageHandler h = new WelcomePageHandler(atts.getValue(ATT_TITLE));
            this.format = atts.getValue(ATT_FORMAT);
            h.setParent(this);
            this.parser.getXMLReader().setContentHandler(h);
        }
    }

    private class IntroItemHandler
    extends ItemHandler {
        private IntroItemHandler() {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals(WelcomeParser.TAG_INTRO)) {
                WelcomeParser.this.introItem = this.constructWelcomeItem();
                WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
            } else if (localName.equals(WelcomeParser.TAG_PARAGRAPH)) {
                this.wrapRanges.add(new int[]{this.wrapStart, this.offset - this.wrapStart});
            }
        }
    }

    private class ItemHandler
    extends WelcomeContentHandler {
        private ArrayList<int[]> boldRanges;
        protected ArrayList<int[]> wrapRanges;
        private ArrayList<int[]> actionRanges;
        private ArrayList<String> pluginIds;
        private ArrayList<String> classes;
        private ArrayList<int[]> helpRanges;
        private ArrayList<String> helpIds;
        private ArrayList<String> helpHrefs;
        private StringBuilder text;
        protected int offset;
        protected int textStart;
        protected int wrapStart;

        private ItemHandler() {
            this.boldRanges = new ArrayList();
            this.wrapRanges = new ArrayList();
            this.actionRanges = new ArrayList();
            this.pluginIds = new ArrayList();
            this.classes = new ArrayList();
            this.helpRanges = new ArrayList();
            this.helpIds = new ArrayList();
            this.helpHrefs = new ArrayList();
            this.text = new StringBuilder();
            this.offset = 0;
        }

        protected WelcomeItem constructWelcomeItem() {
            if (WelcomeParser.this.isFormatWrapped()) {
                for (int[] range : this.wrapRanges) {
                    int start = range[0];
                    int length = range[1];
                    int j = start;
                    while (j < start + length) {
                        char ch = this.text.charAt(j);
                        if (ch == '\n') {
                            this.text.replace(j, j + 1, " ");
                        }
                        ++j;
                    }
                }
            }
            return new WelcomeItem(this.text.toString(), (int[][])this.boldRanges.toArray((T[])new int[this.boldRanges.size()][2]), (int[][])this.actionRanges.toArray((T[])new int[this.actionRanges.size()][2]), this.pluginIds.toArray(new String[this.pluginIds.size()]), this.classes.toArray(new String[this.classes.size()]), (int[][])this.helpRanges.toArray((T[])new int[this.helpRanges.size()][2]), this.helpIds.toArray(new String[this.helpIds.size()]), this.helpHrefs.toArray(new String[this.helpHrefs.size()]));
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            int i = 0;
            while (i < length) {
                this.text.append(ch[start + i]);
                ++i;
            }
            this.offset += length;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.textStart = this.offset;
            switch (localName) {
                case "b": {
                    BoldHandler h = new BoldHandler();
                    h.setParent(this);
                    WelcomeParser.this.parser.getXMLReader().setContentHandler(h);
                    break;
                }
                case "action": {
                    ActionHandler h = new ActionHandler(atts.getValue(WelcomeParser.ATT_PLUGIN_ID), atts.getValue(WelcomeParser.ATT_CLASS));
                    h.setParent(this);
                    WelcomeParser.this.parser.getXMLReader().setContentHandler(h);
                    break;
                }
                case "p": {
                    this.wrapStart = this.textStart;
                    break;
                }
                case "topic": {
                    TopicHandler h = new TopicHandler(atts.getValue(WelcomeParser.ATT_ID), atts.getValue(WelcomeParser.ATT_HREF));
                    h.setParent(this);
                    WelcomeParser.this.parser.getXMLReader().setContentHandler(h);
                    break;
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals(WelcomeParser.TAG_ITEM)) {
                WelcomeParser.this.items.add(this.constructWelcomeItem());
                WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
            } else if (localName.equals(WelcomeParser.TAG_PARAGRAPH)) {
                this.wrapRanges.add(new int[]{this.wrapStart, this.offset - this.wrapStart});
            }
        }

        private class ActionHandler
        extends WelcomeContentHandler {
            public ActionHandler(String pluginId, String className) {
                ItemHandler.this.pluginIds.add(pluginId);
                ItemHandler.this.classes.add(className);
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                ItemHandler.this.characters(ch, start, length);
            }

            @Override
            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (localName.equals(WelcomeParser.TAG_ACTION)) {
                    ItemHandler.this.actionRanges.add(new int[]{ItemHandler.this.textStart, ItemHandler.this.offset - ItemHandler.this.textStart});
                    ((ItemHandler)ItemHandler.this).WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
                }
            }
        }

        private class BoldHandler
        extends WelcomeContentHandler {
            private BoldHandler() {
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                ItemHandler.this.characters(ch, start, length);
            }

            @Override
            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (localName.equals(WelcomeParser.TAG_BOLD)) {
                    ItemHandler.this.boldRanges.add(new int[]{ItemHandler.this.textStart, ItemHandler.this.offset - ItemHandler.this.textStart});
                    ((ItemHandler)ItemHandler.this).WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
                }
            }
        }

        private class TopicHandler
        extends WelcomeContentHandler {
            public TopicHandler(String helpId, String href) {
                ItemHandler.this.helpIds.add(helpId);
                ItemHandler.this.helpHrefs.add(href);
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                ItemHandler.this.characters(ch, start, length);
            }

            @Override
            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (localName.equals(WelcomeParser.TAG_TOPIC)) {
                    ItemHandler.this.helpRanges.add(new int[]{ItemHandler.this.textStart, ItemHandler.this.offset - ItemHandler.this.textStart});
                    ((ItemHandler)ItemHandler.this).WelcomeParser.this.parser.getXMLReader().setContentHandler(this.parent);
                }
            }
        }
    }

    private class WelcomeContentHandler
    implements ContentHandler {
        protected ContentHandler parent;

        private WelcomeContentHandler() {
        }

        public void setParent(ContentHandler p) {
            this.parent = p;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }
    }

    private class WelcomePageHandler
    extends WelcomeContentHandler {
        public WelcomePageHandler(String newTitle) {
            WelcomeParser.this.title = newTitle;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals(WelcomeParser.TAG_INTRO)) {
                IntroItemHandler h = new IntroItemHandler();
                h.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(h);
            } else if (localName.equals(WelcomeParser.TAG_ITEM)) {
                ItemHandler h = new ItemHandler();
                h.setParent(this);
                WelcomeParser.this.parser.getXMLReader().setContentHandler(h);
            }
        }
    }
}

