/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.presentation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.predicates.RepositoryPredicate;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.presentation.actions.ShowInExplorerAction;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditor;
import org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditorPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfigActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                ProjectConfigActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                ProjectConfigEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return ProjectConfigActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (ProjectConfigActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)ProjectConfigActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected IAction updatePreferenceProfileReferencesAction = new Action("Update Preference Profile References"){

        public boolean isEnabled() {
            return ProjectConfigActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            EditingDomain editingDomain;
            EList resources;
            if (ProjectConfigActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider && !(resources = (editingDomain = ((IEditingDomainProvider)ProjectConfigActionBarContributor.this.activeEditorPart).getEditingDomain()).getResourceSet().getResources()).isEmpty()) {
                final WorkspaceConfiguration workspaceConfiguration = (WorkspaceConfiguration)((Resource)resources.get(0)).getContents().get(0);
                editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)workspaceConfiguration){

                    public String getDescription() {
                        return "Updates preference profile references based on the preference profile predicates";
                    }

                    public String getLabel() {
                        return "Update References";
                    }

                    protected void doExecute() {
                        workspaceConfiguration.updatePreferenceProfileReferences();
                    }
                });
            }
        }
    };
    protected IAction applyPreferenceProfilesAction = new Action("Apply Preference Profile"){

        public boolean isEnabled() {
            return ProjectConfigActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            EditingDomain editingDomain;
            EList resources;
            if (ProjectConfigActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider && !(resources = (editingDomain = ((IEditingDomainProvider)ProjectConfigActionBarContributor.this.activeEditorPart).getEditingDomain()).getResourceSet().getResources()).isEmpty()) {
                boolean confirmation;
                if (ProjectConfigActionBarContributor.this.activeEditorPart.isDirty() ? !(confirmation = MessageDialog.openQuestion(null, (String)"Save", (String)"The project configuration needs to be saved.\n\nDo you wish to save?")) : !(confirmation = MessageDialog.openQuestion(null, (String)"Save", (String)"The preference profile references need to be updated and saved.\n\nDo you wish to save?"))) {
                    return;
                }
                final WorkspaceConfiguration workspaceConfiguration = (WorkspaceConfiguration)((Resource)resources.get(0)).getContents().get(0);
                editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)workspaceConfiguration){

                    public String getDescription() {
                        return "Apply preference profiles to all affected workspace projects";
                    }

                    public String getLabel() {
                        return "Update Preference Profiles";
                    }

                    protected void doExecute() {
                        workspaceConfiguration.updatePreferenceProfileReferences();
                    }
                });
                ProjectConfigActionBarContributor.this.activeEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                workspaceConfiguration.applyPreferenceProfiles();
            }
        }
    };
    protected IAction reloadEditorAction = new Action("Reload Editor"){

        public boolean isEnabled() {
            return ProjectConfigActionBarContributor.this.activeEditorPart instanceof ProjectConfigEditor;
        }

        public void run() {
            if (ProjectConfigActionBarContributor.this.activeEditorPart instanceof ProjectConfigEditor) {
                ProjectConfigEditor projectConfigEditor = (ProjectConfigEditor)ProjectConfigActionBarContributor.this.activeEditorPart;
                projectConfigEditor.reload();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public ProjectConfigActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.liveValidationAction = new DiagnosticDecorator.LiveValidator.LiveValidationAction(ProjectConfigEditorPlugin.getPlugin().getDialogSettings());
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("projectconfig-settings"));
        toolBarManager.add((IContributionItem)new Separator("projectconfig-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_ProjectConfigEditor_menu"), "org.eclipse.oomph.projectconfigMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected void augment(Collection<?> descriptors, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && descriptors != null && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            EObject eObject = (EObject)object;
            while (eObject != null) {
                if (eObject instanceof Project) {
                    for (Object descriptor : descriptors) {
                        Project project;
                        PreferenceNode preferenceNode;
                        CommandParameter commandParameter;
                        Object value;
                        if (!(descriptor instanceof CommandParameter) || !((value = (commandParameter = (CommandParameter)descriptor).getValue()) instanceof RepositoryPredicate) || (preferenceNode = (project = (Project)eObject).getPreferenceNode()) == null) continue;
                        String projectName = preferenceNode.getName();
                        IProject iProject = WORKSPACE_ROOT.getProject(projectName);
                        RepositoryPredicate repositoryPredicate = (RepositoryPredicate)value;
                        repositoryPredicate.setProject(iProject);
                    }
                }
                eObject = eObject.eContainer();
            }
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        this.augment(descriptors, selection);
        return this.generateCreateChildActionsGen(descriptors, selection);
    }

    protected Collection<IAction> generateCreateChildActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        this.augment(descriptors, selection);
        return this.generateCreateSiblingActionsGen(descriptors, selection);
    }

    protected Collection<IAction> generateCreateSiblingActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ISelectionProvider selectionProvider;
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(ProjectConfigEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            ArrayList<PreferenceNode> preferenceNodes = new ArrayList<PreferenceNode>();
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Project) {
                    preferenceNodes.add(((Project)object).getPreferenceNode());
                }
                ++n2;
            }
            Action action = new Action(preferenceNodes){
                ShowInExplorerAction showInExplorerAction = new ShowInExplorerAction();
                {
                    this.showInExplorerAction.selectionChanged((IAction)this, (ISelection)new StructuredSelection(list));
                }

                public String getText() {
                    return "Show in Package Explorer";
                }

                public void run() {
                    this.showInExplorerAction.run((IAction)this);
                }
            };
            if (action.isEnabled()) {
                menuManager.insertAfter("additions", (IAction)action);
            }
        }
        menuManager.insertAfter("ui-actions", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.activeEditorPart.getEditorSite(), "org.eclipse.oomph.projectconfig.editor.commands.Navigate", "org.eclipse.oomph.projectconfig.editor.commands.Navigate", 0)));
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        this.addGlobalActionsGen(menuManager);
        this.updatePreferenceProfileReferencesAction.setEnabled(this.updatePreferenceProfileReferencesAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.updatePreferenceProfileReferencesAction);
        this.updatePreferenceProfileReferencesAction.setEnabled(this.applyPreferenceProfilesAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.applyPreferenceProfilesAction);
        menuManager.insertAfter("ui-actions", this.reloadEditorAction);
    }

    protected void addGlobalActionsGen(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

