/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class CalloutImplementorDyn {
    public static final char[] OT_ACCESS = "_OT$access".toCharArray();
    public static final char[] OT_ACCESS_STATIC = "_OT$accessStatic".toCharArray();

    public static Expression baseAccessExpression(Scope scope, RoleModel roleModel, ReferenceBinding baseType, Expression receiver, CalloutMappingDeclaration calloutDecl, Expression[] arguments, AstGenerator gen) {
        MethodSpec baseSpec = calloutDecl.baseMethodSpec;
        char[] selector = CalloutImplementorDyn.ensureAccessor((Scope)scope, (ReferenceBinding)baseType, (boolean)baseSpec.isStatic()).selector;
        TeamModel teamModel = roleModel.getTeamModel();
        TeamModel.UpdatableIntLiteral accessIdArg = gen.updatableIntLiteral(baseSpec.accessId);
        teamModel.recordUpdatableAccessId(accessIdArg);
        int i = 0;
        while (i < arguments.length) {
            TypeBinding type;
            Expression arg = arguments[i];
            if (arg instanceof PotentialLowerExpression && (type = ((PotentialLowerExpression)arg).expectedType) instanceof BaseTypeBinding) {
                arguments[i] = gen.createBoxing(arg, (BaseTypeBinding)type);
            }
            ++i;
        }
        int opKind = 0;
        if (baseSpec instanceof FieldAccessSpec && ((FieldAccessSpec)baseSpec).calloutModifier == 2) {
            opKind = 1;
        }
        IntLiteral opKindArg = gen.intLiteral(opKind);
        ArrayAllocationExpression packagedArgs = gen.arrayAllocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), 1, arguments);
        Expression callerArg = gen.qualifiedThisReference(gen.typeReference(teamModel.getBinding()));
        MessageSend messageSend = gen.messageSend(receiver, selector, new Expression[]{accessIdArg, opKindArg, packagedArgs, callerArg});
        if (baseSpec.resolvedType() == TypeBinding.VOID || opKind == 1) {
            return messageSend;
        }
        TypeBinding expectedType = calloutDecl.mappings != null || calloutDecl.roleMethodSpec.returnNeedsTranslation ? baseSpec.resolvedType() : calloutDecl.roleMethodSpec.resolvedType();
        return gen.createCastOrUnboxing((Expression)messageSend, expectedType, true);
    }

    public static MethodBinding ensureAccessor(Scope scope, ReferenceBinding baseType, boolean isStatic) {
        char[] selector;
        MethodBinding[] methods;
        if (baseType.isRoleType()) {
            baseType = baseType.getRealClass();
        }
        if ((methods = baseType.getMethods(selector = isStatic ? OT_ACCESS_STATIC : OT_ACCESS)) != null && methods.length == 1) {
            return methods[0];
        }
        int modifiers = 4097;
        if (isStatic) {
            modifiers |= 8;
        }
        MethodBinding method = new MethodBinding(modifiers, selector, scope.getJavaLangObject(), new TypeBinding[]{TypeBinding.INT, TypeBinding.INT, scope.environment().createArrayType(scope.getJavaLangObject(), 1), scope.getOrgObjectteamsITeam()}, Binding.NO_EXCEPTIONS, baseType);
        baseType.addMethod(method);
        return method;
    }
}

