/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;

public class ConstantPoolObject
implements ClassFileConstants {
    private int _type;
    private TypeBinding _typeBinding;
    private MethodBinding _methodBinding;
    private FieldBinding _fieldBinding;
    private String _string;
    private char[] _char;
    private int _int;
    private long _long;
    private float _float;
    private double _double;
    private int _index;

    public int getType() {
        return this._type;
    }

    public boolean isMethod() {
        return this._type == 10 || this._type == 11;
    }

    public boolean isField() {
        return this._type == 9;
    }

    public boolean isClass() {
        return this._type == 7;
    }

    public boolean isSpecificType(char[][] compoundName) {
        if (this._type != 7) {
            return false;
        }
        ReferenceBinding rb = (ReferenceBinding)this._typeBinding;
        return CharOperation.equals(compoundName, rb.compoundName);
    }

    public boolean isNonWideString() {
        return this._type == 8 && this._index < 256;
    }

    public ConstantPoolObject(int type, String string, int index) {
        this._type = type;
        this._string = string;
        this._index = index;
    }

    public ConstantPoolObject(int type, char[] _char) {
        this._type = type;
        this._char = _char;
    }

    public ConstantPoolObject(int type, int _int) {
        this._type = type;
        this._int = _int;
    }

    public ConstantPoolObject(int type, float _float) {
        this._type = type;
        this._float = _float;
    }

    public ConstantPoolObject(int type, long _long) {
        this._type = type;
        this._long = _long;
    }

    public ConstantPoolObject(int type, double _double) {
        this._type = type;
        this._double = _double;
    }

    public ConstantPoolObject(int type, TypeBinding _binding) {
        this._type = type;
        this._typeBinding = _binding;
        assert (this._typeBinding != null);
    }

    public ConstantPoolObject(int type, MethodBinding _binding) {
        this._type = type;
        this._methodBinding = _binding;
        assert (this._methodBinding != null);
    }

    public ConstantPoolObject(int type, FieldBinding _binding) {
        this._type = type;
        this._fieldBinding = _binding;
        assert (this._fieldBinding != null);
    }

    public int getInteger() {
        assert (this._type == 3);
        return this._int;
    }

    public long getLong() {
        assert (this._type == 5);
        return this._long;
    }

    public float getFloat() {
        assert (this._type == 4);
        return this._float;
    }

    public double getDouble() {
        assert (this._type == 6);
        return this._double;
    }

    public char[] getUtf8() {
        assert (this._type == 1);
        return this._char;
    }

    public String getString() {
        assert (this._type == 8);
        return this._string;
    }

    public TypeBinding getClassObject() {
        assert (this._type == 7);
        return this._typeBinding;
    }

    public MethodBinding getMethodRef() {
        assert (this._type == 10 || this._type == 11);
        return this._methodBinding;
    }

    public FieldBinding getFieldRef() {
        assert (this._type == 9);
        return this._fieldBinding;
    }

    public MethodBinding getInterfaceMethodRef() {
        assert (this._type == 11);
        return this._methodBinding;
    }

    public void setMethod(MethodBinding newMeth) {
        assert (this._type == 10);
        this._methodBinding = newMeth;
    }

    public boolean isIllegallyCopiedCtor() {
        assert (this._type == 10 || this._type == 11);
        if (!this._methodBinding.isConstructor()) {
            return false;
        }
        if (this._methodBinding.model == null) {
            return false;
        }
        return this._methodBinding.model.problemDetail == MethodModel.ProblemDetail.IllegalDefaultCtor;
    }

    public String toString() {
        Object str = "";
        switch (this.getType()) {
            case 3: {
                str = new String("Integer:") + new Integer(this._int).toString() + "\n";
                break;
            }
            case 5: {
                str = new String("Long:") + new Long(this._long).toString() + "\n";
                break;
            }
            case 4: {
                str = new String("Float:") + new Float(this._float).toString() + "\n";
                break;
            }
            case 6: {
                str = new String("Double:") + new Double(this._double).toString() + "\n";
                break;
            }
            case 1: {
                str = new String("Utf8:") + new String(this._char) + "\n";
                break;
            }
            case 8: {
                str = new String("String:") + this._string + "\n";
                break;
            }
            case 7: {
                str = new String("TypeBinding:") + this._typeBinding.toString() + "\n";
                break;
            }
            case 10: {
                str = new String("MethodBinding:") + this._methodBinding.toString() + " \n=>" + (this._methodBinding.declaringClass != null ? this._methodBinding.declaringClass.toString() : "") + "\n";
                break;
            }
            case 9: {
                str = new String("FieldBinding:") + this._fieldBinding.toString() + " \n=>" + (this._fieldBinding.declaringClass != null ? this._fieldBinding.declaringClass.toString() : "") + "\n";
                break;
            }
            case 11: {
                str = new String("Interface:MethodBinding:") + " \n=>" + (this._methodBinding.declaringClass != null ? this._methodBinding.declaringClass.toString() : "") + "\n";
            }
        }
        return str;
    }
}

