/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core.compiler;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;

public class OTNameUtils {
    private static final char[] SET = "set".toCharArray();
    private static final char[] GET = "get".toCharArray();

    public static boolean isPredicate(char[] selector) {
        if (!CharOperation.prefixEquals(IOTConstants.OT_DOLLAR_NAME, selector)) {
            return false;
        }
        return CharOperation.prefixEquals(IOTConstants.PREDICATE_METHOD_NAME, selector) || CharOperation.prefixEquals(IOTConstants.BASE_PREDICATE_PREFIX, selector);
    }

    public static char[] removeOTDelim(char[] typeName) {
        if (!CharOperation.contains(IOTConstants.OT_DELIM_NAME, typeName)) {
            return typeName;
        }
        char[] strippedName = new char[]{};
        int start = 0;
        int pos = CharOperation.indexOf(IOTConstants.OT_DELIM_NAME, typeName, true, start);
        while (pos > -1) {
            strippedName = CharOperation.concat(strippedName, CharOperation.subarray(typeName, start, pos));
            start = pos;
            pos = CharOperation.indexOf(IOTConstants.OT_DELIM_NAME, typeName, true, start + 1);
        }
        strippedName = CharOperation.concat(strippedName, CharOperation.subarray(typeName, start + IOTConstants.OT_DELIM_LEN, -1));
        return strippedName;
    }

    public static char[] accessorName(boolean isSetter, char[] fieldName) {
        if (fieldName == null) {
            return null;
        }
        char[] capitalized = new char[fieldName.length];
        System.arraycopy(fieldName, 0, capitalized, 0, fieldName.length);
        capitalized[0] = Character.toUpperCase(fieldName[0]);
        char[] prefix = isSetter ? SET : GET;
        return CharOperation.concat(prefix, capitalized);
    }

    public static String accessorName(boolean isSetter, String fieldName) {
        if (fieldName == null) {
            return null;
        }
        int len = fieldName.length();
        char[] accessor = new char[3 + len];
        System.arraycopy(isSetter ? SET : GET, 0, accessor, 0, 3);
        accessor[3] = Character.toUpperCase(fieldName.charAt(0));
        fieldName.getChars(1, len, accessor, 4);
        return String.valueOf(accessor);
    }

    public static boolean isTSuperMarkerInterface(char[] name) {
        if (name == null) {
            return false;
        }
        int lastDollar = CharOperation.lastIndexOf('$', name);
        if (lastDollar > -1) {
            name = CharOperation.subarray(name, lastDollar + 1, -1);
        }
        return CharOperation.prefixEquals(IOTConstants.TSUPER_OT_NAME, name);
    }

    public static boolean isTopConfined(String elementName) {
        char[] name = elementName.toCharArray();
        return CharOperation.equals(name, IOTConstants.ICONFINED) || CharOperation.equals(name, IOTConstants.OTCONFINED) || CharOperation.equals(name, IOTConstants.CONFINED);
    }

    public static boolean isPredefinedConfined(ReferenceBinding type) {
        switch (type.id) {
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                return true;
            }
        }
        return false;
    }
}

