/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.migration;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.objectteams.otdt.internal.pde.ui.OTPDEUIPlugin;

public class MigrationMarkers {
    private static final String PROBLEM_ID = "problemID";
    public static final int PROBLEM_ID_BUILDER = 1;
    public static final int PROBLEM_ID_NATURE = 2;
    public static final int PROBLEM_ID_OTEQUINOX_BUNDLE = 3;
    public static final int PROBLEM_ID_EXTENSIONPOINT = 4;
    private static final String SOURCE_ID_OTDT = "OTDT";

    public static void addProblemMarker(IResource resource, String message, int problemID) {
        MigrationMarkers.addProblemMarker(resource, message, problemID, -1);
    }

    public static void addProblemMarker(IResource resource, String message, int problemID, int lineNo) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.jdt.core.buildpath_problem");
            marker.setAttributes(new String[]{"message", "severity", "categoryId", PROBLEM_ID, "sourceId"}, new Object[]{message, new Integer(2), new Integer(10), new Integer(problemID), SOURCE_ID_OTDT});
            if (lineNo > -1) {
                marker.setAttribute("lineNumber", (Object)new Integer(lineNo));
            }
        }
        catch (CoreException ce) {
            OTPDEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.pde.ui", "Error setting problem marker", (Throwable)ce));
        }
    }

    public static void removeMarkers(IResource resource, int[] handledIDs) {
        try {
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker existingMarker = iMarkerArray[n2];
                if (existingMarker.getAttribute("categoryId", 0) == 10 && SOURCE_ID_OTDT.equals(existingMarker.getAttribute("sourceId"))) {
                    int id = existingMarker.getAttribute(PROBLEM_ID, 0);
                    int[] nArray = handledIDs;
                    int n3 = handledIDs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int handledID = nArray[n4];
                        if (handledID == id) {
                            existingMarker.delete();
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            OTPDEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.internal.pde.ui", "Error deleting problem markers", (Throwable)ce));
        }
    }

    public static int getProblemID(IMarker marker) {
        return marker.getAttribute(PROBLEM_ID, 0);
    }
}

