/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.quickfix.MarkerResolutionGenerator;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.AnnotatedTextToString;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

@Beta
public abstract class AbstractMultiQuickfixTest
extends AbstractEditorTest {
    @Inject
    protected MarkerResolutionGenerator markerResolutionGenerator;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    private static boolean WAS_AUTOBUILD;

    @BeforeClass
    public static void beforeClass() throws Exception {
        WAS_AUTOBUILD = IResourcesSetupUtil.setAutobuild(false);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IResourcesSetupUtil.setAutobuild(WAS_AUTOBUILD);
    }

    public void testMultiQuickfix(CharSequence initialText, CharSequence initialTextWithMarkers, CharSequence resultTextWithMarkers) {
        IFile file = this.dslFile(initialText);
        IMarker[] markers = this.getMarkers(file);
        this.assertContentsAndMarkers(file, markers, initialTextWithMarkers);
        this.applyQuickfixOnMultipleMarkers(markers);
        this.assertContentsAndMarkers(file, resultTextWithMarkers);
    }

    protected IFile dslFile(CharSequence content) {
        return this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
    }

    protected String getProjectName() {
        return "MultiQuickfixTestProject";
    }

    protected String getFileName() {
        return "multiquickfix";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected ICompletionProposal[] computeQuickAssistProposals(XtextEditor editor, String text) {
        int idx = editor.getDocument().get().indexOf(text);
        return this.computeQuickAssistProposals(editor, idx);
    }

    protected ICompletionProposal[] computeQuickAssistProposals(XtextEditor editor, int offset) {
        IResourcesSetupUtil.waitForBuild();
        XtextSourceViewer sourceViewer = (XtextSourceViewer)editor.getInternalSourceViewer();
        QuickAssistAssistant quickAssistAssistant = (QuickAssistAssistant)sourceViewer.getQuickAssistAssistant();
        IQuickAssistProcessor quickAssistProcessor = quickAssistAssistant.getQuickAssistProcessor();
        ICompletionProposal[] quickAssistProposals = quickAssistProcessor.computeQuickAssistProposals((IQuickAssistInvocationContext)new TextInvocationContext((ISourceViewer)sourceViewer, offset, -1));
        return quickAssistProposals;
    }

    protected IMarker[] getMarkers(IFile file) {
        IResourcesSetupUtil.waitForBuild();
        try {
            return file.findMarkers("org.eclipse.xtext.ui.check.fast", true, 2);
        }
        catch (CoreException e) {
            Exceptions.sneakyThrow((Throwable)e);
            return null;
        }
    }

    protected void assertContentsAndMarkers(IFile file, CharSequence expectation) {
        this.assertContentsAndMarkers(file, this.getMarkers(file), expectation);
    }

    protected void assertContentsAndMarkers(IFile file, IMarker[] markers, CharSequence expectation) {
        String actual = new AnnotatedTextToString().withFile(file).withMarkers(markers).toString().trim();
        String exp = expectation.toString().trim();
        Assert.assertEquals((Object)Strings.toUnixLineSeparator((CharSequence)exp), (Object)Strings.toUnixLineSeparator((CharSequence)actual));
    }

    protected void applyQuickfixOnMultipleMarkers(IMarker[] markers) {
        IMarker primaryMarker = markers[0];
        IMarkerResolution[] resolutions = this.markerResolutionGenerator.getResolutions(primaryMarker);
        Assert.assertEquals((long)1L, (long)resolutions.length);
        AbstractMultiQuickfixTest.assertTrue((boolean)(resolutions[0] instanceof WorkbenchMarkerResolution));
        WorkbenchMarkerResolution resolution = (WorkbenchMarkerResolution)resolutions[0];
        ArrayList others = Lists.newArrayList((Object[])resolution.findOtherMarkers(markers));
        AbstractMultiQuickfixTest.assertFalse((boolean)others.contains(primaryMarker));
        AbstractMultiQuickfixTest.assertEquals((long)(markers.length - 1), (long)others.size());
        others.add(primaryMarker);
        long seed = new Random().nextLong();
        System.out.println(seed);
        Collections.shuffle(others, new Random(seed));
        resolution.run(others.toArray(new IMarker[others.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    protected void applyQuickfixOnSingleMarkers(IMarker marker) {
        IMarkerResolution[] resolutions = this.markerResolutionGenerator.getResolutions(marker);
        Assert.assertEquals((long)1L, (long)resolutions.length);
        IMarkerResolution resolution = resolutions[0];
        resolution.run(marker);
    }

    protected IMarker getFirstMarker(IMarker[] markers) {
        IMarker firstMarker = (IMarker)Iterables.getFirst((Iterable)IterableExtensions.sortBy(Arrays.asList(markers), it -> {
            try {
                return (Integer)it.getAttribute("charStart");
            }
            catch (CoreException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }), null);
        return firstMarker;
    }
}

