/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.smoketest.processors;

import com.google.inject.Inject;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.InvariantChecker;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.testing.smoketest.DeltaScenarioProcessor;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.ReplaceRegion;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class PartialParsingProcessor
extends DeltaScenarioProcessor {
    private static final String DELIM = "\n----------------------\n";
    @Inject
    private IParser parser;

    @Override
    public String processFile(String completeData, String data, int offset, int len, String change) throws Exception {
        IParseResult initialParseResult = this.parser.parse((Reader)new StringReader(data));
        String newData = this.applyDelta(data, offset, len, change);
        ReplaceRegion replaceRegion = new ReplaceRegion(offset, len, change);
        try {
            IParseResult reparsed = this.parser.reparse(initialParseResult, replaceRegion);
            IParseResult parsedFromScratch = this.parser.parse((Reader)new StringReader(newData));
            this.assertEqual(data, newData, parsedFromScratch, reparsed);
            return newData;
        }
        catch (Throwable e) {
            ComparisonFailure throwMe = new ComparisonFailure(e.getMessage(), newData, replaceRegion + DELIM + data);
            throwMe.initCause(e);
            throw throwMe;
        }
    }

    private void assertEqual(String data, String newData, IParseResult parsedFromScratch, IParseResult reparsed) {
        EObject rootFromScratch = parsedFromScratch.getRootASTElement();
        EObject rootReparsed = reparsed.getRootASTElement();
        this.assertEqual(data, newData, EmfFormatter.objToStr((Object)rootFromScratch, (EStructuralFeature[])new EStructuralFeature[0]), EmfFormatter.objToStr((Object)rootReparsed, (EStructuralFeature[])new EStructuralFeature[0]));
        this.assertEqual(data, newData, parsedFromScratch.getRootNode(), reparsed.getRootNode());
    }

    private void assertEqual(String data, String newData, ICompositeNode fromScratch, ICompositeNode reparsed) {
        InvariantChecker checker = new InvariantChecker();
        checker.checkInvariant((INode)reparsed);
        BidiTreeIterator scratchIterator = fromScratch.getAsTreeIterable().iterator();
        BidiTreeIterator reparsedIterator = reparsed.getAsTreeIterable().iterator();
        while (scratchIterator.hasNext()) {
            Assert.assertTrue((boolean)reparsedIterator.hasNext());
            this.assertEqualNodes(data, newData, (INode)scratchIterator.next(), (INode)reparsedIterator.next());
        }
        Assert.assertFalse((boolean)scratchIterator.hasNext());
        Assert.assertFalse((boolean)reparsedIterator.hasNext());
    }

    private void assertEqualNodes(String data, String newData, INode node, INode other) {
        Assert.assertEquals(node.getClass(), other.getClass());
        if (node instanceof ILeafNode) {
            Assert.assertEquals((long)node.getTotalOffset(), (long)other.getTotalOffset());
            Assert.assertEquals((long)node.getTotalLength(), (long)other.getTotalLength());
        }
        Assert.assertEquals((Object)node.getGrammarElement(), (Object)other.getGrammarElement());
        Assert.assertEquals((Object)node.hasDirectSemanticElement(), (Object)other.hasDirectSemanticElement());
        Assert.assertEquals((Object)node.getSyntaxErrorMessage(), (Object)other.getSyntaxErrorMessage());
        if (node instanceof ICompositeNode) {
            Assert.assertEquals((long)((ICompositeNode)node).getLookAhead(), (long)((ICompositeNode)other).getLookAhead());
        }
    }

    private void assertEqual(String data, String newData, String parsedFromScratch, String reparsed) {
        if (!parsedFromScratch.equals(reparsed)) {
            throw new ComparisonFailure("Parsed EObjects are not equal", newData + DELIM + parsedFromScratch, data + DELIM + reparsed);
        }
    }
}

