/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.tests;

import java.io.IOException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.umlx.compiler.UMLXCompilerChain;
import org.eclipse.qvtd.umlx.tests.Forward2ReverseNormalizer;
import org.eclipse.qvtd.umlx.utilities.UMLXStandaloneSetup;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtrelation.tests.QVTrelationTestFileSystemHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UMLXCompilerTests
extends LoadTestCase {
    private static boolean NO_MERGES = true;

    protected @NonNull OCLInternal createOCL() {
        return QVTbase.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected @NonNull MyQVT createQVT(@NonNull String resultPrefix, @NonNull URI txURI) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(resultPrefix);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        return new QVTrelationTestFileSystemHelper();
    }

    @Before
    public void setUp() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        super.setUp();
        OCLstdlib.install();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            UMLXStandaloneSetup.doSetup();
        }
        XtextCompilerUtil.doQVTrelationSetup();
        XtextCompilerUtil.doQVTcoreSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testUMLXCompiler_Forward2Reverse_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.umlx"));
        try {
            txClass = myQVT1.buildTransformation("reverse", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 1);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.umlx"));
        try {
            myQVT2.loadEPackage(txClass, "doublylinkedlist.doublylinkedlistPackage");
            myQVT2.loadEPackage(txClass, "trace_Forward2Reverse.trace_Forward2ReversePackage");
            URI inURI = this.getModelsURI("forward2reverse/samples/EmptyList.xmi");
            URI outURI = this.getTestURI("generated_CG.xmi");
            URI expectedURI = this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", inURI);
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", outURI, expectedURI, Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("OneElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("TwoElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("ThreeElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testUMLXCompiler_HierarchicalStateMachine2FlatStateMachine_example_CG() throws Exception {
        Class txClass;
        URI txURI = this.getResourceURI("/org.eclipse.qvtd.examples.umlx.hstm2fstm/model/HierarchicalStateMachine2FlatStateMachine.umlx");
        MyQVT myQVT1 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", txURI);
        try {
            txClass = myQVT1.buildTransformation("flat", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", txURI);
        try {
            URI inURI = this.getResourceURI("/org.eclipse.qvtd.examples.umlx.hstm2fstm/model/in/hier.xmi");
            URI outURI = this.getTestURI("generated_CG.xmi");
            URI expectedURI = this.getResourceURI("/org.eclipse.qvtd.examples.umlx.hstm2fstm/model/out/expected.xmi");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", inURI);
            myQVT2.executeTransformation();
            myQVT2.saveOutput("flat", outURI, expectedURI, null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    protected class MyQVT
    extends AbstractTestQVT {
        public MyQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, URI binFileURI) throws IOException {
            super(projectManager, testProject, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
        }

        protected @NonNull UMLXCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            return new InstrumentedCompilerChain(this.getEnvironmentFactory(), txURI, intermediateFileNamePrefixURI, options);
        }

        protected @NonNull DefaultCompilerOptions createCompilerChainOptions() {
            DefaultCompilerOptions options = super.createCompilerChainOptions();
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_EARLY_MERGE, (Object)NO_MERGES);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE, (Object)NO_MERGES);
            return options;
        }

        protected boolean generateGenModel() {
            return true;
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.umlx.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager() throws Exception {
            return EMFPlugin.IS_ECLIPSE_RUNNING ? new ProjectMap(true) : UMLXCompilerTests.this.getTestProjectManager();
        }

        protected class InstrumentedCompilerChain
        extends UMLXCompilerChain {
            protected InstrumentedCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @Nullable URI intermediateFileNamePrefixURI, CompilerOptions options) {
                super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
            }

            protected // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull QVTrCompilerChain.QVTr2QVTsCompilerStep createQVTr2QVTsCompilerStep() {
                return new QVTrCompilerChain.QVTr2QVTsCompilerStep((CompilerChain)this){

                    public @NonNull ScheduleManager execute(@NonNull Resource qvtrResource, @NonNull Resource traceResource, @NonNull Iterable<@NonNull String> enforcedOutputNames) throws IOException {
                        ScheduleManager scheduleManager = super.execute(qvtrResource, traceResource, enforcedOutputNames);
                        MyQVT.this.instrumentPartition(scheduleManager);
                        return scheduleManager;
                    }
                };
            }
        }
    }
}

