/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.papyrus.infra.widgets.toolbox.dialog.InformationDialog;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.actions.GenericTransformer;
import org.eclipse.swt.widgets.Display;

public class GenericTransformAction
extends Action {
    private static final String ERROR_TITLE = "Impossible to continue transformation.";
    private static final String ERROR_MESSAGE = "The transformation can not continue.\nSome objects referencing your selection could not be able to reference the result of the transformation.\nFor UML and SysML, applied stereotypes could not be applicable on the result of the transformation.\nBefore performing the transformation please delete or unapply the elements listed bellow.";
    private static final String WARNING_TITLE = "Warning: transformation command";
    private static final String WARNING_MESSAGE = "You are trying to transform an element typed %s into %s.\nThis operation will copy all the common elements between the two eclasses.\nDo you want to continue ?";
    private EClass targetEClass = null;
    private EObject element;

    public GenericTransformAction(EClass transformationEClass, AdapterFactory adapterFactory, EObject elementToTransform) {
        super(transformationEClass.getName());
        this.targetEClass = transformationEClass;
        this.element = elementToTransform;
        if (adapterFactory != null) {
            EObject tmpEobject = transformationEClass.getEPackage().getEFactoryInstance().create(transformationEClass);
            IItemLabelProvider provider = (IItemLabelProvider)adapterFactory.adapt((Notifier)tmpEobject, IItemLabelProvider.class);
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(provider.getImage((Object)tmpEobject)));
        }
    }

    public void run() {
        GenericTransformer transformer = new GenericTransformer(this.element);
        MultiStatus messages = transformer.isTransformationPossible(this.targetEClass);
        if (messages != null && messages.getChildren().length == 0) {
            String message = String.format(WARNING_MESSAGE, this.element.eClass().getName(), this.targetEClass.getName());
            InformationDialog dialog = new InformationDialog(Display.getDefault().getActiveShell(), WARNING_TITLE, message, Activator.getDefault().getPreferenceStore(), "org.eclipse.papyrus.navigator.TransformInto.showPopupDialog", 192, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
            int result = dialog.open();
            if (result == 64 || result == 0) {
                transformer.transform(this.targetEClass);
            }
        } else {
            ErrorDialog errorDialog = new ErrorDialog(Display.getDefault().getActiveShell(), ERROR_TITLE, ERROR_MESSAGE, (IStatus)messages, 2);
            errorDialog.open();
        }
    }
}

