/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.DestructionOccurrenceSpecificationCreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.DurationCreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.GeneralOrderingCreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.OccurrenceSpecificationCreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.SpecificTypeCreationTool;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.UMLPaletteFactory;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineStateDefinitionCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomPaletteFactory
extends UMLPaletteFactory {
    private static final String CREATEOCCURRENCESPECIFICATIONCREATIONTOOL = "createOccurrenceSpecificationCreationTool";
    private static final String CREATEDESTRUCTIONOCCURRENCESPECIFICATIONCREATIONTOOL = "createDestructionOccurrenceSpecificationCreationTool";
    private static final String CREATESTATEDEFINITIONCREATIONTOOL = "createStateDefinitionCreationTool";
    private static final String CREATEMESSAGESYNCCREATIONTOOL = "createMessageSyncCreationTool";
    private static final String CREATEMESSAGEASYNCCREATIONTOOL = "createMessageAsyncCreationTool";
    private static final String CREATEMESSAGEREPLYCREATIONTOOL = "createMessageReplyCreationTool";
    private static final String CREATECREATEMESSAGECREATIONTOOL = "createCreateMessageCreationTool";
    private static final String CREATEDELETEMESSAGECREATIONTOOL = "createDeleteMessageCreationTool";
    private static final String CREATELOSTMESSAGECREATIONTOOL = "createLostMessageCreationTool";
    private static final String CREATEFOUNDMESSAGECREATIONTOOL = "createFoundMessageCreationTool";
    private static final String CREATETIMEOBSERVATIONCREATIONTOOL = "createTimeObservationCreationTool";
    private static final String CREATETIMECONSTRAINTCREATIONTOOL = "createTimeConstraintCreationTool";
    private static final String CREATEDURATIONOBSERVATIONCREATIONTOOL = "createDurationObservationCreationTool";
    private static final String CREATEDURATIONCONSTRAINTCREATIONTOOL = "createDurationConstraintCreationTool";
    private static final String CREATEGENERALORDERINGCREATIONTOOL = "createGeneralOrderingCreationTool";
    public static final String ORIGINAL_TARGET = "ORIGINAL_TARGET";

    @Override
    public Tool createTool(String toolId) {
        if (toolId.equals(CREATEOCCURRENCESPECIFICATIONCREATIONTOOL)) {
            return CustomPaletteFactory.createOccurrenceSpecificationCreationTool();
        }
        if (toolId.equals(CREATEDESTRUCTIONOCCURRENCESPECIFICATIONCREATIONTOOL)) {
            return CustomPaletteFactory.createDestructionOccurrenceSpecificationCreationTool();
        }
        if (toolId.equals(CREATESTATEDEFINITIONCREATIONTOOL)) {
            return CustomPaletteFactory.createStateDefinitionCreationTool();
        }
        if (toolId.equals(CREATEMESSAGESYNCCREATIONTOOL)) {
            return CustomPaletteFactory.createSyncMessageCreationTool();
        }
        if (toolId.equals(CREATEMESSAGEASYNCCREATIONTOOL)) {
            return CustomPaletteFactory.createAsyncMessageCreationTool();
        }
        if (toolId.equals(CREATEMESSAGEREPLYCREATIONTOOL)) {
            return CustomPaletteFactory.createReplyMessageCreationTool();
        }
        if (toolId.equals(CREATECREATEMESSAGECREATIONTOOL)) {
            return CustomPaletteFactory.createCreateMessageCreationTool();
        }
        if (toolId.equals(CREATEDELETEMESSAGECREATIONTOOL)) {
            return CustomPaletteFactory.createDeleteMessageCreationTool();
        }
        if (toolId.equals(CREATELOSTMESSAGECREATIONTOOL)) {
            return CustomPaletteFactory.createLostMessageCreationTool();
        }
        if (toolId.equals(CREATEFOUNDMESSAGECREATIONTOOL)) {
            return CustomPaletteFactory.createFoundMessageCreationTool();
        }
        if (toolId.equals(CREATETIMEOBSERVATIONCREATIONTOOL)) {
            return CustomPaletteFactory.createTimeObservationCreationTool();
        }
        if (toolId.equals(CREATETIMECONSTRAINTCREATIONTOOL)) {
            return CustomPaletteFactory.createTimeConstraintCreationTool();
        }
        if (toolId.equals(CREATEDURATIONOBSERVATIONCREATIONTOOL)) {
            return CustomPaletteFactory.createDurationObservationCreationTool();
        }
        if (toolId.equals(CREATEDURATIONCONSTRAINTCREATIONTOOL)) {
            return CustomPaletteFactory.createDurationConstraintCreationTool();
        }
        if (toolId.equals(CREATEGENERALORDERINGCREATIONTOOL)) {
            return CustomPaletteFactory.createNewGeneralOrderingCreationTool();
        }
        return super.createTool(toolId);
    }

    private static Tool createTimeObservationCreationTool() {
        return CustomPaletteFactory.createNewTimeTool(UMLElementTypes.TimeObservation_Shape);
    }

    private static Tool createTimeConstraintCreationTool() {
        return CustomPaletteFactory.createNewTimeTool(UMLElementTypes.TimeConstraint_Shape);
    }

    private static Tool createDurationObservationCreationTool() {
        return CustomPaletteFactory.createNewDurationTool(UMLElementTypes.DurationObservation_Shape);
    }

    private static Tool createDurationConstraintCreationTool() {
        return CustomPaletteFactory.createNewDurationTool(UMLElementTypes.DurationConstraint_Shape);
    }

    private static Tool createNewTimeTool(IElementType elementType) {
        return new AspectUnspecifiedTypeCreationTool(Collections.singletonList(elementType)){

            protected Command getCommand() {
                EditPart target = this.getTargetEditPart();
                CreateRequest request = this.getTargetRequest();
                if (target != null && EditPartUtils.isEditPartFor(target, UMLPackage.eINSTANCE.getOccurrenceSpecification(), UMLPackage.eINSTANCE.getStateInvariant())) {
                    Map extendedData = request.getExtendedData();
                    extendedData.put(CustomPaletteFactory.ORIGINAL_TARGET, target);
                    target = target.getParent();
                    return target.getCommand((Request)request);
                }
                return UnexecutableCommand.INSTANCE;
            }
        };
    }

    private static Tool createNewDurationTool(IElementType elementType) {
        return new DurationCreationTool(elementType);
    }

    private static Tool createOccurrenceSpecificationCreationTool() {
        return new OccurrenceSpecificationCreationTool();
    }

    private static Tool createDestructionOccurrenceSpecificationCreationTool() {
        return new DestructionOccurrenceSpecificationCreationTool();
    }

    private static Tool createNewGeneralOrderingCreationTool() {
        return new GeneralOrderingCreationTool();
    }

    private static Tool createStateDefinitionCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Node_StateDefinitionShape);
        AspectUnspecifiedTypeCreationTool tool = new AspectUnspecifiedTypeCreationTool(types){

            protected Command getCommand() {
                if (!(this.getTargetEditPart() instanceof FullLifelineStateDefinitionCompartmentEditPartCN)) {
                    return UnexecutableCommand.INSTANCE;
                }
                return super.getCommand();
            }
        };
        return tool;
    }

    private static Tool createSyncMessageCreationTool() {
        return new SpecificTypeCreationTool(UMLElementTypes.Message_SynchEdge, MessageUtils.getAllowedMessageTargets(), MessageUtils.getAllowedMessageTargets());
    }

    private static Tool createAsyncMessageCreationTool() {
        return new SpecificTypeCreationTool(UMLElementTypes.Message_AsynchEdge, MessageUtils.getAllowedMessageTargets(), MessageUtils.getAllowedMessageTargets());
    }

    private static Tool createReplyMessageCreationTool() {
        return new SpecificTypeCreationTool(UMLElementTypes.Message_ReplyEdge, MessageUtils.getAllowedMessageTargets(), MessageUtils.getAllowedMessageTargets());
    }

    private static Tool createCreateMessageCreationTool() {
        return new SpecificTypeCreationTool(UMLElementTypes.Message_CreateEdge, MessageUtils.getAllowedMessageTargets(), MessageUtils.getAllowedMessageTargets());
    }

    private static Tool createDeleteMessageCreationTool() {
        return new SpecificTypeCreationTool(UMLElementTypes.Message_DeleteEdge, MessageUtils.getAllowedMessageTargets(), MessageUtils.getAllowedMessageTargets());
    }

    private static Tool createLostMessageCreationTool() {
        return new AspectUnspecifiedTypeConnectionTool(Collections.singletonList(UMLElementTypes.Message_LostEdge)){

            protected Command getCommand() {
                Object type = this.getTargetRequest().getType();
                if ("connection end" == type) {
                    AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest request = (AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest)this.getTargetRequest();
                    EditPart sourceEditPart = request.getSourceEditPart();
                    IFigure figure = ((GraphicalEditPart)sourceEditPart).getFigure();
                    Point figureLocation = new Point(figure.getBounds().getCenter());
                    figure.getParent().translateToAbsolute((Translatable)figureLocation);
                    Point location = request.getLocation();
                    double scale = FigureUtils.getScale((IFigure)figure);
                    final Point anchorLocation = new Point(location.x - figureLocation.x, location.y - figureLocation.y).scale(1.0 / scale);
                    final Command superCommand = super.getCommand();
                    CompoundCommand compoundCommand = new CompoundCommand();
                    compoundCommand.add(superCommand);
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)sourceEditPart.getModel());
                    compoundCommand.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, Messages.CustomPaletteFactory_SetLostMessageOrigin, null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Connector connector = CustomPaletteFactory.findCreatedConnector(superCommand);
                            MessageUtils.setMessageConnectorLocation(connector, anchorLocation);
                            return CommandResult.newOKCommandResult();
                        }
                    }));
                    return compoundCommand;
                }
                return super.getCommand();
            }
        };
    }

    private static Tool createFoundMessageCreationTool() {
        return new AspectUnspecifiedTypeConnectionTool(Collections.singletonList(UMLElementTypes.Message_FoundEdge)){

            protected Command getCommand() {
                AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest request = (AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest)this.getTargetRequest();
                EditPart targetEditPart = request.getTargetEditPart();
                Object type = this.getTargetRequest().getType();
                if ("connection start" == type) {
                    MessageUtils.saveRequestStartLocation((CreateRequest)request);
                }
                if ("connection end" == type) {
                    Point startLocation = MessageUtils.retrieveRequestStartLocation((CreateRequest)request);
                    IFigure figure = ((GraphicalEditPart)targetEditPart).getFigure();
                    Point figureLocation = new Point(figure.getBounds().getCenter());
                    figure.getParent().translateToAbsolute((Translatable)figureLocation);
                    double scale = FigureUtils.getScale((IFigure)figure);
                    final Point anchorLocation = new Point(startLocation.x - figureLocation.x, startLocation.y - figureLocation.y).scale(1.0 / scale);
                    final Command superCommand = super.getCommand();
                    CompoundCommand compoundCommand = new CompoundCommand();
                    compoundCommand.add(superCommand);
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)targetEditPart.getModel());
                    compoundCommand.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, Messages.CustomPaletteFactory_SetFoundMessageTarget, null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Connector connector = CustomPaletteFactory.findCreatedConnector(superCommand);
                            MessageUtils.setMessageConnectorLocation(connector, anchorLocation);
                            return CommandResult.newOKCommandResult();
                        }
                    }));
                    return compoundCommand;
                }
                return super.getCommand();
            }
        };
    }

    protected static Connector findCreatedConnector(Command command) {
        ICommandProxy commandProxy;
        ICommand iCommand;
        CommandResult commandResult;
        Object returnValue;
        if (command instanceof ICommandProxy && (returnValue = (commandResult = (iCommand = (commandProxy = (ICommandProxy)command).getICommand()).getCommandResult()).getReturnValue()) instanceof List) {
            List resultList = (List)returnValue;
            for (Object resultElement : resultList) {
                CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor connectionViewAndElementDescriptor;
                View view;
                if (!(resultElement instanceof CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor) || !((view = (View)(connectionViewAndElementDescriptor = (CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor)resultElement).getAdapter(View.class)) instanceof Connector)) continue;
                Connector connector = (Connector)view;
                return connector;
            }
        }
        throw new IllegalStateException("connector not found");
    }
}

