/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;

class OperationOverrideMap {
    private Map<ImperativeOperation, ImperativeOperation> fMapping;

    OperationOverrideMap() {
    }

    public ImperativeOperation getOverridingOperation(ImperativeOperation overridden) {
        if (overridden == null) {
            throw new IllegalArgumentException();
        }
        return this.fMapping == null ? null : this.fMapping.get(overridden);
    }

    static Map<Module, OperationOverrideMap> create(Module mainModule) {
        HashMap<Module, OperationOverrideMap> module2OverrideMap = new HashMap<Module, OperationOverrideMap>(3);
        OperationOverrideMap.buildModuleOverrideMap(mainModule, module2OverrideMap);
        for (ModuleImport moduleImport : mainModule.getModuleImport()) {
            if (moduleImport.getKind() != ImportKind.EXTENSION) continue;
            Module importedModule = moduleImport.getImportedModule();
            OperationOverrideMap.inherit(mainModule, importedModule, module2OverrideMap);
        }
        module2OverrideMap.get(mainModule);
        return module2OverrideMap;
    }

    private static void buildModuleOverrideMap(Module module, Map<Module, OperationOverrideMap> modules2OverrideMap) {
        for (EOperation operation : module.getEOperations()) {
            ImperativeOperation overriding;
            ImperativeOperation overridden;
            if (!(operation instanceof ImperativeOperation) || (overridden = (overriding = (ImperativeOperation)operation).getOverridden()) == null) continue;
            OperationOverrideMap.pushUpOperation(overriding, overridden, modules2OverrideMap);
        }
        for (ModuleImport moduleImport : module.getModuleImport()) {
            if (moduleImport.getKind() != ImportKind.EXTENSION) continue;
            Module importedModule = moduleImport.getImportedModule();
            OperationOverrideMap.buildModuleOverrideMap(importedModule, modules2OverrideMap);
        }
    }

    private static void inherit(Module extending, Module extended, Map<Module, OperationOverrideMap> modules2OverrideMap) {
        for (ModuleImport moduleImport : extended.getModuleImport()) {
            if (moduleImport.getKind() != ImportKind.EXTENSION) continue;
            OperationOverrideMap.inherit(extended, moduleImport.getImportedModule(), modules2OverrideMap);
        }
        OperationOverrideMap extendedMap = modules2OverrideMap.get(extended);
        if (extendedMap != null) {
            OperationOverrideMap extendingMap = modules2OverrideMap.get(extending);
            if (extendingMap == null) {
                extendingMap = new OperationOverrideMap();
                modules2OverrideMap.put(extending, extendingMap);
            }
            extendingMap.merge(extendedMap);
        }
    }

    private static void pushUpOperation(ImperativeOperation overriding, ImperativeOperation overriden, Map<Module, OperationOverrideMap> tableMap) {
        ImperativeOperation existingOverride;
        Module extendedModule = (Module)overriden.getEContainingClass();
        OperationOverrideMap nextTable = tableMap.get(extendedModule);
        if (nextTable == null) {
            nextTable = new OperationOverrideMap();
            tableMap.put(extendedModule, nextTable);
        }
        if ((existingOverride = nextTable.getOverridingOperation(overriden)) != null) {
            return;
        }
        nextTable.add(overriden, overriding);
        if (overriden.getOverridden() != null) {
            OperationOverrideMap.pushUpOperation(overriding, overriden.getOverridden(), tableMap);
        }
    }

    private void merge(OperationOverrideMap mergedMap) {
        if (this.fMapping == null) {
            this.fMapping = new HashMap<ImperativeOperation, ImperativeOperation>();
        }
        if (mergedMap != null) {
            this.fMapping.putAll(mergedMap.fMapping);
        }
    }

    private void add(ImperativeOperation overriden, ImperativeOperation overriding) {
        if (this.fMapping == null) {
            this.fMapping = new HashMap<ImperativeOperation, ImperativeOperation>();
        }
        this.fMapping.put(overriden, overriding);
    }
}

