/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class CompositeReconcilerStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextViewerLifecycle {
    private List<IReconcilingStrategy> fReconcilingStrategies;

    public CompositeReconcilerStrategy(List<IReconcilingStrategy> strategies) {
        this.fReconcilingStrategies = strategies;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)strategy).setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)strategy).initialReconcile();
        }
    }

    public void setDocument(IDocument document) {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            strategy.setDocument(document);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            strategy.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            strategy.reconcile(partition);
        }
    }

    public void install(ITextViewer textViewer) {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            if (!(strategy instanceof ITextViewerLifecycle)) continue;
            ((ITextViewerLifecycle)strategy).install(textViewer);
        }
    }

    public void uninstall() {
        for (IReconcilingStrategy strategy : this.fReconcilingStrategies) {
            if (!(strategy instanceof ITextViewerLifecycle)) continue;
            ((ITextViewerLifecycle)strategy).uninstall();
        }
    }
}

