/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.LabelUtils;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ParameterLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Reception;

public class ReceptionLabelHelper {
    private final ParameterLabelHelper parameterLabelHelper;
    private final VisibilityLabelHelper visibilityLabelHelper;
    private final INamedElementNameProvider namedElementNameProvider;

    public ReceptionLabelHelper(ParameterLabelHelper parameterLabelHelper, VisibilityLabelHelper visibilityLabelHelper, INamedElementNameProvider namedElementNameProvider) {
        this.parameterLabelHelper = Objects.requireNonNull(parameterLabelHelper);
        this.visibilityLabelHelper = Objects.requireNonNull(visibilityLabelHelper);
        this.namedElementNameProvider = Objects.requireNonNull(namedElementNameProvider);
    }

    public String getLabel(Reception reception) {
        String receptionLabel = LabelUtils.getNonNullString(this.visibilityLabelHelper.getVisibilityAsSign((NamedElement)reception)) + " ";
        String parameters = this.getInnerParameters(reception);
        return receptionLabel + this.namedElementNameProvider.getName((NamedElement)reception) + parameters;
    }

    private String getInnerParameters(Reception reception) {
        return reception.getOwnedParameters().stream().filter(p -> !ParameterDirectionKind.RETURN_LITERAL.equals((Object)p.getDirection())).map(this::computeOperationParameterLabel).collect(Collectors.joining(", ", "(", ")"));
    }

    private String computeOperationParameterLabel(Parameter parameter) {
        return this.parameterLabelHelper.getLabel(parameter);
    }
}

