/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class PackageInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    private static final String UNAUTHORIZED_DND_ERROR_MSG = "DnD is not authorized.";
    private static final String DROP_ERROR_MSG = "{0} can only be drag and drop on {1}.";
    private static final String COMA = ", ";

    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new PackageDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class PackageDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject newSemanticContainer;

        PackageDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no(this.canOnlyDropOnPackageAndModelMessage((EObject)comment));
            return result;
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no(this.canOnlyDropOnPackageAndModelMessage((EObject)constraint));
            return result;
        }

        public CheckStatus casePackage(Package pkg) {
            CheckStatus result = this.newSemanticContainer instanceof Package ? CheckStatus.YES : CheckStatus.no(this.canOnlyDropOnPackageAndModelMessage((EObject)pkg));
            return result;
        }

        private String canOnlyDropOnPackageAndModelMessage(EObject object) {
            return MessageFormat.format(PackageInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, object.eClass().getName(), UMLPackage.eINSTANCE.getPackage().getName() + PackageInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getModel().getName());
        }

        public CheckStatus caseElement(Element element) {
            return CheckStatus.no(PackageInternalSourceToRepresentationDropChecker.UNAUTHORIZED_DND_ERROR_MSG);
        }
    }
}

