/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class UpdateWeakReferenceForExecSpecEditPolicy
extends UpdateWeakReferenceEditPolicy {
    public static final String UDPATE_WEAK_REFERENCE_FOR_EXECSPEC = "UpdateWeakReferenceForExecSpecEditPolicy";

    public Command getCommand(Request request) {
        Command command = null;
        if (!SenderRequestUtils.isASender(request, (EditPart)this.getHost()) && request instanceof ChangeBoundsRequest && !"autosize".equals(request.getType()) && this.getHost() instanceof AbstractExecutionSpecificationEditPart) {
            command = this.getUpdateWeakRefForExecSpecResize((ChangeBoundsRequest)request);
        }
        return command == null ? super.getCommand(request) : command;
    }

    private Command getUpdateWeakRefForExecSpecCreate(CreateViewAndElementRequest request) {
        CompoundCommand command = null;
        CreateViewAndElementRequest createRequest = request;
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "Execution Specification creation request at:" + String.valueOf(((View)this.getHost().getAdapter(View.class)).getElement()));
        createRequest.setLocation((Point)SequenceUtil.getSnappedLocation((EditPart)this.getHost(), createRequest.getLocation()));
        Point reqlocationOnScreen = createRequest.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)reqlocationOnScreen);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "=> Request Location on screen: " + String.valueOf(reqlocationOnScreen));
        ArrayList<OccurrenceSpecification> nextEventsFromPosition = new ArrayList<OccurrenceSpecification>();
        ArrayList<OccurrenceSpecification> previousEventsFromPosition = new ArrayList<OccurrenceSpecification>();
        GraphicalEditPart host = this.getHost();
        if (host instanceof LifelineEditPart) {
            nextEventsFromPosition.addAll(LifelineEditPartUtil.getNextEventsFromPosition(reqlocationOnScreen.getCopy().translate(0, GridManagementEditPolicy.threshold), (LifelineEditPart)host));
            previousEventsFromPosition.addAll(LifelineEditPartUtil.getPreviousEventsFromPosition(new Point(reqlocationOnScreen.x, reqlocationOnScreen.y + deltaMoveAtCreationAndDeletion + AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT), (LifelineEditPart)host));
        }
        nextEventsFromPosition.retainAll(previousEventsFromPosition);
        if (!nextEventsFromPosition.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            OccurrenceSpecification nextEvent = (OccurrenceSpecification)nextEventsFromPosition.get(0);
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\tNext Event: " + String.valueOf(nextEvent));
            ArrayList<EditPart> senderList = SenderRequestUtils.getSenders((Request)request);
            ArrayList connectionsAndChildren = new ArrayList();
            connectionsAndChildren.addAll(host.getSourceConnections());
            connectionsAndChildren.addAll(host.getTargetConnections());
            connectionsAndChildren.addAll(host.getChildren());
            for (Object editPart : connectionsAndChildren) {
                EObject element;
                Point moveDelta;
                if (editPart instanceof ConnectionEditPart) {
                    EObject message = ((View)((AbstractMessageEditPart)editPart).getAdapter(View.class)).getElement();
                    if ((!(message instanceof Message) || ((Message)message).getSendEvent() == null || !((Message)message).getSendEvent().equals(nextEvent)) && (!(message instanceof Message) || ((Message)message).getReceiveEvent() == null || !((Message)message).getReceiveEvent().equals(nextEvent))) continue;
                    moveDelta = new Point(0, 0);
                    PolylineConnectionEx polyline = (PolylineConnectionEx)((ConnectionEditPart)editPart).getFigure();
                    Point anchorPositionOnScreen = ((Message)message).getSendEvent().equals(nextEvent) ? polyline.getTargetAnchor().getReferencePoint() : polyline.getSourceAnchor().getReferencePoint();
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tanchorPositionOnScreen:\t" + String.valueOf(anchorPositionOnScreen));
                    Point newLocation = new Point(0, createRequest.getLocation().y + AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT + deltaMoveAtCreationAndDeletion);
                    newLocation = SequenceUtil.getSnappedLocation((EditPart)this.getHost(), newLocation);
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tNew location to be set:\t" + String.valueOf(newLocation));
                    moveDelta.y = newLocation.y - anchorPositionOnScreen.y;
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tMoveDela:\t\t" + moveDelta.y);
                    UpdateWeakReferenceForExecSpecEditPolicy.moveTargetConnectionEditPart(null, moveDelta, compoundCommand, (ConnectionEditPart)editPart, senderList);
                    UpdateWeakReferenceForExecSpecEditPolicy.moveSourceConnectionEditPart(null, moveDelta, compoundCommand, (ConnectionEditPart)editPart, senderList);
                    continue;
                }
                if (!(editPart instanceof AbstractExecutionSpecificationEditPart) || !((element = ((View)((AbstractExecutionSpecificationEditPart)((Object)editPart)).getAdapter(View.class)).getElement()) instanceof ExecutionSpecification) || ((ExecutionSpecification)element).getStart() == null || !((ExecutionSpecification)element).getStart().equals(nextEvent)) continue;
                moveDelta = new Point(0, 0);
                Point figureLocation = ((AbstractExecutionSpecificationEditPart)((Object)editPart)).getFigure().getBounds().getLocation();
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tlocationOfFigure:\t" + String.valueOf(figureLocation));
                Point newLocation = new Point(0, reqlocationOnScreen.y + AbstractExecutionSpecificationEditPart.DEFAUT_HEIGHT + deltaMoveAtCreationAndDeletion);
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tNew location to be set:\t" + String.valueOf(newLocation));
                moveDelta.y = newLocation.y - figureLocation.y;
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "\t\tMoveDela:\t\t" + moveDelta.y);
                UpdateWeakReferenceForExecSpecEditPolicy.moveRoundedEditPart(null, moveDelta, compoundCommand, (EditPart)editPart, senderList);
            }
            if (!compoundCommand.isEmpty()) {
                command = compoundCommand;
            }
        }
        return command;
    }

    private Command getUpdateWeakRefForExecSpecResize(ChangeBoundsRequest request) {
        CompoundCommand compoundCommand = new CompoundCommand();
        Point nextLocation = request.getLocation();
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE at " + String.valueOf(nextLocation) + " of " + String.valueOf(this.getHost()));
        PrecisionRectangle locationAndSize = new PrecisionRectangle(this.getHostFigure().getBounds());
        Point moveDelta = new Point(0, 0);
        if ("move".equals(request.getType())) {
            moveDelta = request.getMoveDelta();
        } else if ("resize".equals(request.getType())) {
            moveDelta = new Point(0, request.getSizeDelta().height + request.getMoveDelta().y);
        }
        if (moveDelta.y != 0 && this.mustMove) {
            if (this.getHost() instanceof AbstractExecutionSpecificationEditPart) {
                this.getHostFigure().translateToAbsolute((Translatable)locationAndSize);
                locationAndSize = request.getTransformedRectangle((Rectangle)locationAndSize);
            }
            if (this.getHost().getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)this.getHost().getEditPolicy((Object)"SEQUENCE_REFERENCE");
                if (!SenderRequestUtils.isASender((Request)request, (EditPart)this.getHost())) {
                    HashMap<EditPart, String> weakReferences = new HashMap<EditPart, String>();
                    if (moveDelta.y > 0 && this.mustMoveBelowAtMovingDown) {
                        weakReferences.putAll(references.getWeakReferences());
                    }
                    for (EditPart editPart : weakReferences.keySet()) {
                        if (SenderRequestUtils.isASender((Request)request, editPart)) continue;
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move of " + moveDelta.y + " " + String.valueOf(editPart));
                        ArrayList<EditPart> senderList = SenderRequestUtils.getSenders((Request)request);
                        if (editPart instanceof ConnectionEditPart) {
                            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                            UpdateWeakReferenceEditPolicy.moveSourceConnectionEditPart((EditPart)this.getHost(), moveDelta, compoundCommand, connectionEditPart, senderList);
                            UpdateWeakReferenceEditPolicy.moveTargetConnectionEditPart((EditPart)this.getHost(), moveDelta, compoundCommand, connectionEditPart, senderList);
                        }
                        if (!(editPart instanceof RoundedCompartmentEditPart)) continue;
                        UpdateWeakReferenceEditPolicy.moveRoundedEditPart((EditPart)this.getHost(), moveDelta, compoundCommand, editPart, senderList);
                    }
                }
            }
        }
        return compoundCommand.isEmpty() ? null : compoundCommand;
    }

    private Command getUpdateWeakRefForExecSpecDelete(EditCommandRequestWrapper request) {
        CompoundCommand command = null;
        AbstractExecutionSpecificationEditPart hostConnectionEditPart = (AbstractExecutionSpecificationEditPart)this.getHost();
        Point moveDelta = new Point(0, -hostConnectionEditPart.getPrimaryShape().getBounds().height);
        if (moveDelta.y < 0 && hostConnectionEditPart.getEditPolicy("SEQUENCE_REFERENCE") != null) {
            SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)hostConnectionEditPart.getEditPolicy("SEQUENCE_REFERENCE");
            if (!SenderRequestUtils.isASender((Request)request, (EditPart)this.getHost())) {
                CompoundCommand compoundCommand = new CompoundCommand();
                HashMap<EditPart, String> weakReferences = new HashMap<EditPart, String>();
                weakReferences.putAll(references.getWeakReferences());
                for (EditPart editPart : weakReferences.keySet()) {
                    if (!SenderRequestUtils.isASender((Request)request, editPart)) {
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move " + String.valueOf(editPart));
                        ArrayList<EditPart> senderList = SenderRequestUtils.getSenders((Request)request);
                        if (editPart instanceof ConnectionEditPart) {
                            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                            UpdateWeakReferenceEditPolicy.moveSourceConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                            UpdateWeakReferenceEditPolicy.moveTargetConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                        }
                        if (editPart instanceof RoundedCompartmentEditPart) {
                            UpdateWeakReferenceEditPolicy.moveRoundedEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, editPart, senderList);
                        }
                    }
                    if (compoundCommand.isEmpty()) continue;
                    command = compoundCommand;
                }
            }
        }
        return command;
    }
}

