/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters;

public interface IControlModeManager {
    public ICommand getControlCommand(ControlModeRequest var1);

    public ICommand getUncontrolCommand(ControlModeRequest var1);

    default public ICommand getShardModeCommand(ControlModeRequest request) {
        Command baseCommand;
        if (!request.isControlRequest()) {
            throw new IllegalArgumentException("not a control request");
        }
        if (request.getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.CreateShard") == null) {
            throw new IllegalArgumentException("no shard mode parameter in request");
        }
        if (request.getTargetObject() == null) {
            throw new IllegalArgumentException("no target object in request");
        }
        final EObject object = request.getTargetObject();
        Throwable throwable = null;
        Object var5_5 = null;
        try (ShardResourceHelper helper = new ShardResourceHelper(object);){
            baseCommand = helper.getSetShardCommand(ControlModeRequestParameters.isCreateShard(request));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new EMFtoGMFCommandWrapper(baseCommand){

            public List getAffectedFiles() {
                return Arrays.asList(WorkspaceSynchronizer.getFile((Resource)object.eResource()));
            }
        };
    }

    default public Diagnostic approveRequest(ControlModeRequest request) {
        return Diagnostic.OK_INSTANCE;
    }

    default public boolean canCreateSubmodel(EObject objectToControl) {
        return true;
    }
}

