/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.generator;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.StringVersion;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Version;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.Template2StructureRegistry;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping.TemplateToStructureMappingService;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;

public abstract class AbstractDocumentStructureGenerator
implements ITemplate2StructureGenerator {
    @Override
    public Document generate(DocumentTemplate docTemplate, Object documentVersion, IModel2DocLogger logger) {
        if (!this.handles(docTemplate)) {
            logger.warn(NLS.bind((String)"The generator {0} is not able to create the document structure for {1}.", (Object)this.getClass().getSimpleName(), (Object)docTemplate.toString()));
            return null;
        }
        List<AbstractTemplateToStructureMapper<?>> mappers = Template2StructureRegistry.INSTANCE.getMappers(docTemplate);
        if (mappers.isEmpty()) {
            return null;
        }
        TemplateToStructureMappingService service = new TemplateToStructureMappingService(mappers);
        List<Document> result = service.map((EObject)docTemplate, null, Document.class, logger);
        if (result.isEmpty()) {
            return null;
        }
        Assert.isTrue((result.size() >= 1 ? 1 : 0) != 0, (String)"The generation contains more than one object as result");
        EObject res = (EObject)result.iterator().next();
        Assert.isTrue((boolean)(res instanceof Document), (String)"The result of the transformation is not Document.");
        Document generatedDocument = (Document)res;
        if (documentVersion != null) {
            if (documentVersion instanceof String) {
                generatedDocument.setVersion(this.createVersionFromString((String)documentVersion));
            } else if (documentVersion instanceof Version) {
                generatedDocument.setVersion((Version)documentVersion);
            }
            this.updateGeneratedDocumentName(generatedDocument);
        }
        return generatedDocument;
    }

    protected Version createVersionFromString(String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        StringVersion stringVersion = DocumentStructureFactory.eINSTANCE.createStringVersion();
        stringVersion.setVersion(version);
        return stringVersion;
    }

    protected void updateGeneratedDocumentName(Document document) {
        String stringVersion;
        Version version = document.getVersion();
        if (version != null && (stringVersion = version.getVersion()) != null && !stringVersion.isEmpty()) {
            IDocumentGeneratorConfiguration conf = document.getDocumentGeneratorConfiguration();
            String documentName = conf.getDocumentName();
            if (documentName == null) {
                documentName = "no_document_name";
            }
            StringBuilder documentNameBuilder = new StringBuilder(conf.getDocumentName());
            documentNameBuilder.append("_");
            documentNameBuilder.append(stringVersion);
            conf.setDocumentName(documentNameBuilder.toString());
        }
    }

    @Override
    public String getGenerateMenuLabel() {
        return "Structure";
    }
}

