/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.parametric.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Graph<T> {
    private int v;
    private LinkedList<Integer>[] adj;
    protected Map<Integer, T> index2Object = new HashMap<Integer, T>();
    protected Map<T, Integer> object2Index = new HashMap<T, Integer>();

    public Graph(Set<T> vertices, Map<T, Set<T>> edges) {
        this.v = vertices.size();
        this.adj = new LinkedList[this.v];
        int i = 0;
        while (i < this.v) {
            this.adj[i] = new LinkedList();
            ++i;
        }
        i = 0;
        for (T obj : vertices) {
            this.index2Object.put(i, obj);
            this.object2Index.put(obj, i);
            ++i;
        }
        for (T obj : vertices) {
            int objIndex = this.object2Index.get(obj);
            if (edges.get(obj) == null) continue;
            for (T connectedTo : edges.get(obj)) {
                this.addEdge(objIndex, this.object2Index.get(connectedTo));
            }
        }
    }

    public Graph(int v) {
        this.v = v;
        this.adj = new LinkedList[v];
        int i = 0;
        while (i < v) {
            this.adj[i] = new LinkedList();
            ++i;
        }
    }

    void addEdge(int v, int w) {
        this.adj[v].add(w);
    }

    void topologicalSortUtil(int v, boolean[] visited, Stack<Integer> stack) {
        visited[v] = true;
        for (Integer i : this.adj[v]) {
            if (visited[i]) continue;
            this.topologicalSortUtil(i, visited, stack);
        }
        stack.push(new Integer(v));
    }

    public List<T> topologicalSort() {
        Stack<Integer> stack = new Stack<Integer>();
        boolean[] visited = new boolean[this.v];
        int i = 0;
        while (i < this.v) {
            visited[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.v) {
            if (!visited[i]) {
                this.topologicalSortUtil(i, visited, stack);
            }
            ++i;
        }
        ArrayList<T> sorted = new ArrayList<T>();
        while (!stack.empty()) {
            int index = stack.pop();
            T obj = this.index2Object.get(index);
            sorted.add(obj);
        }
        return sorted;
    }

    public boolean isCyclicUtil(int v, boolean[] visited, boolean[] recStack) {
        if (!visited[v]) {
            visited[v] = true;
            recStack[v] = true;
            for (Integer i : this.adj[v]) {
                if (!visited[i] && this.isCyclicUtil(i, visited, recStack)) {
                    return true;
                }
                if (!recStack[i]) continue;
                return true;
            }
        }
        recStack[v] = false;
        return false;
    }

    public boolean isCyclic() {
        boolean[] visited = new boolean[this.v];
        boolean[] recStack = new boolean[this.v];
        int i = 0;
        while (i < this.v) {
            visited[i] = false;
            recStack[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.v) {
            if (this.isCyclicUtil(i, visited, recStack)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

