/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.parametric.semantics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Object;
import org.eclipse.papyrus.moka.composites.Semantics.impl.Loci.LociL3.CS_Locus;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.parametric.semantics.ConstraintObject;
import org.eclipse.papyrus.moka.parametric.semantics.ParametricObject;
import org.eclipse.papyrus.moka.parametric.utils.IConstraintObjectFactory;
import org.eclipse.papyrus.moka.parametric.utils.NameUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ParametricLocus
extends CS_Locus {
    protected static List<IConstraintObjectFactory> registeredFactories;

    protected IConstraintObjectFactory getConstraintObjectFactory(Class constraintType) {
        if (registeredFactories == null) {
            this.instantiateConstraintObjectFactories();
        }
        for (IConstraintObjectFactory f : registeredFactories) {
            if (!f.canInstantiateConstraintObject(constraintType)) continue;
            return f;
        }
        return null;
    }

    protected void instantiateConstraintObjectFactories() {
        registeredFactories = new ArrayList<IConstraintObjectFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(NameUtils.MOKA_CONSTRAINTOBJECTFACTORY_EXT_POINT);
        try {
            int i = 0;
            while (i < config.length) {
                Object o = config[i].createExecutableExtension("class");
                registeredFactories.add((IConstraintObjectFactory)o);
                ++i;
            }
        }
        catch (CoreException ex) {
            Activator.log.equals((Object)ex);
        }
        catch (Exception ex) {
            Activator.log.equals(ex);
        }
    }

    public IObject_ instantiate(Class type) {
        CS_Object object = null;
        IConstraintObjectFactory constraintObjectFactory = this.getConstraintObjectFactory(type);
        if (constraintObjectFactory != null) {
            object = constraintObjectFactory.instantiate(type);
            object.addType(type);
            object.createFeatureValues();
            this.add((IExtensionalValue)object);
        } else if (ConstraintObject.isCompositeConstraint(type)) {
            object = new ConstraintObject();
            object.addType(type);
            object.createFeatureValues();
            this.add((IExtensionalValue)object);
        } else if (ParametricLocus.isParametricBlock(type)) {
            object = new ParametricObject();
            object.addType(type);
            object.createFeatureValues();
            this.add((IExtensionalValue)object);
        } else {
            object = super.instantiate(type);
        }
        return object;
    }

    public static boolean isParametricBlock(Class type) {
        if (type.getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) != null) {
            return false;
        }
        boolean containsConstraintProperties = false;
        boolean containsParts = false;
        int i = 0;
        while (!(i >= type.getAttributes().size() || containsConstraintProperties && containsParts)) {
            Property p = (Property)type.getAttributes().get(i);
            Type t = p.getType();
            if (t != null) {
                if (t.getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) != null) {
                    containsConstraintProperties = true;
                } else {
                    containsParts = true;
                }
            }
            ++i;
        }
        return containsConstraintProperties && containsParts;
    }

    public static boolean isDataSource(Classifier type) {
        return type instanceof DataType && type.getAppliedStereotype(NameUtils.DATAVISUALIZATION_DATASOURCE_STEREOTYPE_NAME) != null;
    }
}

