/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.parametric.semantics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.parametric.semantics.BindingLink;
import org.eclipse.papyrus.moka.parametric.semantics.ConstraintObject;
import org.eclipse.papyrus.moka.parametric.semantics.IEvaluable;
import org.eclipse.papyrus.moka.parametric.semantics.UpdateDescriptor;
import org.eclipse.papyrus.moka.parametric.utils.Graph;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;

public class EvaluationGraph {
    protected IEvaluable context;
    protected Map<ConstraintObject, Set<ConstraintObject>> graphDependencies = new HashMap<ConstraintObject, Set<ConstraintObject>>();
    protected Set<ConstraintObject> allConstraintObjects = new HashSet<ConstraintObject>();
    protected Map<ConstraintObject, List<UpdateDescriptor>> preEvaluateUpdatesMap = new HashMap<ConstraintObject, List<UpdateDescriptor>>();
    protected Map<ConstraintObject, List<UpdateDescriptor>> postEvaluateUpdatesMap = new HashMap<ConstraintObject, List<UpdateDescriptor>>();
    private List<ConstraintObject> sorted;

    public EvaluationGraph(IEvaluable context) {
        this.context = context;
        for (BindingLink b : context.getBindingLinks()) {
            List<UpdateDescriptor> updates;
            UpdateDescriptor updateDescriptor;
            ConnectorEnd end1 = (ConnectorEnd)b.bindingConnector.getEnds().get(0);
            ConnectorEnd end2 = (ConnectorEnd)b.bindingConnector.getEnds().get(1);
            IObject_ obj1 = b.getFirstObjectFromPropertyPath(end1);
            IObject_ obj2 = b.getFirstObjectFromPropertyPath(end2);
            if (this.isConstraintObject(obj1) && !this.isConstraintObject(obj2)) {
                this.allConstraintObjects.add((ConstraintObject)obj1);
                if (((ConstraintObject)obj1).isInputParam((Property)end1.getRole())) {
                    UpdateDescriptor updateDescriptor2 = new UpdateDescriptor(b, end2, end1);
                    List<UpdateDescriptor> updates2 = this.preEvaluateUpdatesMap.get(obj1);
                    if (updates2 == null) {
                        updates2 = new ArrayList<UpdateDescriptor>();
                        this.preEvaluateUpdatesMap.put((ConstraintObject)obj1, updates2);
                    }
                    updates2.add(updateDescriptor2);
                    continue;
                }
                UpdateDescriptor updateDescriptor3 = new UpdateDescriptor(b, end1, end2);
                List<UpdateDescriptor> updates3 = this.postEvaluateUpdatesMap.get(obj1);
                if (updates3 == null) {
                    updates3 = new ArrayList<UpdateDescriptor>();
                    this.postEvaluateUpdatesMap.put((ConstraintObject)obj1, updates3);
                }
                updates3.add(updateDescriptor3);
                continue;
            }
            if (!this.isConstraintObject(obj1) && this.isConstraintObject(obj2)) {
                this.allConstraintObjects.add((ConstraintObject)obj2);
                if (((ConstraintObject)obj2).isInputParam((Property)end2.getRole())) {
                    UpdateDescriptor updateDescriptor4 = new UpdateDescriptor(b, end1, end2);
                    List<UpdateDescriptor> updates4 = this.preEvaluateUpdatesMap.get(obj2);
                    if (updates4 == null) {
                        updates4 = new ArrayList<UpdateDescriptor>();
                        this.preEvaluateUpdatesMap.put((ConstraintObject)obj2, updates4);
                    }
                    updates4.add(updateDescriptor4);
                    continue;
                }
                UpdateDescriptor updateDescriptor5 = new UpdateDescriptor(b, end2, end1);
                List<UpdateDescriptor> updates5 = this.postEvaluateUpdatesMap.get(obj2);
                if (updates5 == null) {
                    updates5 = new ArrayList<UpdateDescriptor>();
                    this.postEvaluateUpdatesMap.put((ConstraintObject)obj2, updates5);
                }
                updates5.add(updateDescriptor5);
                continue;
            }
            if (!this.isConstraintObject(obj1) || !this.isConstraintObject(obj2)) continue;
            this.allConstraintObjects.add((ConstraintObject)obj1);
            this.allConstraintObjects.add((ConstraintObject)obj2);
            boolean end1IsAnInputParam = ((ConstraintObject)obj1).isInputParam((Property)end1.getRole());
            boolean end2isAnInputParam = ((ConstraintObject)obj2).isInputParam((Property)end2.getRole());
            if (end1IsAnInputParam && end2isAnInputParam || !end1IsAnInputParam && !end2isAnInputParam) continue;
            if (end1IsAnInputParam) {
                this.addDependency((ConstraintObject)obj2, (ConstraintObject)obj1);
                updateDescriptor = new UpdateDescriptor(b, end2, end1);
                updates = this.postEvaluateUpdatesMap.get(obj2);
                if (updates == null) {
                    updates = new ArrayList<UpdateDescriptor>();
                    this.postEvaluateUpdatesMap.put((ConstraintObject)obj2, updates);
                }
                updates.add(updateDescriptor);
                continue;
            }
            if (!end2isAnInputParam) continue;
            this.addDependency((ConstraintObject)obj1, (ConstraintObject)obj2);
            updateDescriptor = new UpdateDescriptor(b, end1, end2);
            updates = this.postEvaluateUpdatesMap.get(obj1);
            if (updates == null) {
                updates = new ArrayList<UpdateDescriptor>();
                this.postEvaluateUpdatesMap.put((ConstraintObject)obj1, updates);
            }
            updates.add(updateDescriptor);
        }
    }

    public void evaluate() {
        if (this.sorted == null) {
            Graph<ConstraintObject> g = new Graph<ConstraintObject>(this.allConstraintObjects, this.graphDependencies);
            this.sorted = g.topologicalSort();
        }
        for (ConstraintObject obj : this.sorted) {
            List<UpdateDescriptor> preUpdates = this.preEvaluateUpdatesMap.get(obj);
            if (preUpdates != null) {
                for (UpdateDescriptor update : preUpdates) {
                    update.performUpdate();
                }
            }
            obj.evaluate();
            List<UpdateDescriptor> updates = this.postEvaluateUpdatesMap.get(obj);
            if (updates == null) continue;
            for (UpdateDescriptor update : updates) {
                update.performUpdate();
            }
        }
    }

    public boolean isConstraintObject(IObject_ obj) {
        return obj != null && obj instanceof ConstraintObject;
    }

    public void addDependency(ConstraintObject from, ConstraintObject to) {
        Set<ConstraintObject> dependencies = this.graphDependencies.get(from);
        if (dependencies == null) {
            dependencies = new HashSet<ConstraintObject>();
            this.graphDependencies.put(from, dependencies);
        }
        dependencies.add(to);
    }
}

