/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.parametric.semantics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Object;
import org.eclipse.papyrus.moka.parametric.semantics.BindingLink;
import org.eclipse.papyrus.moka.parametric.semantics.EvaluationGraph;
import org.eclipse.papyrus.moka.parametric.semantics.IEvaluable;
import org.eclipse.papyrus.moka.parametric.utils.NameUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

public class ConstraintObject
extends CS_Object
implements IEvaluable {
    protected List<BindingLink> bindingLinks = new ArrayList<BindingLink>();
    protected EvaluationGraph graph;

    public void evaluate() {
        if (this.isCompositeConstraint()) {
            if (this.graph == null) {
                this.graph = new EvaluationGraph(this);
            }
            this.graph.evaluate();
        }
    }

    public boolean isCompositeConstraint() {
        Class constraintBlock = (Class)this.getTypes().get(0);
        for (Property p : constraintBlock.allAttributes()) {
            if (p.getType() == null || p.getType().getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompositeConstraint(Class constraintBlock) {
        if (constraintBlock.getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) == null) {
            return false;
        }
        for (Property p : constraintBlock.allAttributes()) {
            if (p.getType() == null || p.getType().getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isInputParam(Property p) {
        if (p.getType().getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) == null) {
            return !p.isDerived();
        }
        return false;
    }

    public boolean isOutputParam(Property p) {
        if (p.getType().getAppliedStereotype(NameUtils.SYSML_CONSTRAINTBLOCK_STEREOTYPE_NAME) == null) {
            return p.isDerived();
        }
        return false;
    }

    @Override
    public List<BindingLink> getBindingLinks() {
        return this.bindingLinks;
    }
}

