/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.parametric.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Object_;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Reference;
import org.eclipse.papyrus.moka.parametric.utils.NameUtils;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;

public class BindingLink {
    protected Connector bindingConnector;
    protected IObject_ container;
    protected Map<ConnectorEnd, List<Property>> connectorEnd2ObjectMap = new HashMap<ConnectorEnd, List<Property>>();

    public BindingLink(Connector bindingConnector, IObject_ container) {
        this.bindingConnector = bindingConnector;
        this.container = container;
        for (ConnectorEnd cEnd : bindingConnector.getEnds()) {
            ArrayList<Property> propertyPath = new ArrayList<Property>();
            if (cEnd.getAppliedStereotype(NameUtils.SYSML_NESTEDCONNECTOREND_STEREOTYPE_NAME) != null) {
                Stereotype nestedConnectordEndStereotype = cEnd.getAppliedStereotype(NameUtils.SYSML_NESTEDCONNECTOREND_STEREOTYPE_NAME);
                Object l = cEnd.getValue(nestedConnectordEndStereotype, NameUtils.SYSML_PROPERTYPATH_PROPERTY_NAME);
                propertyPath.addAll((Collection<Property>)((EObjectResolvingEList)l));
            }
            propertyPath.add((Property)cEnd.getRole());
            this.connectorEnd2ObjectMap.put(cEnd, propertyPath);
        }
    }

    public IObject_ getLastObjectOnPath(IObject_ obj, List<Property> propertyPath) {
        List<Object> values = new ArrayList<IObject_>();
        values.add(obj);
        int i = 0;
        while (i < propertyPath.size()) {
            if (!values.isEmpty() && (values.get(0) instanceof Object_ || values.get(0) instanceof Reference)) {
                Object_ tmpObj = values.get(0) instanceof Reference ? ((Reference)values.get((int)0)).referent : (Object_)values.get(0);
                values = tmpObj.getFeatureValue((StructuralFeature)propertyPath.get(i)).getValues();
            }
            ++i;
        }
        return values.isEmpty() ? null : (values.get(0) instanceof Reference ? ((Reference)values.get((int)0)).referent : (Object_)values.get(0));
    }

    public List<IValue> getValue(ConnectorEnd end) {
        List<Property> propertyPath = this.connectorEnd2ObjectMap.get(end);
        if (propertyPath != null) {
            return this.evaluatePropertyPathValue(propertyPath);
        }
        return null;
    }

    public IObject_ getFirstObjectFromPropertyPath(ConnectorEnd end) {
        List<Property> propertyPath = this.connectorEnd2ObjectMap.get(end);
        if (propertyPath != null) {
            ArrayList<Property> partialPropertyPath = new ArrayList<Property>();
            partialPropertyPath.add(propertyPath.get(0));
            List<IValue> result = this.evaluatePropertyPathValue(partialPropertyPath);
            if (result != null && !result.isEmpty()) {
                if (result.get(0) instanceof IObject_) {
                    return (IObject_)result.get(0);
                }
                if (result.get(0) instanceof IReference) {
                    return ((IReference)result.get(0)).getReferent();
                }
            }
        }
        return null;
    }

    public List<IValue> evaluatePropertyPathValue(List<Property> propertyPath) {
        List<Object> values = new ArrayList<IValue>();
        values.add((IValue)this.container);
        int i = 0;
        while (i < propertyPath.size()) {
            if (!values.isEmpty() && (values.get(0) instanceof Object_ || values.get(0) instanceof Reference)) {
                Object_ tmpObj = values.get(0) instanceof Reference ? ((Reference)values.get((int)0)).referent : (Object_)values.get(0);
                values = tmpObj.getFeatureValue((StructuralFeature)propertyPath.get(i)).getValues();
            }
            ++i;
        }
        return values;
    }

    public void propagateValues(ConnectorEnd from, ConnectorEnd to) {
        List<IValue> valuesToPropagate = this.getValue(from);
        List<Object> values = new ArrayList<IObject_>();
        values.add(this.container);
        List<Property> toPropertyPath = this.connectorEnd2ObjectMap.get(to);
        int i = 0;
        while (i < toPropertyPath.size() - 1) {
            if (!values.isEmpty() && (values.get(0) instanceof Object_ || values.get(0) instanceof Reference)) {
                Object_ tmpObj = values.get(0) instanceof Reference ? ((Reference)values.get((int)0)).referent : (Object_)values.get(0);
                values = tmpObj.getFeatureValue((StructuralFeature)toPropertyPath.get(i)).getValues();
            }
            ++i;
        }
        if (!values.isEmpty() && (values.get(0) instanceof Object_ || values.get(0) instanceof Reference)) {
            Object_ tmpObj = values.get(0) instanceof Reference ? ((Reference)values.get((int)0)).referent : (Object_)values.get(0);
            tmpObj.setFeatureValue((StructuralFeature)((Property)to.getRole()), valuesToPropagate, Integer.valueOf(0));
        }
    }
}

