/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.parametric;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.moka.composites.CompositeStructuresExecutionEngine;
import org.eclipse.papyrus.moka.composites.Semantics.impl.Loci.LociL3.CS_Executor;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Object;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutor;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.IntegerValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Object_;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Reference;
import org.eclipse.papyrus.moka.parametric.semantics.ParametricConstructStrategy;
import org.eclipse.papyrus.moka.parametric.semantics.ParametricExecutionFactory;
import org.eclipse.papyrus.moka.parametric.semantics.ParametricLocus;
import org.eclipse.papyrus.moka.parametric.semantics.ParametricObject;
import org.eclipse.papyrus.moka.parametric.utils.NameUtils;
import org.eclipse.papyrus.moka.service.IMokaService;
import org.eclipse.papyrus.moka.service.MokaServiceRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.ValueSpecification;

public class CausalParametricInterpreter
extends CompositeStructuresExecutionEngine
implements IExecutionEngine {
    private InstanceSpecification result;

    public ILocus initializeLocus() {
        ParametricLocus locus = new ParametricLocus();
        locus.setExecutor((IExecutor)new CS_Executor());
        locus.setFactory((IExecutionFactory)new ParametricExecutionFactory());
        return locus;
    }

    protected void registerSemanticStrategies(ILocus locus) {
        super.registerSemanticStrategies(locus);
        locus.getFactory().setStrategy((ISemanticStrategy)new ParametricConstructStrategy());
    }

    public void start(IProgressMonitor monitor) {
        if (!this.mode.equals((Object)IExecutionEngine.OperatingMode.QUIET)) {
            MokaServiceRegistry registry = MokaServiceRegistry.getInstance();
            registry.loadServices();
            for (IMokaService service : registry.getAllServices()) {
                service.init(this.launch, this.executionEntryPoint);
            }
        }
        this.locus = this.initializeLocus();
        if (this.executionEntryPoint != null && this.executionEntryPoint instanceof InstanceSpecification) {
            this.initializeBuiltInPrimitiveTypes(this.locus);
            this.registerOpaqueBehaviorExecutions(this.locus);
            this.registerSystemServices(this.locus);
            this.registerSemanticStrategies(this.locus);
            this.initializeArguments(this.executionArgs);
            IObject_ o = this.evaluateInstanceSpecification((InstanceSpecification)this.executionEntryPoint);
            ValueSpecification v = o.specify();
            this.result = ((InstanceValue)v).getInstance();
            try {
                final TransactionalEditingDomain dom = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)this.executionEntryPoint);
                final SerializeComputationResultCommand command = new SerializeComputationResultCommand(dom, ((InstanceValue)v).getInstance(), (InstanceSpecification)this.executionEntryPoint);
                command.setLabel("Workflow Test Execution");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dom.getCommandStack().execute((Command)command);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IObject_ evaluateInstanceSpecification(InstanceSpecification instance) {
        if (instance.getClassifiers().isEmpty()) {
            return null;
        }
        IObject_ object = this.locus.instantiate((Class)instance.getClassifiers().get(0));
        ParametricConstructStrategy strategy = (ParametricConstructStrategy)this.locus.getFactory().getStrategy("constructStrategy");
        strategy.constructObject((ICS_Object)object, (Class)object.getTypes().get(0));
        if (object instanceof ParametricObject) {
            ((ParametricObject)object).setSourceInstanceSpec(instance);
        }
        EList instanceSlots = instance.getSlots();
        int i = 0;
        while (i < instanceSlots.size()) {
            Slot slot = (Slot)instanceSlots.get(i);
            if (slot.getAppliedStereotype(NameUtils.MOKA_PARAMETRIC_APPLICATION_STEREOTYPE_NAME) != null) {
                Stereotype s = slot.getAppliedStereotype(NameUtils.MOKA_PARAMETRIC_APPLICATION_STEREOTYPE_NAME);
                Element e = (Element)slot.getValue(s, "element");
                if (e != null) {
                    IObject_ o = this.locus.instantiate((Class)slot.getDefiningFeature().getType());
                    for (Property p : ((Class)slot.getDefiningFeature().getType()).getAllAttributes()) {
                        Object v = e.getValue((Stereotype)slot.getDefiningFeature().getType(), p.getName());
                        ArrayList<IntegerValue> values = new ArrayList<IntegerValue>();
                        if (p.getType() instanceof PrimitiveType) {
                            IntegerValue intValue = new IntegerValue();
                            intValue.value = (Integer)v;
                            intValue.type = (PrimitiveType)p.getType();
                            values.add(intValue);
                        }
                        o.setFeatureValue((StructuralFeature)p, values, Integer.valueOf(0));
                    }
                    ArrayList<IObject_> values = new ArrayList<IObject_>();
                    values.add(o);
                    object.setFeatureValue(slot.getDefiningFeature(), values, Integer.valueOf(0));
                }
            } else {
                ArrayList<IValue> values = new ArrayList<IValue>();
                EList slotValues = slot.getValues();
                int j = 0;
                while (j < slotValues.size()) {
                    ValueSpecification slotValue = (ValueSpecification)slotValues.get(j);
                    values.add(this.locus.getExecutor().evaluate(slotValue));
                    ++j;
                }
                object.setFeatureValue(slot.getDefiningFeature(), values, Integer.valueOf(0));
            }
            ++i;
        }
        if (this.containsParametricObjects(object)) {
            List<ParametricObject> objectsToEvalFirst = this.computeEvalList((Object_)object);
            for (ParametricObject o : objectsToEvalFirst) {
                o.evaluate();
            }
        }
        if (object instanceof ParametricObject) {
            ((ParametricObject)object).evaluate();
        }
        return object;
    }

    protected boolean containsParametricObjects(IObject_ object) {
        if (object instanceof ParametricObject) {
            return true;
        }
        for (IFeatureValue featureValues : object.getFeatureValues()) {
            for (IValue v : featureValues.getValues()) {
                if (!(v instanceof Reference)) continue;
                IObject_ obj = ((Reference)v).getReferent();
                if (obj instanceof ParametricObject) {
                    return true;
                }
                return this.containsParametricObjects(obj);
            }
        }
        return false;
    }

    protected List<ParametricObject> computeEvalList(Object_ object) {
        ArrayList<ParametricObject> objectsToEvalFirst = new ArrayList<ParametricObject>();
        for (IFeatureValue featureValues : object.getFeatureValues()) {
            for (IValue v : featureValues.getValues()) {
                if (!(v instanceof Reference)) continue;
                IObject_ obj = ((Reference)v).getReferent();
                if (obj instanceof ParametricObject) {
                    objectsToEvalFirst.add((ParametricObject)obj);
                }
                objectsToEvalFirst.addAll(0, this.computeEvalList((Object_)obj));
            }
        }
        return objectsToEvalFirst;
    }

    public InstanceSpecification getResult() {
        return this.result;
    }

    protected class SerializeComputationResultCommand
    extends RecordingCommand {
        private final InstanceSpecification computed;
        private final InstanceSpecification sourceInstanceSpec;

        public SerializeComputationResultCommand(TransactionalEditingDomain domain, InstanceSpecification computed, InstanceSpecification sourceInstanceSpec) {
            super(domain);
            this.computed = computed;
            this.sourceInstanceSpec = sourceInstanceSpec;
        }

        private boolean serializeComputationResult(InstanceSpecification computed, InstanceSpecification source) {
            Package nearestPackage = source.getNearestPackage();
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            String strDate = sdfDate.format(now);
            Package resultPackage = nearestPackage.createNestedPackage(source.getName() + " - Exec - " + strDate);
            ArrayList<InstanceSpecification> toBeAdded = new ArrayList<InstanceSpecification>();
            toBeAdded.add(computed);
            while (!toBeAdded.isEmpty()) {
                InstanceSpecification instance = (InstanceSpecification)toBeAdded.remove(0);
                if (instance.getModel() == null) {
                    resultPackage.getPackagedElements().add((Object)instance);
                }
                for (Slot s : instance.getSlots()) {
                    for (ValueSpecification v : s.getValues()) {
                        if (!(v instanceof InstanceValue)) continue;
                        toBeAdded.add(((InstanceValue)v).getInstance());
                    }
                }
            }
            computed.setName(this.sourceInstanceSpec.getName());
            return true;
        }

        protected void doExecute() {
            this.serializeComputationResult(this.computed, this.sourceInstanceSpec);
        }
    }
}

