/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aceeditor;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.eclipse.papyrus.aceeditor.AceCodeEditorConfiguration;
import org.eclipse.papyrus.aceeditor.AceCodeEditorListener;
import org.eclipse.papyrus.aceeditor.CodeAnnotation;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AceCodeEditor
extends AbstractValueEditor {
    private WebView webView;
    private boolean webEngineIsReady;
    private String editedCode;
    private JSObject window;
    private AceCodeEditorConfiguration configuration = new AceCodeEditorConfiguration();
    private List<CodeAnnotation> annotations = new ArrayList<CodeAnnotation>();
    private List<AceCodeEditorListener> listeners = new ArrayList<AceCodeEditorListener>();

    private void buildEditor(int style) {
        Composite container = new Composite((Composite)this, style);
        GridData myEditorData = new GridData(1, 1, true, true);
        myEditorData.widthHint = 600;
        myEditorData.grabExcessVerticalSpace = true;
        myEditorData.verticalAlignment = 4;
        FXCanvas fxCanvas = new FXCanvas(container, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                this.getScene().getWindow().sizeToScene();
                return super.computeSize(wHint, hHint, changed);
            }
        };
        fxCanvas.setSize(800, 200);
        this.editedCode = "";
        this.webView = new WebView();
        this.webEngineIsReady = false;
        this.webView.getEngine().setJavaScriptEnabled(true);
        this.webView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                if (newValue == Worker.State.SUCCEEDED) {
                    AceCodeEditor.this.onHTMLLoaded();
                }
            }
        });
        this.refresh();
        fxCanvas.setScene(new Scene((Parent)this.webView));
        this.setCommitOnFocusLost((Control)fxCanvas);
    }

    protected void onHTMLLoaded() {
        this.webEngineIsReady = true;
        this.window = (JSObject)this.executeScript("window");
        this.window.setMember("editorListener", (Object)this);
        this.pushStateToJS();
    }

    protected <T> T executeScript(String script) {
        if (!this.webEngineIsReady) {
            return null;
        }
        return (T)this.webView.getEngine().executeScript(script);
    }

    public void runInFXThread(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    protected AceCodeEditor(Composite parent, int style) {
        super(parent);
        Platform.setImplicitExit((boolean)false);
        this.buildEditor(style);
    }

    private void pushStateToJS() {
        this.pushValueToJS();
        this.pushAnnotationsToJS();
    }

    private void pushAnnotationsToJS() {
        if (!this.webEngineIsReady) {
            return;
        }
        StringBuffer call = new StringBuffer();
        call.append("editor.getSession().setAnnotations([");
        int i = 0;
        while (i < this.annotations.size()) {
            CodeAnnotation a = this.annotations.get(i);
            call.append(a.toJSLine());
            if (i <= this.annotations.size() - 1) {
                call.append(',');
            }
            ++i;
        }
        call.append("]);");
        this.executeScript(call.toString());
    }

    private void pushValueToJS() {
        if (!this.webEngineIsReady) {
            return;
        }
        this.executeScript("editor.setValue(String.raw`" + this.editedCode + "`)");
    }

    public static String cleanString(String dirty) {
        return dirty.replace("'", "\\'").replace("\"", "\\\"").replace(System.getProperty("line.separator"), "\\n").replace("\n", "\\n").replace("\r", "\\n");
    }

    public void setValue(String editedCode) {
        this.editedCode = editedCode;
        this.pushStateToJS();
    }

    private String pullValueFromJS() {
        if (this.webEngineIsReady) {
            this.editedCode = (String)this.executeScript("editor.getValue()");
        }
        return this.editedCode;
    }

    public Object getValue() {
        return this.pullValueFromJS();
    }

    public Object getEditableType() {
        return String.class;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void refresh() {
        String html = this.generateMainHtml();
        this.webView.getEngine().loadContent(html);
    }

    protected String generateMainHtml() {
        StringBuffer buf = new StringBuffer();
        String NL = "\n";
        buf.append("<!DOCTYPE html>").append(NL).append("<html lang=\"en\">").append(NL).append("<head>").append(NL).append("<title>ACE in Action</title>").append(NL).append("<style type=\"text/css\" media=\"screen\">").append(NL).append("    #editor {").append(NL).append("        position: absolute;").append(NL).append("        top: 0;").append(NL).append("        right: 0;").append(NL).append("        bottom: 0;").append(NL).append("        left: 0;").append(NL).append("    }").append(NL).append("</style>").append(NL).append("</head>").append(NL).append("<body>").append(NL).append("<div id=\"editor\">").append(NL).append("</div>").append(NL).append("<script src=\"platform:/plugin/org.eclipse.papyrus.aceeditor/ace-min-noconflict/ace.js\" type=\"text/javascript\" charset=\"utf-8\"></script>").append(NL).append("<script language=\"javascript\">").append(NL).append("   var editor = ace.edit(\"editor\");").append(NL).append("   editor.setTheme(\"ace/theme/" + this.configuration.getTheme() + "\");").append(NL).append("   editor.setOptions({displayIndentGuides: true, showFoldWidgets: false});").append(NL).append("   editor.session.setMode(\"ace/mode/" + this.configuration.getLanguage() + "\");").append(NL).append("   editor.session.setMode(\"ace/mode/" + this.configuration.getLanguage() + "\");").append(NL).append("   editor.session.on('change', function(e){ if( editor.session.getUndoManager().hasUndo() ) editorListener.onSessionChange(editor.getValue()) });").append(NL).append("</script>").append(NL).append("</body>").append(NL).append("</html>").append(NL);
        return buf.toString();
    }

    public AceCodeEditorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setAnnotations(List<CodeAnnotation> annotations) {
        this.annotations.clear();
        this.annotations.addAll(annotations);
        this.pushAnnotationsToJS();
    }

    public void onSessionChange(String newValue) {
        if (this.isInitialChange(newValue)) {
            return;
        }
        this.listeners.forEach(l -> l.onChange(newValue));
    }

    public boolean isInitialChange(String value) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        return value.equals(this.editedCode);
    }

    public void markClean() {
        this.executeScript("editor.session.getUndoManager().markClean()");
    }

    public void addAceCodeEditorListener(AceCodeEditorListener listener) {
        this.listeners.add(listener);
    }
}

