/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class M2MTrafoUtil {
    public static List<M2MTrafo> getTransformations(Package pkg) {
        ArrayList<M2MTrafo> m2mRuleList = new ArrayList<M2MTrafo>();
        M2MTrafoUtil.getTransformations(pkg, new ArrayList<Package>(), m2mRuleList);
        return m2mRuleList;
    }

    public static List<M2MTrafoChain> getTransformationChains(Package pkg) {
        ArrayList<M2MTrafoChain> chainList = new ArrayList<M2MTrafoChain>();
        M2MTrafoUtil.getTransformationChains(pkg, new ArrayList<Package>(), chainList);
        return chainList;
    }

    protected static void getTransformations(Package pkg, List<Package> visitedPackages, List<M2MTrafo> m2mRuleList) {
        for (Element el : pkg.getMembers()) {
            M2MTrafo rule;
            if (el instanceof Package) {
                if (visitedPackages.contains(el)) continue;
                visitedPackages.add((Package)el);
                M2MTrafoUtil.getTransformations((Package)el, visitedPackages, m2mRuleList);
                continue;
            }
            if (!(el instanceof Class) || (rule = (M2MTrafo)UMLUtil.getStereotypeApplication((Element)el, M2MTrafo.class)) == null) continue;
            m2mRuleList.add(rule);
        }
    }

    protected static void getTransformationChains(Package pkg, List<Package> visitedPackages, List<M2MTrafoChain> chainList) {
        for (Element el : pkg.getMembers()) {
            M2MTrafoChain chain;
            if (el instanceof Package) {
                if (visitedPackages.contains(el)) continue;
                visitedPackages.add((Package)el);
                M2MTrafoUtil.getTransformationChains((Package)el, visitedPackages, chainList);
                continue;
            }
            if (!(el instanceof Class) || (chain = (M2MTrafoChain)UMLUtil.getStereotypeApplication((Element)el, M2MTrafoChain.class)) == null) continue;
            chainList.add(chain);
        }
    }
}

