/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;

public class TransformationContext {
    public Package deploymentPlan;
    public ModelManagement mm;
    public IProject project;
    public ILangProjectSupport projectSupport;
    public Package modelRoot;
    public LazyCopier copier;
    public Classifier classifier;
    public InstanceSpecification node;
    public List<String> keepFiles = new ArrayList<String>();
    public static TransformationContext current;
    protected static List<TransformationContext> chainContexts;
    public static IProgressMonitor monitor;
    public static Package initialSourceRoot;
    public static Package initialDeploymentPlan;

    public static void init(IProgressMonitor monitor, Package initialSourceRoot, Package initialDeploymentPlan) {
        TransformationContext.monitor = monitor;
        TransformationContext.initialSourceRoot = initialSourceRoot;
        TransformationContext.initialDeploymentPlan = initialDeploymentPlan;
        current = null;
        chainContexts = new ArrayList<TransformationContext>();
    }

    public static void setContext(TransformationContext tc) {
        current = tc;
        chainContexts.add(tc);
    }

    public static void resetContext() {
        current = null;
        chainContexts = null;
    }

    public static void popContext() {
        int size = chainContexts.size();
        if (size > 0) {
            chainContexts.remove(--size);
            current = size > 0 ? chainContexts.get(size - 1) : null;
        }
    }

    public static List<TransformationContext> chainContexts() {
        return chainContexts;
    }
}

