/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.core.Activator;
import org.eclipse.papyrus.designer.transformation.core.copylisteners.PostCopyListener;
import org.eclipse.papyrus.designer.transformation.core.copylisteners.PreCopyListener;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class LazyCopier
extends EcoreUtil.Copier {
    public static final EObject USE_SOURCE_OBJECT = EcoreFactory.eINSTANCE.createEObject();
    private static final long serialVersionUID = -1664013545661635289L;
    public Package source;
    public Package target;
    protected CopyExtResources copyExtResources;
    protected EList<Resource> selectedResourceList;
    protected Map<EObject, CopyStatus> statusMap;
    protected boolean copyID;
    protected EList<ModelManagement> rootPkgs;
    public EList<PreCopyListener> preCopyListeners;
    public EList<PostCopyListener> postCopyListeners;

    public LazyCopier(Package source, Package target, CopyExtResources copyExtResources, boolean copyID) {
        this.source = source;
        this.target = target;
        this.copyExtResources = copyExtResources;
        this.selectedResourceList = new UniqueEList();
        if (copyExtResources == CopyExtResources.NONE || copyExtResources == CopyExtResources.SELECTED) {
            this.selectedResourceList.add((Object)source.eResource());
        }
        this.preCopyListeners = new BasicEList();
        this.postCopyListeners = new BasicEList();
        this.statusMap = new HashMap<EObject, CopyStatus>();
        this.put(source, target);
        this.setStatus((EObject)target, CopyStatus.SHALLOW);
        this.copyID = copyID;
        if (copyID) {
            CopyUtils.copyID((EObject)source, (EObject)target);
        }
        this.rootPkgs = new BasicEList();
    }

    public void addResource(Resource resource) {
        this.selectedResourceList.add((Object)resource);
    }

    public EList<ModelManagement> getAdditionalRootPkgs() {
        return this.rootPkgs;
    }

    public EObject putPair(EObject sourceEObj, EObject targetEObj) {
        EObject target = (EObject)this.put(sourceEObj, targetEObj);
        this.setStatus(targetEObj, CopyStatus.FULL);
        return target;
    }

    public void setStatus(EObject targetEObj, CopyStatus status) {
        this.statusMap.put(targetEObj, status);
    }

    public CopyStatus getStatus(EObject targetEObj) {
        CopyStatus status;
        if (targetEObj != null && (status = this.statusMap.get(targetEObj)) != null) {
            return status;
        }
        return CopyStatus.UNKNOWN;
    }

    public EList<EObject> getRefs(EReference eReference, EObject eObject) {
        BasicEList refs = new BasicEList();
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                refs.addAll((Collection)((List)eObject.eGet((EStructuralFeature)eReference)));
            } else {
                refs.add((Object)((EObject)eObject.eGet((EStructuralFeature)eReference)));
            }
        }
        return refs;
    }

    public boolean copyResource(EObject sourceEObj) {
        if (this.copyExtResources == CopyExtResources.ALL) {
            return true;
        }
        if (this.copyExtResources == CopyExtResources.ALL_EXCEPT) {
            return !this.selectedResourceList.contains((Object)sourceEObj.eResource());
        }
        return this.selectedResourceList.contains((Object)sourceEObj.eResource());
    }

    public EObject copy(EObject sourceEObj) {
        String name;
        if (sourceEObj == null) {
            return null;
        }
        EObject targetEObj = (EObject)this.get(sourceEObj);
        CopyStatus status = this.getStatus(targetEObj);
        if (status == CopyStatus.FULL || status == CopyStatus.INPROGRESS) {
            return targetEObj;
        }
        if (status == CopyStatus.SHALLOW && sourceEObj instanceof Package) {
            return targetEObj;
        }
        if (!this.copyResource(sourceEObj)) {
            return sourceEObj;
        }
        if (sourceEObj instanceof Stereotype || sourceEObj instanceof EPackage) {
            return sourceEObj;
        }
        for (PreCopyListener listener : this.preCopyListeners) {
            EObject result = listener.preCopyEObject(this, sourceEObj);
            if (result == sourceEObj) continue;
            if (result == USE_SOURCE_OBJECT) {
                return sourceEObj;
            }
            return result;
        }
        if (sourceEObj instanceof NamedElement && (name = ((NamedElement)sourceEObj).getQualifiedName()) != null && name.startsWith("uml::")) {
            Activator.log.debug("copy for meta-model element \"" + name + "\" requested. Return original element");
            return sourceEObj;
        }
        if (sourceEObj instanceof Package && ((Package)sourceEObj).getOwnedTemplateSignature() != null) {
            Activator.log.debug("warning: copying a package template without instantiating a template");
        }
        if (status == CopyStatus.SHALLOW) {
            this.setStatus(targetEObj, CopyStatus.INPROGRESS);
        } else {
            targetEObj = this.createCopy(sourceEObj);
            this.put(sourceEObj, targetEObj);
            this.setStatus(targetEObj, CopyStatus.INPROGRESS);
            if (this.copyID) {
                CopyUtils.copyID((EObject)sourceEObj, (EObject)targetEObj);
            }
            if (sourceEObj.eContainer() != null) {
                this.shallowCopy(sourceEObj.eContainer());
            }
        }
        EClass eClass = sourceEObj.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, sourceEObj, targetEObj);
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment()) {
                        this.copyContainment(eReference, sourceEObj, targetEObj);
                    } else if (!eReference.getName().equals("owner") && !eReference.getName().equals("owningInstance")) {
                        Object feature = sourceEObj.eGet(eStructuralFeature);
                        if (feature instanceof Element) {
                            this.copy((EObject)((Element)feature));
                        } else if (feature instanceof EList) {
                            this.copyAll((Collection)((EList)feature));
                        }
                        this.copyReference(eReference, sourceEObj, targetEObj);
                    }
                }
            } else if (eStructuralFeature instanceof EReference && eStructuralFeature.getName().equals("clientDependency")) {
                Object feature = sourceEObj.eGet(eStructuralFeature);
                if (feature instanceof Element) {
                    this.copy((EObject)((Element)feature));
                } else if (feature instanceof EList) {
                    this.copyAll((Collection)((EList)feature));
                }
            }
            ++i;
        }
        this.copyProxyURI(sourceEObj, targetEObj);
        if (this.copyID) {
            CopyUtils.copyID((EObject)sourceEObj, (EObject)targetEObj);
        }
        this.copyStereotypes(sourceEObj);
        this.setStatus(targetEObj, CopyStatus.FULL);
        for (PostCopyListener listener : this.postCopyListeners) {
            listener.postCopyEObject(this, targetEObj);
        }
        return targetEObj;
    }

    public EObject noCopy(EObject sourceEObj) {
        if (!this.copyResource(sourceEObj)) {
            return sourceEObj;
        }
        for (PreCopyListener listener : this.preCopyListeners) {
            EObject result = listener.preCopyEObject(this, sourceEObj);
            if (result == sourceEObj) continue;
            if (result == USE_SOURCE_OBJECT) {
                return sourceEObj;
            }
            return result;
        }
        return (EObject)this.get(sourceEObj);
    }

    public void copyStereotypes(EObject sourceEObj) {
        if (sourceEObj instanceof Element) {
            for (EObject stereoApplication : ((Element)sourceEObj).getStereotypeApplications()) {
                EObject copiedStereoApplication = this.copy(stereoApplication);
                EObject targetEObj = (EObject)this.get(sourceEObj);
                if (copiedStereoApplication == null || targetEObj == null || targetEObj.eResource() == null || targetEObj.eResource().getContents().contains((Object)copiedStereoApplication)) continue;
                targetEObj.eResource().getContents().add((Object)copiedStereoApplication);
            }
        }
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (!source.isEmpty()) {
                    for (EObject copyEObj : this.copyAll(source)) {
                        if (copyEObj == null) continue;
                        target.add(copyEObj);
                    }
                }
            } else {
                EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), childEObject == null ? null : this.copy(childEObject));
            }
        }
    }

    protected void shallowCopyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                List target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    for (EObject sourceEObj : source) {
                        EObject copyEObj = this.noCopy(sourceEObj);
                        if (copyEObj == null || copyEObj == sourceEObj || target.contains(copyEObj)) continue;
                        try {
                            target.add(copyEObj);
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
            } else {
                EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), childEObject == null ? null : this.noCopy(childEObject));
            }
        }
    }

    public EObject shallowCopy(EObject sourceEObj) {
        boolean first = false;
        EObject targetEObj = (EObject)this.get(sourceEObj);
        for (PreCopyListener listener : this.preCopyListeners) {
            EObject result = listener.preCopyEObject(this, sourceEObj);
            if (result == sourceEObj) continue;
            if (result == USE_SOURCE_OBJECT) {
                return sourceEObj;
            }
            return result;
        }
        if (targetEObj == null) {
            targetEObj = this.createCopy(sourceEObj);
            this.put(sourceEObj, targetEObj);
            this.setStatus(targetEObj, CopyStatus.SHALLOW);
            if (this.copyID) {
                CopyUtils.copyID((EObject)sourceEObj, (EObject)targetEObj);
            }
            first = true;
            if (sourceEObj.eContainer() != null) {
                this.shallowCopy(sourceEObj.eContainer());
            } else if (sourceEObj instanceof Package && sourceEObj != this.source) {
                Package targetPkg = (Package)targetEObj;
                ModelManagement mm = new ModelManagement(targetPkg);
                mm.setURI(ModelManagement.getTempURI((EObject)sourceEObj));
                this.rootPkgs.add((Object)mm);
            }
        } else if (this.getStatus(targetEObj) == CopyStatus.FULL) {
            return targetEObj;
        }
        EClass eClass = sourceEObj.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                if (eStructuralFeature instanceof EAttribute) {
                    if (first) {
                        this.copyAttribute((EAttribute)eStructuralFeature, sourceEObj, targetEObj);
                    }
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (sourceEObj != targetEObj) {
                        if (eReference.getName().equals("profileApplication") || eReference.getName().equals("packageMerge")) {
                            this.copyContainment(eReference, sourceEObj, targetEObj);
                        } else {
                            this.shallowCopyContainment(eReference, sourceEObj, targetEObj);
                        }
                    }
                }
            }
            ++i;
        }
        this.copyStereotypes(sourceEObj);
        return targetEObj;
    }

    public <T extends Element> T getCopy(T source) {
        return (T)((Element)this.copy((EObject)source));
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    boolean isBidirectional = eReference.getEOpposite() != null;
                    int index = 0;
                    Iterator k = this.resolveProxies ? source.iterator() : source.basicIterator();
                    while (k.hasNext()) {
                        EObject referencedEObject = (EObject)k.next();
                        EObject copyReferencedEObject = (EObject)this.get(referencedEObject);
                        boolean noCopy = false;
                        for (PreCopyListener listener : this.preCopyListeners) {
                            EObject result = listener.preCopyEObject(this, referencedEObject);
                            if (result == referencedEObject) continue;
                            copyReferencedEObject = result == USE_SOURCE_OBJECT ? referencedEObject : result;
                            noCopy = result == null;
                            break;
                        }
                        if (noCopy) continue;
                        if (copyReferencedEObject == null) {
                            if (!this.useOriginalReferences || isBidirectional) continue;
                            target.addUnique(index, (Object)referencedEObject);
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            int position = target.indexOf((Object)copyReferencedEObject);
                            if (position == -1) {
                                target.addUnique(index, (Object)copyReferencedEObject);
                            } else if (index != position) {
                                target.move(index, (Object)copyReferencedEObject);
                            }
                        } else if (!target.contains((Object)copyReferencedEObject)) {
                            target.addUnique(index, (Object)copyReferencedEObject);
                        }
                        ++index;
                    }
                }
            } else {
                EObject copyReferencedEObject;
                Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (referencedEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else if (referencedEObject instanceof EObject && (copyReferencedEObject = this.copy((EObject)referencedEObject)) != null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)copyReferencedEObject);
                }
            }
        }
    }

    public void copyMethods(Class source) {
        for (Behavior method : source.getOwnedBehaviors()) {
            this.getCopy(method);
        }
    }

    public void copyAttributes(Classifier source) {
        for (Property attribute : source.getAttributes()) {
            this.getCopy(attribute);
        }
    }

    public void copyOperations(Classifier source) {
        for (Operation operation : source.getOperations()) {
            this.getCopy(operation);
        }
    }

    public static enum CopyExtResources {
        NONE,
        SELECTED,
        ALL_EXCEPT,
        ALL;

    }

    public static enum CopyStatus {
        UNKNOWN,
        FULL,
        INPROGRESS,
        SHALLOW;

    }
}

