/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.TestInfo;
import org.eclipse.papyrus.designer.transformation.base.UIContext;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TrafoUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Activator;
import org.eclipse.papyrus.designer.transformation.core.EnumService;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateInstantiation;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteChainUtil;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterLoadReferencedModels;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExecuteTransformationChain {
    public static String USER_CANCEL = "abort transformation, canceled by user";
    protected IProgressMonitor monitor = null;
    protected int generationOptions;
    protected Package rootPackageOrDP = null;
    protected IProject project;

    public ExecuteTransformationChain(Package rootPackageOrDP, IProject project) {
        this.rootPackageOrDP = rootPackageOrDP;
        if (project == null) {
            String projectName = rootPackageOrDP.eResource().getURI().toString();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        } else {
            this.project = project;
        }
    }

    public void executeTransformation(IProgressMonitor monitor, int genOptions) {
        this.executeTransformation(null, monitor, genOptions);
    }

    public void executeTransformation(M2MTrafoChain chain, IProgressMonitor monitor, int genOptions) {
        try {
            try {
                this.monitor = monitor;
                this.generationOptions = genOptions;
                this.executeTransformation(chain);
            }
            catch (TransformationException e) {
                ModelManagement.getResourceSet().getResources().clear();
                if (e.getMessage() != USER_CANCEL) {
                    this.printAndDisplayErrorMessage((Exception)((Object)e), Messages.InstantiateDepPlan_TransformationException);
                }
                TransformationContext.resetContext();
            }
            catch (InterruptedException interruptedException) {
                TransformationContext.resetContext();
            }
        }
        finally {
            TransformationContext.resetContext();
        }
    }

    protected void executeTransformation(M2MTrafoChain chain) throws TransformationException, InterruptedException {
        ModelManagement intermediateModelManagement = null;
        UIContext.monitor = this.monitor;
        UIContext.configureProject = (this.generationOptions & 1) != 0;
        Model existingModel = this.rootPackageOrDP.getModel();
        TransformationContext.init(this.monitor, (Package)existingModel, this.rootPackageOrDP);
        TransformationContext tc = new TransformationContext();
        TransformationContext.setContext(tc);
        this.monitor.beginTask("execute chain", 50);
        tc.project = this.project;
        TransformationContext.current.mm = intermediateModelManagement = ModelManagement.createNewModel((Package)existingModel);
        Package intermediateModel = intermediateModelManagement.getModel();
        EnumService.createEnumPackage(intermediateModel);
        final LazyCopier intermediateModelCopier = new LazyCopier((Package)existingModel, intermediateModel, LazyCopier.CopyExtResources.ALL, true);
        intermediateModelCopier.preCopyListeners.add((Object)FilterLoadReferencedModels.getInstance());
        final HashMap instanceMap = new HashMap();
        final AtomicReference exRef = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EcoreUtil.resolveAll((EObject)PackageUtil.getRootPackage((Package)ExecuteTransformationChain.this.rootPackageOrDP));
                try {
                    ExecuteTransformationChain.this.checkProgressStatus();
                    if (DepUtils.isDeploymentPlan((Package)ExecuteTransformationChain.this.rootPackageOrDP)) {
                        for (InstanceSpecification instance : DepUtils.getInstances((Package)ExecuteTransformationChain.this.rootPackageOrDP)) {
                            InstanceSpecification newInstance = intermediateModelCopier.getCopy(instance);
                            ExecuteTransformationChain.this.checkProgressStatus();
                            TransformationUtil.propagateAllocation(newInstance);
                            instanceMap.put(instance, newInstance);
                        }
                    } else {
                        intermediateModelCopier.shallowCopy((EObject)ExecuteTransformationChain.this.rootPackageOrDP);
                        for (PackageableElement pe : ExecuteTransformationChain.this.rootPackageOrDP.getPackagedElements()) {
                            intermediateModelCopier.getCopy(pe);
                        }
                    }
                }
                catch (InterruptedException pe) {
                }
                catch (Exception e) {
                    exRef.set(new TransformationException(e.getMessage()));
                }
            }
        });
        TransformationException exInSync = (TransformationException)((Object)exRef.get());
        if (exInSync != null) {
            throw exInSync;
        }
        if (this.monitor.isCanceled()) {
            throw new TransformationException(USER_CANCEL);
        }
        tc.copier = intermediateModelCopier;
        tc.deploymentPlan = intermediateModelCopier.getCopy(this.rootPackageOrDP);
        tc.modelRoot = PackageUtil.getRootPackage((Package)tc.deploymentPlan);
        if (chain == null) {
            chain = TrafoUtils.getTransformationChain((Package)this.rootPackageOrDP);
            GenUtils.checkProxy((EObject)chain);
        }
        TemplateInstantiation.init();
        ExecuteChainUtil.apply(chain, TrafoUtils.getAdditionalTransformations((Package)this.rootPackageOrDP));
        this.checkProgressStatus();
        intermediateModelManagement.dispose();
        for (ModelManagement mm : tc.copier.getAdditionalRootPkgs()) {
            mm.dispose();
        }
    }

    public void updateProjectMapping(final String canonicalProjectName, final String userProjectName) {
        CommandSupport.exec((EObject)this.rootPackageOrDP, (String)"Update project mapping", (Runnable)new Runnable(){

            @Override
            public void run() {
                DeploymentPlan depPlan = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)ExecuteTransformationChain.this.rootPackageOrDP, DeploymentPlan.class);
                String mapName = String.valueOf(canonicalProjectName) + "=" + userProjectName;
                for (String mapping : depPlan.getProjectMappings()) {
                    if (!mapping.startsWith(canonicalProjectName)) continue;
                    mapping = mapName;
                    return;
                }
                depPlan.getProjectMappings().add((Object)mapName);
            }
        });
    }

    private void checkProgressStatus() throws InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.monitor.worked(1);
    }

    private void printAndDisplayErrorMessage(Exception e, String title) {
        String message = e.toString();
        e.printStackTrace();
        if (!TestInfo.runsHeadless()) {
            this.displayError(title, message);
        }
        Activator.log.error((Throwable)e);
    }

    private void displayError(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }
}

