/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoModelSplit;
import org.eclipse.papyrus.designer.transformation.core.transformations.ApplyRecursive;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.extensions.IM2MTrafo;
import org.eclipse.papyrus.designer.transformation.extensions.M2MTrafoExt;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Package;

public class ExecuteTransformation {
    public static void apply(Iterator<M2MTrafo> m2mPropertyIter) throws TransformationException {
        if (!m2mPropertyIter.hasNext()) {
            return;
        }
        if (TransformationContext.monitor.isCanceled()) {
            throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
        }
        M2MTrafo m2mTrafo = m2mPropertyIter.next();
        IM2MTrafo eTrafo = M2MTrafoExt.getM2MTrafo((M2MTrafo)m2mTrafo);
        Package deploymentPlan = TransformationContext.current.deploymentPlan;
        if (eTrafo instanceof IM2MTrafoElem) {
            ApplyRecursive ar = new ApplyRecursive(m2mTrafo, (IM2MTrafoElem)eTrafo);
            ar.applyRecursive(PackageUtil.getRootPackage((Package)deploymentPlan));
            ExecuteTransformation.apply(m2mPropertyIter);
        } else if (eTrafo instanceof IM2MTrafoCDP) {
            ((IM2MTrafoCDP)eTrafo).applyTrafo(m2mTrafo, deploymentPlan);
            ExecuteTransformation.apply(m2mPropertyIter);
        } else if (eTrafo instanceof IM2MTrafoModelSplit) {
            List<TransformationContext> newContexts = ((IM2MTrafoModelSplit)eTrafo).splitModel(m2mTrafo, deploymentPlan);
            BasicEList remainingTrafos = new BasicEList();
            while (m2mPropertyIter.hasNext()) {
                remainingTrafos.add((Object)m2mPropertyIter.next());
            }
            for (TransformationContext newContext : newContexts) {
                TransformationContext.setContext(newContext);
                ExecuteTransformation.apply(remainingTrafos.iterator());
                TransformationContext.popContext();
                newContext.mm.dispose();
                for (ModelManagement mm : newContext.copier.getAdditionalRootPkgs()) {
                    mm.dispose();
                }
            }
        } else {
            throw new TransformationException(String.valueOf(Messages.ExecuteTransformation_UNKNOWN_M2M) + m2mTrafo.toString());
        }
    }
}

