/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.commands;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.StdModelLibs;
import org.eclipse.papyrus.designer.transformation.core.Activator;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;

public class AddMarteAndFcmProfile
extends RecordingCommand {
    public static final String CMD_LABEL = "Add MARTE/FCM profiles";
    static final String MARTE_FOUNDATIONS = "MARTE_Foundations";
    static final String MARTE_F_ALLOC = "Alloc";
    static final String MARTE_DESIGN_MODEL = "MARTE_DesignModel";
    static final String MARTE_DM_HLAM = "HLAM";
    static final String MARTE_DM_GCM = "GCM";
    public static final int APPLY_FCM = 1;
    public static final int APPLY_ALLOC = 2;
    public static final int APPLY_HLAM_GCM = 4;
    Package selectedPkg;
    int applyCode;

    public AddMarteAndFcmProfile(Package selectedPkg, int applyCode, TransactionalEditingDomain domain) {
        super(domain, CMD_LABEL);
        this.selectedPkg = selectedPkg;
        this.applyCode = applyCode;
    }

    protected void doExecute() {
        ResourceSet resourceSet = this.selectedPkg.eResource().getResourceSet();
        try {
            if ((this.applyCode & 1) != 0) {
                Profile fcmProfile = (Profile)ElementUtils.loadPackage((URI)StdModelLibs.FCM_PROFILE_URI, (ResourceSet)resourceSet);
                if (fcmProfile instanceof Profile) {
                    Profile profile = this.selectedPkg.getAppliedProfile(fcmProfile.getQualifiedName());
                    if (profile == null && !fcmProfile.getOwnedStereotypes().isEmpty()) {
                        this.selectedPkg.applyProfile(fcmProfile);
                    }
                } else {
                    Activator.log.debug("The FCM profile is not available.");
                }
            }
            if ((this.applyCode & 6) != 0) {
                Profile marteProfile = (Profile)ElementUtils.loadPackage((URI)StdModelLibs.MARTE_PROFILE_URI, (ResourceSet)resourceSet);
                if (marteProfile != null) {
                    PackageableElement designModel;
                    PackageableElement foundationModel = marteProfile.getPackagedElement(MARTE_FOUNDATIONS);
                    if (foundationModel instanceof Package && (this.applyCode & 2) != 0) {
                        PackageableElement alloc = ((Package)foundationModel).getPackagedElement(MARTE_F_ALLOC);
                        this.selectedPkg.applyProfile((Profile)alloc);
                    }
                    if ((designModel = marteProfile.getPackagedElement(MARTE_DESIGN_MODEL)) instanceof Package && (this.applyCode & 4) != 0) {
                        PackageableElement gcm;
                        PackageableElement hlam = ((Package)designModel).getPackagedElement(MARTE_DM_HLAM);
                        if (hlam instanceof Profile) {
                            this.selectedPkg.applyProfile((Profile)hlam);
                        }
                        if ((gcm = ((Package)designModel).getPackagedElement(MARTE_DM_GCM)) instanceof Profile) {
                            this.selectedPkg.applyProfile((Profile)gcm);
                        }
                    }
                } else {
                    Activator.log.debug("The MARTE profile is not available.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

