/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppEnumerations;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppInnerClassifiers;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppPrimitiveTypes;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassTypeAndEnum {
  public static String CppClassTypeAndEnum(final Classifier clazz) {
    StringConcatenation _builder = new StringConcatenation();
    String publicStr = CppClassTypeAndEnum.TypesAndEnumsForVisibility(clazz, VisibilityKind.PUBLIC_LITERAL).toString();
    _builder.newLineIfNotEmpty();
    String _section = CppGenUtils.cgu(clazz).getSection(VisibilityKind.PUBLIC_LITERAL, publicStr);
    _builder.append(_section);
    _builder.newLineIfNotEmpty();
    String protectedStr = CppClassTypeAndEnum.TypesAndEnumsForVisibility(clazz, VisibilityKind.PROTECTED_LITERAL).toString();
    _builder.newLineIfNotEmpty();
    String _section_1 = CppGenUtils.cgu(clazz).getSection(VisibilityKind.PROTECTED_LITERAL, protectedStr);
    _builder.append(_section_1);
    _builder.newLineIfNotEmpty();
    String privateStr = CppClassTypeAndEnum.TypesAndEnumsForVisibility(clazz, VisibilityKind.PRIVATE_LITERAL).toString();
    _builder.newLineIfNotEmpty();
    String _section_2 = CppGenUtils.cgu(clazz).getSection(VisibilityKind.PRIVATE_LITERAL, privateStr);
    _builder.append(_section_2);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  public static CharSequence CppClassTypeAndEnumPackage(final org.eclipse.uml2.uml.Package pkg) {
    CharSequence _xblockexpression = null;
    {
      CppClassTypeAndEnum.TypesAndEnumsForVisibility(pkg, VisibilityKind.get(VisibilityKind.PACKAGE));
      _xblockexpression = CppClassTypeAndEnum.TypesAndEnumsForVisibility(pkg, VisibilityKind.get(VisibilityKind.PUBLIC));
    }
    return _xblockexpression;
  }
  
  public static CharSequence TypesAndEnumsForVisibility(final Namespace ns, final VisibilityKind visibilityFilter) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Element> _ownedElements = ns.getOwnedElements();
      for(final Element ownedElement : _ownedElements) {
        CharSequence _TypeAndEnumForVisibility = CppClassTypeAndEnum.TypeAndEnumForVisibility(ns, ownedElement, visibilityFilter);
        _builder.append(_TypeAndEnumForVisibility);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence TypeAndEnumForVisibility(final Namespace ns, final Element element, final VisibilityKind visibilityFilter) {
    if (((!GenUtils.hasStereotype(element, NoCodeGen.class)) && (element instanceof Classifier))) {
      VisibilityKind elementVisibility = ((Classifier) element).getVisibility();
      int value = elementVisibility.getValue();
      int _value = visibilityFilter.getValue();
      boolean _equals = (value == _value);
      if (_equals) {
        if ((element instanceof Enumeration)) {
          return CppEnumerations.CppEnumerationDefinition(((Enumeration) element));
        } else {
          if ((element instanceof PrimitiveType)) {
            return CppPrimitiveTypes.CppPrimitiveTypeDefinition(((PrimitiveType) element));
          } else {
            if ((((element instanceof DataType) || element.eClass().equals(UMLFactory.eINSTANCE.getUMLPackage().getClass_())) && (!(element.getOwner() instanceof org.eclipse.uml2.uml.Package)))) {
              boolean _isTemplateBoundElement = GenUtils.isTemplateBoundElement(((Classifier) element));
              if (_isTemplateBoundElement) {
                return CppInnerClassifiers.CppInnerBindDefinition(((Classifier) element));
              } else {
                final VisibilityKind currentVisibility = CppGenUtils.cgu(ns).getCurrentVisibility();
                CppGenUtils.cgu(ns).resetVisibility(null);
                final CharSequence definition = CppInnerClassifiers.CppInnerClassDefinition(((Classifier) element));
                CppGenUtils.cgu(ns).resetVisibility(currentVisibility);
                return definition;
              }
            }
          }
        }
      }
    }
    return null;
  }
}
