/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.transformations;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.FCM.Assembly;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend2.lib.StringConcatenation;

public abstract class AbstractCompToOO
implements IOOTrafo {
    protected LazyCopier copier;
    protected String progLang;
    public static final String NL = "\n";

    public void init(LazyCopier copier, Class bootloader) {
        PrefixConstants.init((PrefixConstants.CIFvariant)PrefixConstants.CIFvariant.UML);
        this.copier = copier;
    }

    public abstract String nameRef(Property var1);

    public abstract void applyRef(Element var1);

    public abstract String getRef(Property var1);

    public void addPortOperations(Class implementation) {
        boolean _not;
        boolean _isAbstract = implementation.isAbstract();
        boolean bl = _not = !_isAbstract;
        if (_not) {
            this.addGetPortOperation(implementation);
        }
        this.addConnectPortOperation(implementation);
    }

    public void addGetPortOperation(Class implementation) {
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)PortUtils.getAllPorts2((EncapsulatedClassifier)implementation));
        for (PortInfo portInfo : _flattenExtendedPorts) {
            List providedIntfs = portInfo.getProvideds();
            if (providedIntfs == null || providedIntfs.isEmpty()) continue;
            if (providedIntfs.size() == 1 && portInfo.getPort().getType() instanceof Interface) {
                this.addGetPortOperation(implementation, portInfo, (Interface)providedIntfs.get(0), portInfo.getName());
                continue;
            }
            for (Interface providedIntf : providedIntfs) {
                String _name = portInfo.getName();
                String _name_1 = providedIntf.getName();
                String _plus = String.valueOf(_name) + _name_1;
                this.addGetPortOperation(implementation, portInfo, providedIntf, _plus);
            }
        }
    }

    public Object addGetPortOperation(Class implementation, PortInfo portInfo, Interface providedIntf, String portName) {
        Parameter _xblockexpression = null;
        String opName = String.valueOf(PrefixConstants.getP_Prefix) + portName;
        Operation op = implementation.getOwnedOperation(opName, null, null);
        Object _xifexpression = null;
        if (op != null) {
            boolean _notEquals;
            Parameter _xifexpression_1 = null;
            Type _type = op.getType();
            boolean bl = _notEquals = !Objects.equal((Object)_type, (Object)providedIntf);
            if (_notEquals) {
                _xifexpression_1 = op.createOwnedParameter("ret", (Type)providedIntf);
            }
            _xifexpression = _xifexpression_1;
        } else {
            boolean _not;
            boolean _xblockexpression_1 = false;
            op = implementation.createOwnedOperation(opName, null, null, (Type)providedIntf);
            Parameter retParam = (Parameter)op.getOwnedParameters().get(0);
            retParam.setName("ret");
            this.applyRef((Element)retParam);
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            op.getMethods().add((Object)behavior);
            List ces = ConnectorUtil.getDelegations((Class)implementation, (Port)portInfo.getModelPort());
            String body = null;
            boolean _isEmpty = ces.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                body = "return ";
                int i = 0;
                while (i < ces.size() && body.equals("return ")) {
                    Type roleType;
                    Property part = ((ConnectorEnd)ces.get(i)).getPartWithPort();
                    ConnectableElement role = ((ConnectorEnd)ces.get(i)).getRole();
                    if (role instanceof Port) {
                        Port rolePort = (Port)role;
                        boolean _contains = rolePort.getProvideds().contains((Object)providedIntf);
                        if (_contains) {
                            boolean _greaterThan;
                            int _size = rolePort.getProvideds().size();
                            boolean bl2 = _greaterThan = _size > 1;
                            if (_greaterThan) {
                                String _body = body;
                                StringConcatenation _builder = new StringConcatenation();
                                String _nameRef = this.nameRef(part);
                                _builder.append(_nameRef);
                                _builder.append(PrefixConstants.getP_Prefix);
                                String _name = ((Port)role).getName();
                                _builder.append(_name);
                                String _name_1 = providedIntf.getName();
                                _builder.append(_name_1);
                                _builder.append("();");
                                body = String.valueOf(_body) + _builder;
                            } else {
                                String _body_1 = body;
                                StringConcatenation _builder_1 = new StringConcatenation();
                                String _nameRef_1 = this.nameRef(part);
                                _builder_1.append(_nameRef_1);
                                _builder_1.append(PrefixConstants.getP_Prefix);
                                String _name_2 = ((Port)role).getName();
                                _builder_1.append(_name_2);
                                _builder_1.append("();");
                                body = String.valueOf(_body_1) + _builder_1;
                            }
                        }
                    } else if (role instanceof Property && (roleType = ((Property)role).getType()) instanceof BehavioredClassifier && ((BehavioredClassifier)roleType).getInterfaceRealization(null, providedIntf) != null) {
                        String _body_2 = body;
                        String _name_3 = ((Property)role).getName();
                        body = String.valueOf(_body_2) + _name_3;
                    }
                    ++i;
                }
            } else {
                boolean implementsIntf;
                InterfaceRealization _interfaceRealization = implementation.getInterfaceRealization(null, providedIntf);
                boolean bl3 = implementsIntf = _interfaceRealization != null;
                if (!implementsIntf) {
                    boolean _tripleNotEquals;
                    Interface providedIntfInCopy = (Interface)this.copier.getCopy((Element)providedIntf);
                    InterfaceRealization _interfaceRealization_1 = implementation.getInterfaceRealization(null, providedIntfInCopy);
                    implementsIntf = _tripleNotEquals = _interfaceRealization_1 != null;
                }
                if (implementsIntf) {
                    body = "return this;";
                } else {
                    String _format = String.format("Interface <%s> provided by port <%s> of class <%s> is not implemented by the component itself nor does the port delegate to a part", providedIntf.getName(), portName, implementation.getName());
                    throw new RuntimeException(_format);
                }
            }
            behavior.getLanguages().add((Object)this.progLang);
            _xblockexpression_1 = behavior.getBodies().add((Object)body);
            _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void addConnectPortOperation(Class implementation) {
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)PortUtils.getAllPorts2((EncapsulatedClassifier)implementation));
        for (PortInfo portInfo : _flattenExtendedPorts) {
            List requiredIntfs = portInfo.getRequireds();
            if (requiredIntfs == null || requiredIntfs.isEmpty()) continue;
            if (requiredIntfs.size() == 1 && portInfo.getPort().getType() instanceof Interface) {
                this.addConnectPortOperation(implementation, portInfo, (Interface)requiredIntfs.get(0), portInfo.getName());
                continue;
            }
            for (Interface requiredIntf : requiredIntfs) {
                String _name = portInfo.getName();
                String _name_1 = requiredIntf.getName();
                String _plus = String.valueOf(_name) + _name_1;
                this.addConnectPortOperation(implementation, portInfo, requiredIntf, _plus);
            }
        }
    }

    public Boolean addConnectPortOperation(Class implementation, PortInfo portInfo, Interface requiredIntf, String portName) {
        boolean _tripleNotEquals;
        Boolean _xblockexpression = null;
        String opName = String.valueOf(PrefixConstants.connectQ_Prefix) + portName;
        Boolean _xifexpression = null;
        Operation _ownedOperation = implementation.getOwnedOperation(opName, null, null);
        boolean bl = _tripleNotEquals = _ownedOperation != null;
        if (_tripleNotEquals) {
            _xifexpression = null;
        } else {
            boolean _not;
            boolean _xblockexpression_1 = false;
            Operation op = implementation.createOwnedOperation(opName, null, null);
            boolean multiPort = portInfo.getUpper() > 1 || portInfo.getUpper() == -1;
            Parameter refParam = op.createOwnedParameter("ref", (Type)requiredIntf);
            this.applyRef((Element)refParam);
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            op.getMethods().add((Object)behavior);
            List ces = ConnectorUtil.getDelegations((Class)implementation, (Port)portInfo.getModelPort());
            String body = "";
            boolean _isEmpty = ces.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                int i = 0;
                while (i < ces.size() && body.isEmpty()) {
                    Property part = ((ConnectorEnd)ces.get(i)).getPartWithPort();
                    ConnectableElement role = ((ConnectorEnd)ces.get(i)).getRole();
                    if (role instanceof Port) {
                        boolean _contains = ((Port)role).getRequireds().contains((Object)requiredIntf);
                        if (_contains) {
                            boolean _greaterThan;
                            body = part.getName();
                            String _name = ((Port)role).getName();
                            String targetOpName = String.valueOf(PrefixConstants.connectQ_Prefix) + _name;
                            int _size = ((Port)role).getRequireds().size();
                            boolean bl3 = _greaterThan = _size > 1;
                            if (_greaterThan) {
                                String _targetOpName = targetOpName;
                                String _name_1 = requiredIntf.getName();
                                targetOpName = String.valueOf(_targetOpName) + _name_1;
                            }
                            StringConcatenation _builder = new StringConcatenation();
                            String _nameRef = this.nameRef(part);
                            _builder.append(_nameRef);
                            _builder.append(targetOpName);
                            _builder.append("(ref);");
                            body = _builder.toString();
                        }
                    } else if (part.getType() instanceof Classifier && ((Classifier)part.getType()).getAllUsedInterfaces().contains((Object)requiredIntf)) {
                        String _body = body;
                        StringConcatenation _builder_1 = new StringConcatenation();
                        String _name_2 = part.getName();
                        _builder_1.append(_name_2);
                        _builder_1.append(";");
                        body = String.valueOf(_body) + _builder_1;
                    }
                    ++i;
                }
            } else {
                String attributeName = String.valueOf(PrefixConstants.attributePrefix) + portName;
                Property attr = implementation.getOwnedAttribute(attributeName, null);
                if (attr == null || attr instanceof Port) {
                    attr = implementation.createOwnedAttribute(attributeName, (Type)requiredIntf);
                    CopyUtils.copyMultElemModifiers((MultiplicityElement)portInfo.getPort(), (MultiplicityElement)attr);
                    attr.setAggregation(AggregationKind.SHARED_LITERAL);
                }
                body = attributeName;
                if (multiPort) {
                    String _body = body;
                    body = String.valueOf(_body) + "[index]";
                }
                String _body_1 = body;
                body = String.valueOf(_body_1) + " = ref;";
            }
            behavior.getLanguages().add((Object)this.progLang);
            behavior.getBodies().add((Object)body);
            boolean _xifexpression_1 = false;
            if (PrefixConstants.getConnQ_Prefix.length() > 0 && !ces.isEmpty()) {
                boolean _xblockexpression_2 = false;
                String getConnOpName = String.valueOf(PrefixConstants.getConnQ_Prefix) + portName;
                Operation getConnOp = implementation.getOwnedOperation(getConnOpName, null, null);
                if (getConnOp == null) {
                    getConnOp = implementation.createOwnedOperation(getConnOpName, null, null, (Type)requiredIntf);
                    Parameter retParam = (Parameter)op.getOwnedParameters().get(0);
                    retParam.setName("ret");
                    this.applyRef((Element)retParam);
                }
                Behavior _createOwnedBehavior_1 = implementation.createOwnedBehavior(getConnOpName, UMLPackage.eINSTANCE.getOpaqueBehavior());
                OpaqueBehavior getConnBehavior = (OpaqueBehavior)_createOwnedBehavior_1;
                getConnOp.getMethods().add((Object)getConnBehavior);
                String name = String.valueOf(PrefixConstants.attributePrefix) + portName;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                _builder.append(name);
                _builder.append(";");
                body = _builder.toString();
                behavior.getLanguages().add((Object)this.progLang);
                _xifexpression_1 = _xblockexpression_2 = behavior.getBodies().add((Object)body);
            }
            _xblockexpression_1 = _xifexpression_1;
            _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void addConnectionOperation(Class compositeImplementation) throws TransformationException {
        boolean _greaterThan;
        String createConnBody = "";
        HashMap indexMap = new HashMap();
        EList _ownedConnectors = compositeImplementation.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            boolean _notEquals;
            boolean _isAssembly = ConnectorUtil.isAssembly((Connector)connector);
            if (!_isAssembly) continue;
            int _size = connector.getEnds().size();
            boolean bl = _notEquals = _size != 2;
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Connector <");
                String _name = connector.getName();
                _builder.append(_name);
                _builder.append("> does not have two ends. This is currently not supported");
                throw new TransformationException(_builder.toString());
            }
            ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
            ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("// realization of connector <");
            String _name_1 = connector.getName();
            _builder_1.append(_name_1);
            _builder_1.append(">");
            String cmd = String.valueOf(_builder_1.toString()) + NL;
            if (end1.getRole() instanceof Port && PortUtils.isExtendedPort((Port)((Port)end1.getRole()))) {
                ConnectableElement _role = end1.getRole();
                Port port = (Port)_role;
                EList subPorts = PortUtils.flattenExtendedPort((Port)port);
                for (PortInfo subPort : subPorts) {
                    String _cmd = cmd;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("  ");
                    _builder_2.append("// realization of connection for sub-port ");
                    String _name_2 = subPort.getPort().getName();
                    _builder_2.append(_name_2, "  ");
                    String _plus = String.valueOf(_builder_2.toString()) + NL;
                    String _cmd_1 = cmd = String.valueOf(_cmd) + _plus;
                    String _connectPorts = this.connectPorts(connector, end1, end2, subPort.getPort());
                    String _cmd_2 = cmd = String.valueOf(_cmd_1) + _connectPorts;
                    String _connectPorts_1 = this.connectPorts(connector, end2, end1, subPort.getPort());
                    cmd = String.valueOf(_cmd_2) + _connectPorts_1;
                }
            } else {
                String _cmd = cmd;
                String _connectPorts = this.connectPorts(connector, end1, end2, null);
                String _cmd_1 = cmd = String.valueOf(_cmd) + _connectPorts;
                String _connectPorts_1 = this.connectPorts(connector, end2, end1, null);
                cmd = String.valueOf(_cmd_1) + _connectPorts_1;
            }
            String _createConnBody = createConnBody;
            createConnBody = String.valueOf(_createConnBody) + cmd + NL;
        }
        int _length = createConnBody.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            Operation operation = compositeImplementation.createOwnedOperation("createConnections", null, null);
            Behavior _createOwnedBehavior = compositeImplementation.createOwnedBehavior(operation.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            behavior.getLanguages().add((Object)this.progLang);
            behavior.getBodies().add((Object)createConnBody);
            behavior.setSpecification((BehavioralFeature)operation);
        }
    }

    public String connectPorts(Connector connector, ConnectorEnd receptacleEnd, ConnectorEnd facetEnd, Port subPort) throws TransformationException {
        Association association = connector.getType();
        if (receptacleEnd.getRole() instanceof Port && facetEnd.getRole() instanceof Port) {
            ConnectableElement _role = facetEnd.getRole();
            Port facetPort = (Port)_role;
            ConnectableElement _role_1 = receptacleEnd.getRole();
            Port receptaclePort = (Port)_role_1;
            PortInfo facetPI = PortInfo.fromSubPort((Port)facetPort, (Port)subPort);
            PortInfo receptaclePI = PortInfo.fromSubPort((Port)receptaclePort, (Port)subPort);
            if (facetPI.getProvided() != null && receptaclePI.getRequired() != null) {
                boolean _greaterThan;
                Property facetPart = facetEnd.getPartWithPort();
                Property receptaclePart = receptacleEnd.getPartWithPort();
                String subPortName = "";
                if (subPort != null) {
                    String _subPortName = subPortName;
                    String _name = subPort.getName();
                    String _plus = "_" + _name;
                    subPortName = String.valueOf(_subPortName) + _plus;
                }
                String result = "";
                int _size = receptaclePI.getRequireds().size();
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    List _requireds = receptaclePI.getRequireds();
                    for (Interface requiredInterface : _requireds) {
                        boolean _isEmpty;
                        boolean _not;
                        String _name_1 = receptaclePI.getName();
                        String _name_2 = requiredInterface.getName();
                        String receptaclePortName = String.valueOf(_name_1) + _name_2;
                        String facetPortName = "";
                        boolean _contains = facetPI.getProvideds().contains(requiredInterface);
                        if (_contains) {
                            boolean _greaterThan_1;
                            String _facetPortName = facetPortName;
                            String _name_3 = facetPI.getName();
                            facetPortName = String.valueOf(_facetPortName) + _name_3;
                            int _size_1 = facetPI.getProvideds().size();
                            boolean bl2 = _greaterThan_1 = _size_1 > 1;
                            if (_greaterThan_1) {
                                String _facetPortName_1 = facetPortName;
                                String _name_4 = requiredInterface.getName();
                                facetPortName = String.valueOf(_facetPortName_1) + _name_4;
                            }
                        }
                        boolean bl3 = _not = !(_isEmpty = facetPortName.isEmpty());
                        if (!_not) continue;
                        StringConcatenation _builder = new StringConcatenation();
                        String _nameRef = this.nameRef(receptaclePart);
                        _builder.append(_nameRef);
                        _builder.append("connect_");
                        _builder.append(receptaclePortName);
                        _builder.append(subPortName);
                        String setter = _builder.toString();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        String _nameRef_1 = this.nameRef(facetPart);
                        _builder_1.append(_nameRef_1);
                        _builder_1.append("get_");
                        _builder_1.append(facetPortName);
                        _builder_1.append(subPortName);
                        _builder_1.append("()");
                        String getter = _builder_1.toString();
                        String _result = result;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append(setter);
                        _builder_2.append("(");
                        _builder_2.append(getter);
                        _builder_2.append(");");
                        String _plus_1 = String.valueOf(_builder_2.toString()) + NL;
                        result = String.valueOf(_result) + _plus_1;
                    }
                } else {
                    boolean _not;
                    String facetPortName = "";
                    if (facetPI.getProvideds().size() > 1 && facetPI.getProvideds().contains(receptaclePI.getRequired())) {
                        String _facetPortName = facetPortName;
                        String _name_1 = facetPI.getName();
                        String _name_2 = receptaclePI.getRequired().getName();
                        String _plus_1 = String.valueOf(_name_1) + _name_2;
                        facetPortName = String.valueOf(_facetPortName) + _plus_1;
                    } else {
                        boolean _equals;
                        int _size_1 = facetPI.getProvideds().size();
                        boolean bl4 = _equals = _size_1 == 1;
                        if (_equals) {
                            facetPortName = facetPI.getName();
                        }
                    }
                    boolean _isEmpty = facetPortName.isEmpty();
                    boolean bl5 = _not = !_isEmpty;
                    if (_not) {
                        StringConcatenation _builder = new StringConcatenation();
                        String _nameRef = this.nameRef(receptaclePart);
                        _builder.append(_nameRef);
                        _builder.append("connect_");
                        String _name_3 = receptaclePort.getName();
                        _builder.append(_name_3);
                        _builder.append(subPortName);
                        String setter = _builder.toString();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        String _nameRef_1 = this.nameRef(facetPart);
                        _builder_1.append(_nameRef_1);
                        _builder_1.append("get_");
                        _builder_1.append(facetPortName);
                        _builder_1.append(subPortName);
                        _builder_1.append("()");
                        String getter = _builder_1.toString();
                        String _result = result;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append(setter);
                        _builder_2.append("(");
                        _builder_2.append(getter);
                        _builder_2.append(");");
                        String _plus_2 = String.valueOf(_builder_2.toString()) + NL;
                        result = String.valueOf(_result) + _plus_2;
                    }
                }
                return result;
            }
        } else {
            ConnectableElement _role_2 = receptacleEnd.getRole();
            if (_role_2 instanceof Port) {
                boolean _tripleNotEquals;
                ConnectableElement _role_3 = receptacleEnd.getRole();
                Port receptaclePort_1 = (Port)_role_3;
                Interface _required = PortUtils.getRequired((Port)receptaclePort_1);
                boolean bl = _tripleNotEquals = _required != null;
                if (_tripleNotEquals) {
                    boolean _greaterThan_1;
                    ConnectableElement _role_4 = facetEnd.getRole();
                    Property facetPart_1 = (Property)_role_4;
                    Property receptaclePart_1 = facetEnd.getPartWithPort();
                    String result_1 = "";
                    int _size_2 = receptaclePort_1.getRequireds().size();
                    boolean bl6 = _greaterThan_1 = _size_2 > 1;
                    if (_greaterThan_1) {
                        EList _requireds_1 = receptaclePort_1.getRequireds();
                        for (Interface requiredInterface_1 : _requireds_1) {
                            String _name_4 = receptaclePort_1.getName();
                            String _name_5 = requiredInterface_1.getName();
                            String receptaclePortName = String.valueOf(_name_4) + _name_5;
                            StringConcatenation _builder_3 = new StringConcatenation();
                            String _nameRef_2 = this.nameRef(receptaclePart_1);
                            _builder_3.append(_nameRef_2);
                            _builder_3.append("connect_");
                            _builder_3.append(receptaclePortName);
                            String setter_1 = _builder_3.toString();
                            StringConcatenation _builder_4 = new StringConcatenation();
                            String _ref = this.getRef(facetPart_1);
                            _builder_4.append(_ref);
                            String getter_1 = _builder_4.toString();
                            String _result_1 = result_1;
                            StringConcatenation _builder_5 = new StringConcatenation();
                            _builder_5.append(setter_1);
                            _builder_5.append("(");
                            _builder_5.append(getter_1);
                            _builder_5.append(");");
                            String _plus_3 = String.valueOf(_builder_5.toString()) + NL;
                            result_1 = String.valueOf(_result_1) + _plus_3;
                        }
                    } else {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        String _nameRef_2 = this.nameRef(receptaclePart_1);
                        _builder_3.append(_nameRef_2);
                        _builder_3.append("connect_");
                        String _name_4 = receptaclePort_1.getName();
                        _builder_3.append(_name_4);
                        String setter_1 = _builder_3.toString();
                        StringConcatenation _builder_4 = new StringConcatenation();
                        String _ref = this.getRef(facetPart_1);
                        _builder_4.append(_ref);
                        String getter_1 = _builder_4.toString();
                        String _result_1 = result_1;
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append(setter_1);
                        _builder_5.append("(");
                        _builder_5.append(getter_1);
                        _builder_5.append(");");
                        String _plus_3 = String.valueOf(_builder_5.toString()) + NL;
                        result_1 = String.valueOf(_result_1) + _plus_3;
                    }
                    return result_1;
                }
            } else {
                ConnectableElement _role_5 = facetEnd.getRole();
                if (_role_5 instanceof Port) {
                    boolean _tripleNotEquals_1;
                    ConnectableElement _role_6 = facetEnd.getRole();
                    Port facetPort_1 = (Port)_role_6;
                    Interface _provided = PortUtils.getProvided((Port)facetPort_1);
                    boolean bl = _tripleNotEquals_1 = _provided != null;
                    if (_tripleNotEquals_1) {
                        boolean _greaterThan_2;
                        Property facetPart_2 = facetEnd.getPartWithPort();
                        ConnectableElement _role_7 = facetEnd.getRole();
                        Property receptaclePart_2 = (Property)_role_7;
                        String result_2 = "";
                        int _size_3 = facetPort_1.getProvideds().size();
                        boolean bl7 = _greaterThan_2 = _size_3 > 1;
                        if (_greaterThan_2) {
                            EList _provideds = facetPort_1.getProvideds();
                            for (Interface providedInterface : _provideds) {
                                String _name_5 = facetPort_1.getName();
                                String _name_6 = providedInterface.getName();
                                String facetPortName_1 = String.valueOf(_name_5) + _name_6;
                                String setter_2 = receptaclePart_2.getName();
                                StringConcatenation _builder_6 = new StringConcatenation();
                                String _nameRef_3 = this.nameRef(facetPart_2);
                                _builder_6.append(_nameRef_3);
                                _builder_6.append("get_");
                                _builder_6.append(facetPortName_1);
                                _builder_6.append("();");
                                String getter_2 = _builder_6.toString();
                                String _result_2 = result_2;
                                StringConcatenation _builder_7 = new StringConcatenation();
                                _builder_7.append(setter_2);
                                _builder_7.append(" = ");
                                _builder_7.append(getter_2);
                                _builder_7.append(";");
                                String _plus_4 = String.valueOf(_builder_7.toString()) + NL;
                                result_2 = String.valueOf(_result_2) + _plus_4;
                            }
                        } else {
                            String setter_2 = receptaclePart_2.getName();
                            StringConcatenation _builder_6 = new StringConcatenation();
                            String _nameRef_3 = this.nameRef(facetPart_2);
                            _builder_6.append(_nameRef_3);
                            _builder_6.append("get_");
                            String _name_5 = facetPort_1.getName();
                            _builder_6.append(_name_5);
                            _builder_6.append("();");
                            String getter_2 = _builder_6.toString();
                            String _result_2 = result_2;
                            StringConcatenation _builder_7 = new StringConcatenation();
                            _builder_7.append(setter_2);
                            _builder_7.append(" = ");
                            _builder_7.append(getter_2);
                            _builder_7.append(";");
                            String _plus_4 = String.valueOf(_builder_7.toString()) + NL;
                            result_2 = String.valueOf(_result_2) + _plus_4;
                        }
                        return result_2;
                    }
                } else if (association != null) {
                    ConnectableElement _role_8 = facetEnd.getRole();
                    Property facetPart_3 = (Property)_role_8;
                    ConnectableElement _role_9 = receptacleEnd.getRole();
                    Property receptaclePart_3 = (Property)_role_9;
                    Property assocProp1 = association.getMemberEnd(null, facetPart_3.getType());
                    if (assocProp1 != null && assocProp1.isNavigable()) {
                        StringConcatenation _builder_8 = new StringConcatenation();
                        String _name_6 = receptaclePart_3.getName();
                        _builder_8.append(_name_6);
                        _builder_8.append(".");
                        String _name_7 = assocProp1.getName();
                        _builder_8.append(_name_7);
                        String setter_3 = _builder_8.toString();
                        StringConcatenation _builder_9 = new StringConcatenation();
                        String _name_8 = facetPart_3.getName();
                        _builder_9.append(_name_8);
                        String getter_3 = _builder_9.toString();
                        StringConcatenation _builder_10 = new StringConcatenation();
                        _builder_10.append(setter_3);
                        _builder_10.append(" = ");
                        _builder_10.append(getter_3);
                        _builder_10.append(";");
                        return String.valueOf(_builder_10.toString()) + NL;
                    }
                } else {
                    String _name_9 = connector.getName();
                    String _plus_5 = "Connector <" + _name_9;
                    String _plus_6 = String.valueOf(_plus_5) + "> does not use ports, but it is not typed (only connectors between ports should not be typed)";
                    throw new TransformationException(_plus_6);
                }
            }
        }
        return "";
    }

    public static boolean instantiateViaBootloader(Class implementation) {
        return implementation.isAbstract() || StereotypeUtil.isApplied((Element)implementation, Assembly.class);
    }

    public static boolean instantiateViaBootloader(StructuralFeature part) {
        if (part != null) {
            Type _type = part.getType();
            if (_type instanceof Class) {
                Type _type_1 = part.getType();
                Class implementation = (Class)_type_1;
                return AbstractCompToOO.instantiateViaBootloader(implementation);
            }
            return false;
        }
        return false;
    }

    public boolean hasMultipleDelegationsInDepth(Port port) {
        Element owner = port.getOwner();
        if (owner instanceof Class) {
            ConnectorEnd ce;
            ConnectableElement role;
            boolean _equals;
            boolean _greaterThan;
            List ces = ConnectorUtil.getDelegations((Class)((Class)owner), (Port)port);
            int _size = ces.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                return true;
            }
            int _size_1 = ces.size();
            boolean bl2 = _equals = _size_1 == 1;
            if (_equals && (role = (ce = (ConnectorEnd)ces.get(0)).getRole()) instanceof Port) {
                return this.hasMultipleDelegationsInDepth((Port)role);
            }
        }
        return false;
    }
}

