/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.mappingrules;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.fcm.profile.IMappingRule;
import org.eclipse.papyrus.designer.components.fcm.profile.utils.PortMapUtil;
import org.eclipse.papyrus.designer.components.modellibs.core.Activator;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.transformation.base.utils.RealizationUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;

public class PullConsumer
implements IMappingRule {
    public static String PULL_I_PREFIX = "PullConsumer_";
    public static String PULL_C_PREFIX = "CPullConsumer_";
    public static String PULL_OP_NAME = "pull";
    public static String HASDATA_OP_NAME = "hasData";
    public static String RET_PAR_NAME = "ret";
    public static String BOOL_QNAME = "PrimitiveTypes::Boolean";
    protected static PullConsumer instance;

    public boolean needsUpdate(Port p) {
        Type type = p.getType();
        if (type instanceof PrimitiveType || type instanceof DataType || type instanceof Signal) {
            Interface derivedInterface = PortMapUtil.getDerivedInterface((Port)p, (String)PULL_I_PREFIX);
            if (derivedInterface == null) {
                return true;
            }
            Operation derivedOperation = derivedInterface.getOperation(PULL_OP_NAME, null, null);
            if (derivedOperation == null) {
                return true;
            }
            EList parameters = derivedOperation.getOwnedParameters();
            if (parameters.size() != 1) {
                return true;
            }
            Parameter parameter = (Parameter)parameters.get(0);
            if (!parameter.getName().equals(RET_PAR_NAME)) {
                return true;
            }
            if (parameter.getType() != type) {
                return true;
            }
        }
        return false;
    }

    public static PullConsumer getInstance() {
        if (instance == null) {
            instance = new PullConsumer();
        }
        return instance;
    }

    public Type calcDerivedType(Port p, boolean update) {
        org.eclipse.uml2.uml.Port umlPort = p.getBase_Port();
        Element owner = umlPort.getOwner();
        String ownerStr = "";
        if (owner instanceof NamedElement) {
            ownerStr = " of class " + ((NamedElement)owner).getQualifiedName();
        }
        Activator.log.info(String.format("%s => GetRequired on %s", p.getKind().getBase_Class().getName(), String.valueOf(umlPort.getName()) + ownerStr));
        Type type = p.getType();
        if (type instanceof PrimitiveType || type instanceof DataType || type instanceof Signal) {
            EList parameters;
            Class derivedClass = PortMapUtil.getDerivedClass((Port)p, (String)PULL_C_PREFIX, (boolean)update);
            Interface derivedInterface = PortMapUtil.getDerivedInterface((Port)p, (String)PULL_I_PREFIX, (boolean)update);
            RealizationUtils.addUsage((Class)derivedClass, (Interface)derivedInterface);
            if (!update) {
                return derivedClass;
            }
            if (derivedInterface == null) {
                return null;
            }
            Operation derivedOperationPull = derivedInterface.getOperation(PULL_OP_NAME, null, null);
            if (derivedOperationPull == null) {
                derivedOperationPull = derivedInterface.createOwnedOperation(PULL_OP_NAME, null, null, type);
            }
            if ((parameters = derivedOperationPull.getOwnedParameters()).size() > 0) {
                Parameter parameter = (Parameter)parameters.get(0);
                if (parameter.getName() == null || !parameter.getName().equals(RET_PAR_NAME)) {
                    parameter.setName(RET_PAR_NAME);
                }
                if (parameter.getType() != type) {
                    parameter.setType(type);
                }
            }
            Package model = PackageUtil.getRootPackage((Element)umlPort);
            PackageUtil.loadPackage((URI)StdUriConstants.UML_PRIM_TYPES_URI, (ResourceSet)model.eResource().getResourceSet());
            NamedElement element = ElementUtils.getQualifiedElementFromRS((Element)model, (String)BOOL_QNAME);
            Type booleanType = null;
            if (!(element instanceof Type)) {
                throw new RuntimeException(String.format("Cannot find type %s. Check whether the UML primitive types library has been imported.", BOOL_QNAME));
            }
            booleanType = (Type)element;
            Operation derivedOperationHasData = derivedInterface.getOperation(HASDATA_OP_NAME, null, null);
            if (derivedOperationHasData == null) {
                derivedOperationHasData = derivedInterface.createOwnedOperation(HASDATA_OP_NAME, null, null, booleanType);
            }
            if ((parameters = derivedOperationHasData.getOwnedParameters()).size() > 0) {
                Parameter parameter = (Parameter)parameters.get(0);
                if (parameter.getName() == null || !parameter.getName().equals(RET_PAR_NAME)) {
                    parameter.setName(RET_PAR_NAME);
                }
                if (booleanType != null && parameter.getType() != booleanType) {
                    parameter.setType(booleanType);
                }
            }
            return derivedClass;
        }
        return null;
    }
}

