/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactHashSet<E>
extends AbstractSet<E> {
    static final Object DELETED_VALUE = new Object();
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Object NULL_VALUE = new Object();
    transient E[] data;
    transient int deleted;
    transient float loadFactor;
    volatile transient int modCount;
    transient int size;
    transient int threshold;

    public CompactHashSet() {
        this.data = new Object[16];
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.init();
    }

    public CompactHashSet(Collection<? extends E> collection) {
        this.initialize(Math.max(collection.size() + 1, 16));
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)this.data.length * 0.75f);
        this.init();
        for (E element : collection) {
            this.addForCreate(element);
        }
    }

    public CompactHashSet(int elementCount) {
        this(elementCount, 0.75f);
    }

    public CompactHashSet(int elementCount, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException(Float.toString(loadFactor));
        }
        this.initialize(elementCount);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.data.length * loadFactor);
        this.init();
    }

    protected static int supplementalHash(int hashCode) {
        int newHash = hashCode;
        newHash ^= newHash >>> 20 ^ newHash >>> 12;
        return newHash ^ newHash >>> 7 ^ newHash >>> 4;
    }

    protected static <T> T unmaskNull(T element) {
        if (element == NULL_VALUE) {
            return null;
        }
        return element;
    }

    private static int getNextPowerOfTwo(int number) {
        int powerOfTwo = number - 1;
        powerOfTwo |= powerOfTwo >> 1;
        powerOfTwo |= powerOfTwo >> 2;
        powerOfTwo |= powerOfTwo >> 4;
        powerOfTwo |= powerOfTwo >> 8;
        powerOfTwo |= powerOfTwo >> 16;
        return ++powerOfTwo;
    }

    private static <T> T maskNull(T element) {
        if (element == null) {
            return (T)NULL_VALUE;
        }
        return element;
    }

    @Override
    public boolean add(E element) {
        if (element == null) {
            return this.addNull();
        }
        return this.addValue(element);
    }

    @Override
    public void clear() {
        ++this.modCount;
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = null;
            ++i;
        }
        this.size = 0;
        this.deleted = 0;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new SetIterator();
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.deleteIndex(index);
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void deleteIndex(int index) {
        this.data[index] = DELETED_VALUE;
        ++this.modCount;
        ++this.deleted;
        --this.size;
    }

    protected void init() {
    }

    protected void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        int length = this.data.length;
        Object[] temp = new Object[newCapacity];
        int i = 0;
        while (i < length) {
            if (this.data[i] != null && this.data[i] != DELETED_VALUE) {
                int hash = CompactHashSet.supplementalHash(this.data[i].hashCode());
                int insertionIndex = hash & mask;
                while (temp[insertionIndex] != null) {
                    insertionIndex = insertionIndex + 1 & mask;
                }
                temp[insertionIndex] = this.data[i];
            }
            ++i;
        }
        this.data = temp;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    protected void setIndex(int index, E element) {
        this.data[index] = element;
    }

    private void addForCreate(E element) {
        E actualElement = CompactHashSet.maskNull(element);
        int mask = this.data.length - 1;
        int hash = CompactHashSet.supplementalHash(actualElement.hashCode());
        int insertionIndex = hash & mask;
        while (this.data[insertionIndex] != null) {
            if (this.data[insertionIndex].equals(actualElement)) {
                return;
            }
            insertionIndex = insertionIndex + 1 & mask;
        }
        this.setIndex(insertionIndex, actualElement);
        ++this.modCount;
        ++this.size;
    }

    private boolean addNull() {
        int mask = this.data.length - 1;
        int hash = CompactHashSet.supplementalHash(NULL_VALUE.hashCode());
        int index = hash & mask;
        int deletedIndex = -1;
        while (this.data[index] != null) {
            E value = this.data[index];
            if (value == NULL_VALUE) {
                return false;
            }
            if (deletedIndex < 0 && value == DELETED_VALUE) {
                deletedIndex = index;
            }
            index = index + 1 & mask;
        }
        if (deletedIndex >= 0) {
            this.setIndex(deletedIndex, NULL_VALUE);
            ++this.modCount;
            --this.deleted;
            ++this.size;
        } else {
            this.setIndex(index, NULL_VALUE);
            ++this.modCount;
            if (this.size++ + this.deleted >= this.threshold) {
                this.rehash();
            }
        }
        return true;
    }

    private boolean addValue(E element) {
        int mask = this.data.length - 1;
        int hash = CompactHashSet.supplementalHash(element.hashCode());
        int index = hash & mask;
        int deletedIndex = -1;
        while (this.data[index] != null) {
            E value = this.data[index];
            if (value.equals(element)) {
                return false;
            }
            if (deletedIndex < 0 && value == DELETED_VALUE) {
                deletedIndex = index;
            }
            index = index + 1 & mask;
        }
        if (deletedIndex >= 0) {
            this.setIndex(deletedIndex, element);
            ++this.modCount;
            --this.deleted;
            ++this.size;
        } else {
            this.setIndex(index, element);
            ++this.modCount;
            if (this.size++ + this.deleted >= this.threshold) {
                this.rehash();
            }
        }
        return true;
    }

    private int indexOf(Object element) {
        Object actualElement = CompactHashSet.maskNull(element);
        int mask = this.data.length - 1;
        int hash = CompactHashSet.supplementalHash(actualElement.hashCode());
        int index = hash & mask;
        while (this.data[index] != null) {
            if (this.data[index].equals(actualElement)) {
                return index;
            }
            index = index + 1 & mask;
        }
        return -1;
    }

    private void initialize(int elementCount) {
        int initialCapacity = elementCount <= 0 ? 4 : CompactHashSet.getNextPowerOfTwo(elementCount);
        if (initialCapacity < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.data = new Object[initialCapacity];
    }

    private void rehash() {
        int length = this.data.length;
        int deletedThreshold = Math.max((int)((double)length * 0.1), 10);
        if (this.deleted > deletedThreshold) {
            this.rehash(length);
        } else {
            int newCapacity = this.data.length << 1;
            if (newCapacity < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.rehash(newCapacity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SetIterator
    implements Iterator<E> {
        private int expectedModCount;
        private int lastReturned;
        private int next;

        SetIterator() {
            this.expectedModCount = CompactHashSet.this.modCount;
            this.lastReturned = -1;
            if (!CompactHashSet.this.isEmpty()) {
                while (this.next < CompactHashSet.this.data.length && (CompactHashSet.this.data[this.next] == null || CompactHashSet.this.data[this.next] == DELETED_VALUE)) {
                    ++this.next;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next < CompactHashSet.this.data.length && CompactHashSet.this.data[this.next] != null && CompactHashSet.this.data[this.next] != DELETED_VALUE;
        }

        @Override
        public E next() {
            this.checkComodification();
            if (this.next == CompactHashSet.this.data.length) {
                throw new NoSuchElementException();
            }
            Object result = CompactHashSet.this.data[this.next];
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next++;
            while (this.next < CompactHashSet.this.data.length && (CompactHashSet.this.data[this.next] == null || CompactHashSet.this.data[this.next] == DELETED_VALUE)) {
                ++this.next;
            }
            return CompactHashSet.unmaskNull(result);
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            CompactHashSet.this.remove(CompactHashSet.this.data[this.lastReturned]);
            ++this.expectedModCount;
            this.lastReturned = -1;
        }

        private void checkComodification() throws ConcurrentModificationException {
            if (this.expectedModCount != CompactHashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

