/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DynamicModulesURIConverter
extends ExtensibleURIConverterImpl {
    private URIConverter parent;
    private final AcceleoEvaluationEnvironment parentEnvironment;

    DynamicModulesURIConverter(URIConverter parent, AcceleoEvaluationEnvironment parentEnvironment) {
        this.parent = parent;
        this.parentEnvironment = parentEnvironment;
    }

    public URI normalize(URI uri) {
        URI normalized = this.normalizeWithParent(uri);
        if (normalized == null || normalized.equals((Object)uri)) {
            normalized = this.dynamicNormalize(uri);
        }
        return normalized;
    }

    public Map<URI, URI> getURIMap() {
        if (this.parent != null) {
            return this.parent.getURIMap();
        }
        return super.getURIMap();
    }

    public EList<URIHandler> getURIHandlers() {
        if (this.parent != null) {
            return this.parent.getURIHandlers();
        }
        return super.getURIHandlers();
    }

    public URIHandler getURIHandler(URI uri) {
        if (this.parent != null) {
            return this.parent.getURIHandler(uri);
        }
        return super.getURIHandler(uri);
    }

    public EList<ContentHandler> getContentHandlers() {
        if (this.parent != null) {
            return this.parent.getContentHandlers();
        }
        return super.getContentHandlers();
    }

    public InputStream createInputStream(URI uri) throws IOException {
        if (this.parent != null) {
            return this.parent.createInputStream(uri);
        }
        return super.createInputStream(uri);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        if (this.parent != null) {
            return this.parent.createInputStream(uri, options);
        }
        return super.createInputStream(uri, options);
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        if (this.parent != null) {
            return this.parent.createOutputStream(uri);
        }
        return super.createOutputStream(uri);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        if (this.parent != null) {
            return this.parent.createOutputStream(uri, options);
        }
        return super.createOutputStream(uri, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        if (this.parent != null) {
            this.parent.delete(uri, options);
        }
        super.delete(uri, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        if (this.parent != null) {
            return this.parent.contentDescription(uri, options);
        }
        return super.contentDescription(uri, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        if (this.parent != null) {
            return this.parent.exists(uri, options);
        }
        return super.exists(uri, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        if (this.parent != null) {
            return this.parent.getAttributes(uri, options);
        }
        return super.getAttributes(uri, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        if (this.parent != null) {
            this.parent.setAttributes(uri, attributes, options);
        }
        super.setAttributes(uri, attributes, options);
    }

    private URI normalizeWithParent(URI uri) {
        if (this.parent != null) {
            return this.parent.normalize(uri);
        }
        return uri;
    }

    private URI dynamicNormalize(URI uri) {
        BundleURLConverter conv;
        URI normalized = this.getURIMap().get(uri);
        if (normalized == null && (conv = new BundleURLConverter(uri.toString())).resolveBundle() != null) {
            normalized = URI.createURI((String)conv.resolveAsPlatformPlugin());
        }
        if (!(normalized != null || "emtl".equals(uri.fileExtension()) && "file".equals(uri.scheme()))) {
            normalized = super.normalize(uri);
        }
        if (normalized != null) {
            this.getURIMap().put(uri, normalized);
            return normalized;
        }
        String moduleName = uri.lastSegment();
        moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
        LinkedHashSet<URI> candidateURIs = new LinkedHashSet<URI>();
        Set<Module> candidateModules = this.searchCurrentModuleForCandidateMatches(moduleName);
        for (Module candidateModule : candidateModules) {
            candidateURIs.add(candidateModule.eResource().getURI());
        }
        if (candidateURIs.size() == 0) {
            candidateURIs.addAll(this.searchResourceSetForMatches(moduleName));
        }
        if (candidateURIs.size() == 1) {
            normalized = (URI)candidateURIs.iterator().next();
        } else if (candidateURIs.size() > 0) {
            normalized = this.findBestMatchFor(uri, candidateURIs);
        }
        if ((normalized == null || "file".equals(normalized.scheme())) && EMFPlugin.IS_ECLIPSE_RUNNING) {
            BundleURLConverter conv2 = new BundleURLConverter(uri.toString());
            if (conv2.resolveBundle() != null) {
                normalized = URI.createURI((String)conv2.resolveAsPlatformPlugin());
            } else {
                String resolvedPath;
                String uriToString = uri.toString();
                if (uriToString.indexOf(35) > 0) {
                    uriToString = uriToString.substring(0, uriToString.indexOf(35));
                }
                if ((resolvedPath = AcceleoWorkspaceUtil.resolveInBundles((String)uriToString)) != null) {
                    normalized = URI.createURI((String)resolvedPath);
                }
            }
        }
        if (normalized == null) {
            normalized = super.normalize(uri);
        }
        if (!uri.equals((Object)normalized)) {
            this.getURIMap().put(uri, normalized);
        }
        return normalized;
    }

    private URI findBestMatchFor(URI uri, Set<URI> candidateURIs) {
        URI normalized = null;
        Iterator<URI> candidatesIterator = candidateURIs.iterator();
        List<String> referenceSegments = Arrays.asList(uri.segments());
        Collections.reverse(referenceSegments);
        int highestEqualFragments = 0;
        while (candidatesIterator.hasNext()) {
            URI next = candidatesIterator.next();
            int equalFragments = 0;
            List<String> candidateSegments = Arrays.asList(next.segments());
            Collections.reverse(candidateSegments);
            int i = 0;
            while (i < Math.min(candidateSegments.size(), referenceSegments.size())) {
                if (candidateSegments.get(i) != referenceSegments.get(i)) break;
                ++equalFragments;
                ++i;
            }
            if (equalFragments <= highestEqualFragments) continue;
            highestEqualFragments = equalFragments;
            normalized = next;
        }
        return normalized;
    }

    private Set<Module> searchCurrentModuleForCandidateMatches(String moduleName) {
        LinkedHashSet<Module> candidates = new LinkedHashSet<Module>();
        for (Module module : this.parentEnvironment.getCurrentModules()) {
            if (!moduleName.equals(module.getName())) continue;
            candidates.add(module);
        }
        return candidates;
    }

    private Set<URI> searchResourceSetForMatches(String moduleName) {
        LinkedHashSet<URI> candidates = new LinkedHashSet<URI>();
        ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
        for (Module module : this.parentEnvironment.getCurrentModules()) {
            ResourceSet resourceSet;
            if (module == null || module.eResource() == null || resourceSets.contains(resourceSet = module.eResource().getResourceSet())) continue;
            resourceSets.add(resourceSet);
        }
        for (ResourceSet resourceSet : resourceSets) {
            for (Resource resource : resourceSet.getResources()) {
                if (!"emtl".equals(resource.getURI().fileExtension())) continue;
                String candidateName = resource.getURI().lastSegment();
                if (!moduleName.equals(candidateName = candidateName.substring(0, candidateName.lastIndexOf(46)))) continue;
                candidates.add(resource.getURI());
            }
        }
        return candidates;
    }
}

