/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.DefaultStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAcceleoGenerator {
    protected List<? extends Object> generationArguments;
    protected List<IAcceleoTextGenerationListener> generationListeners = new ArrayList<IAcceleoTextGenerationListener>(1);
    protected EObject model;
    protected Module module;
    @Deprecated
    protected List<String> propertiesFiles = new ArrayList<String>(1);
    protected File targetFolder;
    protected Set<Resource> originalResources = new HashSet<Resource>();

    public void addGenerationListener(IAcceleoTextGenerationListener listener) {
        this.generationListeners.add(listener);
    }

    public void doGenerate(Monitor monitor) throws IOException {
        this.generate(monitor);
    }

    public Map<String, String> generate(Monitor monitor) throws IOException {
        File target = this.getTargetFolder();
        if (!target.exists() && !target.mkdirs()) {
            throw new IOException("target directory " + target + " couldn't be created.");
        }
        AcceleoService service = this.createAcceleoService();
        String[] templateNames = this.getTemplateNames();
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i < templateNames.length) {
            result.putAll(service.doGenerate(this.getModule(), templateNames[i], this.getModel(), this.getArguments(), target, monitor));
            ++i;
        }
        this.postGenerate(this.getModule().eResource().getResourceSet());
        this.originalResources.clear();
        return result;
    }

    public List<? extends Object> getArguments() {
        return this.generationArguments;
    }

    public List<IAcceleoTextGenerationListener> getGenerationListeners() {
        return new ArrayList<IAcceleoTextGenerationListener>();
    }

    public IAcceleoGenerationStrategy getGenerationStrategy() {
        return new DefaultStrategy();
    }

    public EObject getModel() {
        return this.model;
    }

    public Module getModule() {
        return this.module;
    }

    public abstract String getModuleName();

    public List<String> getProperties() {
        return new ArrayList<String>();
    }

    public File getTargetFolder() {
        return this.targetFolder;
    }

    public abstract String[] getTemplateNames();

    public void initialize(EObject element, File folder, List<? extends Object> arguments) throws IOException {
        URL moduleURL;
        ResourceSet resourceSet = element.eResource().getResourceSet();
        this.originalResources.addAll((Collection<Resource>)resourceSet.getResources());
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            resourceSet.setURIConverter(this.createURIConverter());
        }
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        this.registerResourceFactories(resourceSet);
        this.registerPackages(resourceSet);
        this.addListeners();
        this.addProperties();
        String moduleName = this.getModuleName();
        if (moduleName.endsWith(".mtl")) {
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
        }
        if (!moduleName.endsWith(".emtl")) {
            moduleName = String.valueOf(moduleName) + ".emtl";
        }
        if ((moduleURL = this.findModuleURL(moduleName)) == null) {
            throw new IOException("'" + this.getModuleName() + ".emtl' not found");
        }
        URI moduleURI = this.createTemplateURI(moduleURL.toString());
        this.module = (Module)ModelUtils.load((URI)moduleURI, (ResourceSet)resourceSet);
        this.model = element;
        this.targetFolder = folder;
        this.generationArguments = arguments;
    }

    public void initialize(URI modelURI, File folder, List<?> arguments) throws IOException {
        URL moduleURL;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            resourceSet.setURIConverter(this.createURIConverter());
        }
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        this.registerResourceFactories((ResourceSet)resourceSet);
        this.registerPackages((ResourceSet)resourceSet);
        this.addListeners();
        this.addProperties();
        String moduleName = this.getModuleName();
        if (moduleName.endsWith(".mtl")) {
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
        }
        if (!moduleName.endsWith(".emtl")) {
            moduleName = String.valueOf(moduleName) + ".emtl";
        }
        if ((moduleURL = this.findModuleURL(moduleName)) == null) {
            throw new IOException("'" + this.getModuleName() + ".emtl' not found");
        }
        URI moduleURI = this.createTemplateURI(moduleURL.toString());
        this.module = (Module)ModelUtils.load((URI)moduleURI, (ResourceSet)resourceSet);
        this.model = ModelUtils.load((URI)modelURI, (ResourceSet)resourceSet);
        this.targetFolder = folder;
        this.generationArguments = arguments;
    }

    public void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getNsURI(), (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)GenModelPackage.eINSTANCE.getNsURI(), (Object)GenModelPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)this.getOCLStdLibPackage());
    }

    public void registerResourceFactories(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emtl", new EMtlResourceFactoryImpl());
    }

    @Deprecated
    protected void addListeners() {
    }

    @Deprecated
    protected void addProperties() {
    }

    protected AcceleoService createAcceleoService() {
        AcceleoService service = new AcceleoService(this.getGenerationStrategy());
        for (IAcceleoTextGenerationListener listener : this.getGenerationListeners()) {
            service.addListener(listener);
        }
        for (IAcceleoTextGenerationListener listener : this.generationListeners) {
            service.addListener(listener);
        }
        for (String propertyFile : this.getProperties()) {
            try {
                service.addPropertiesFile(propertyFile);
            }
            catch (MissingResourceException e) {
                AcceleoEnginePlugin.log(e, false);
            }
        }
        return service;
    }

    protected void postGenerate(ResourceSet rs) {
        ArrayList unload = new ArrayList(rs.getResources());
        unload.removeAll(this.originalResources);
        for (Resource res : unload) {
            res.unload();
            rs.getResources().remove((Object)res);
        }
    }

    protected URIConverter createURIConverter() {
        return new ExtensibleURIConverterImpl(){

            public URI normalize(URI uri) {
                BundleURLConverter conv;
                URI normalized = (URI)this.getURIMap().get(uri);
                if (normalized == null && (conv = new BundleURLConverter(uri.toString())).resolveBundle() != null) {
                    normalized = URI.createURI((String)conv.resolveAsPlatformPlugin());
                    this.getURIMap().put(uri, normalized);
                }
                if (normalized != null) {
                    return normalized;
                }
                return super.normalize(uri);
            }
        };
    }

    protected URI createTemplateURI(String entry) {
        if (entry.startsWith("file:") || entry.startsWith("jar:")) {
            return URI.createURI((String)URI.decode((String)entry));
        }
        return URI.createFileURI((String)URI.decode((String)entry));
    }

    protected URL findModuleURL(String moduleName) {
        URL moduleURL = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            try {
                moduleURL = AcceleoWorkspaceUtil.getResourceURL(this.getClass(), (String)moduleName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (moduleURL == null) {
            moduleURL = this.getClass().getResource(moduleName);
        }
        return moduleURL;
    }

    protected EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
        environment.dispose();
        return oclStdLibPackage;
    }
}

