/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate.expressions;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;

public class EnvironmentProvider {
    private EnvironmentProvider() {
    }

    public static IParseEnvironment createParseEnv() {
        return new EnvImpl();
    }

    public static IEvaluationEnvironment createEvaluationEnv() {
        return new EvalEnvImpl();
    }

    private static class EnvImpl
    extends HashMap
    implements IParseEnvironment {
        private EPackage.Registry importReg;

        EnvImpl() {
            super(5);
        }

        public void setVariable(String name, EClassifier type) {
            if (type == null || type.getName() == null) {
                throw new IllegalArgumentException("Invalid EClassifier passed:" + type);
            }
            if (name == null) {
                throw new IllegalArgumentException("null variable name passed");
            }
            this.put(name, type);
        }

        public EClassifier getTypeOf(String name) {
            return (EClassifier)this.get(name);
        }

        public Set getVariableNames() {
            return this.keySet();
        }

        public void clear() {
            super.clear();
            this.importReg = null;
        }

        public EPackage.Registry getImportRegistry() {
            return this.importReg;
        }

        public void setImportRegistry(EPackage.Registry importReg) {
            this.importReg = importReg;
        }
    }

    private static class EvalEnvImpl
    extends HashMap
    implements IEvaluationEnvironment {
        EvalEnvImpl() {
            super(5);
        }

        public void setVariable(String name, Object value) {
            this.put(name, value);
        }

        public Object getValueOf(String name) {
            return this.get(name);
        }

        public Set getVariableNames() {
            return this.keySet();
        }

        public void clear() {
            super.clear();
        }
    }
}

