/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class FlowFigure
extends Polyline
implements Connection {
    private RotatableDecoration startArrow;
    private RotatableDecoration endArrow;

    public FlowFigure() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(100, 100));
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = (IFigure)this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startArrow;
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endArrow;
    }

    public void setPoints(PointList points) {
        super.setPoints(points);
        this.layout();
    }

    public void layout() {
        Rectangle oldBounds = this.bounds;
        super.layout();
        this.bounds = null;
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent((Translatable)oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.startArrow == dec) {
            return;
        }
        if (this.startArrow != null) {
            this.remove((IFigure)this.startArrow);
        }
        this.startArrow = dec;
        if (this.startArrow != null) {
            this.add((IFigure)this.startArrow, new ArrowLocator((Connection)this, 2));
        }
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.endArrow == dec) {
            return;
        }
        if (this.endArrow != null) {
            this.remove((IFigure)this.endArrow);
        }
        this.endArrow = dec;
        if (this.endArrow != null) {
            this.add((IFigure)this.endArrow, new ArrowLocator((Connection)this, 3));
        }
    }

    public ConnectionRouter getConnectionRouter() {
        return null;
    }

    public void setConnectionRouter(ConnectionRouter router) {
    }

    public Object getRoutingConstraint() {
        return null;
    }

    public void setRoutingConstraint(Object cons) {
    }

    public ConnectionAnchor getSourceAnchor() {
        return null;
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
    }

    public ConnectionAnchor getTargetAnchor() {
        return null;
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
    }
}

