/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.handles;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class CompartmentResizeHandle
extends AbstractHandle {
    private int location = 1;

    public CompartmentResizeHandle(IGraphicalEditPart owner, int location) {
        this.setOwner(owner);
        this.location = location;
        this.setLocator((Locator)new RelativeLocator(owner.getFigure(), location));
        this.setCursor(Cursors.getDirectionalCursor((int)location));
    }

    protected DragTracker createDragTracker() {
        return new ResizeTracker(this.getOwner(), this.location){

            protected List createOperationSet() {
                return Collections.singletonList(this.getOwner());
            }
        };
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Rectangle rect = this.getOwnerFigure().getBounds().getCopy();
        MapModeUtil.getMapMode((IFigure)this.getOwnerFigure()).LPtoDP((Translatable)rect);
        if ((this.location & 5) != 0) {
            return new Dimension(rect.width, 3);
        }
        return new Dimension(3, rect.height);
    }

    protected IFigure getCompartmentFigure() {
        if (this.getOwner() instanceof ResizableCompartmentEditPart) {
            return ((ResizableCompartmentEditPart)this.getOwner()).getCompartmentFigure();
        }
        if (this.getOwner().getFigure() instanceof BorderedNodeFigure) {
            return ((BorderedNodeFigure)this.getOwner().getFigure()).getMainFigure();
        }
        return this.getOwner().getFigure();
    }

    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            boolean before;
            ResizableCompartmentFigure f = (ResizableCompartmentFigure)this.getCompartmentFigure();
            boolean bl = before = (this.location & 9) != 0;
            return f.getAdjacentSibling(before) != null;
        }
        return false;
    }
}

