/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.query.AbstractBaseQueryExecutorStrategy;
import org.eclipse.emf.emfindex.query.EObjectDescriptorQuery;
import org.eclipse.emf.emfindex.query.LazyQueryResultImpl;
import org.eclipse.emf.emfindex.query.QueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectQueryExecutorStrategyImpl
extends AbstractBaseQueryExecutorStrategy<EObjectDescriptor, EObjectDescriptorQuery, MemoryIndexImpl> {
    @Override
    public boolean canExecute(EObjectDescriptorQuery query, MemoryIndexImpl index) {
        return true;
    }

    @Override
    public QueryResult<EObjectDescriptor> execute(final EObjectDescriptorQuery query, final MemoryIndexImpl index) {
        return new LazyQueryResultImpl<EObjectDescriptor>(new Iterable<EObjectDescriptor>(){

            @Override
            public Iterator<EObjectDescriptor> iterator() {
                return EObjectQueryExecutorStrategyImpl.this.getResult(query, index);
            }
        });
    }

    public Iterator<EObjectDescriptor> getResult(final EObjectDescriptorQuery query, MemoryIndexImpl index) {
        if (query.getResourceQuery() != null) {
            Iterator resourceDescriptors = index.getQueryExecutor().execute(query.getResourceQuery()).iterator();
            return Iterators.concat((Iterator)Iterators.transform((Iterator)resourceDescriptors, (Function)new Function<ResourceDescriptor, Iterator<EObjectDescriptor>>(){

                public Iterator<EObjectDescriptor> apply(ResourceDescriptor scope) {
                    return Iterators.filter(scope.getEObjectDescriptors().iterator(), (Predicate)new Predicate<EObjectDescriptor>(){

                        public boolean apply(EObjectDescriptor candidate) {
                            return EObjectQueryExecutorStrategyImpl.this.match(query, candidate);
                        }
                    });
                }
            }));
        }
        return Iterators.filter(index.allEObjectDescriptors(), (Predicate)new Predicate<EObjectDescriptor>(){

            public boolean apply(EObjectDescriptor candidate) {
                return EObjectQueryExecutorStrategyImpl.this.match(query, candidate);
            }
        });
    }

    @Override
    protected boolean internalMatch(EObjectDescriptorQuery query, EObjectDescriptor candidate) {
        EClass isInstanceOf = query.getIsInstanceOf();
        if (isInstanceOf != null && !isInstanceOf.isSuperTypeOf(candidate.getEClass())) {
            return false;
        }
        String fragment = query.getFragment();
        if (fragment != null && !fragment.equals(candidate.getFragment())) {
            return false;
        }
        String name = query.getName();
        String nameContains = query.getNameContains();
        String nameStartsWith = query.getNameStartsWith();
        String nameEndsWith = query.getNameEndsWith();
        if (name == null && nameContains == null && nameStartsWith == null && nameEndsWith == null) {
            return true;
        }
        String candidateName = candidate.getName();
        return !(candidateName == null || name != null && !candidateName.equals(name) || nameContains != null && !candidateName.contains(nameContains) || nameStartsWith != null && !candidateName.startsWith(nameStartsWith) || nameEndsWith != null && !candidateName.endsWith(nameEndsWith));
    }
}

