/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.tests;

import java.util.Calendar;
import java.util.Random;
import ordersystem.Account;
import ordersystem.Address;
import ordersystem.Customer;
import ordersystem.InventoryItem;
import ordersystem.OrderSystem;
import ordersystem.OrderSystemFactory;
import ordersystem.Product;
import ordersystem.Warehouse;

class Example1 {
    private static final OrderSystemFactory factory = OrderSystemFactory.eINSTANCE;
    private static Random random = new Random(1234567890L);

    private Example1() {
    }

    static void create(OrderSystem orderSystem) {
        Example1.createCustomer(orderSystem, "Adams", "Alfred", "Ottawa");
        Example1.createCustomer(orderSystem, "Bairstow", "Bob", "Toronto");
        Example1.createCustomer(orderSystem, "Connell", "Charlie", "Montreal");
        Example1.createProduct(orderSystem, "McGregor Happy Feet Socks");
        Example1.createProduct(orderSystem, "Arnold Palmer Polo Shirt");
        Example1.createProduct(orderSystem, "Wrangler Jeans");
        Example1.createWarehouse(orderSystem, "Ottawa");
        Example1.createWarehouse(orderSystem, "Toronto");
        Example1.createWarehouse(orderSystem, "Montreal");
    }

    private static Product createProduct(OrderSystem os, String name) {
        Product result = factory.createProduct();
        result.setName(name);
        result.setSku(String.valueOf(Example1.hashCode(name)) + "-" + (Example1.nextInt(100) - 1));
        result.setPrice(Example1.nextInt(30));
        os.getProduct().add((Object)result);
        return result;
    }

    private static Warehouse createWarehouse(OrderSystem os, String city) {
        Warehouse result = factory.createWarehouse();
        result.setName(city);
        result.setLocation(Example1.createAddress(city));
        int i = 1;
        for (Product next : os.getProduct()) {
            result.getItem().add((Object)Example1.createInventoryItem(next, i++));
        }
        os.getWarehouse().add((Object)result);
        return result;
    }

    private static InventoryItem createInventoryItem(Product product, int index) {
        InventoryItem result = factory.createInventoryItem();
        result.setRestockThreshold(15);
        result.setInStock(Example1.nextInt(30));
        result.setProduct(product);
        Calendar cal = Calendar.getInstance();
        cal.add(6, index * 7);
        result.setNextStockDate(cal.getTime());
        return result;
    }

    private static Customer createCustomer(OrderSystem os, String last, String first, String city) {
        Customer result = factory.createCustomer();
        result.setLastName(last);
        result.setFirstName(first);
        result.getAccount().add((Object)Example1.createAccount("VISA", String.valueOf(Example1.hashCode(last)) + "-" + Example1.hashCode(first), city));
        os.getCustomer().add((Object)result);
        return result;
    }

    private static Account createAccount(String payment, String number, String city) {
        Account result = factory.createAccount();
        result.setAccountNumber(number);
        result.setPaymentMethod(payment);
        result.setShippingAddress(Example1.createAddress(city));
        result.setBillingAddress(Example1.createAddress(city));
        return result;
    }

    private static Address createAddress(String city) {
        Address result = factory.createAddress();
        result.setCity(city);
        result.setStreet(city + " St.");
        result.setCountry("Canada");
        result.setNumber(String.valueOf(Example1.nextInt(1000)));
        return result;
    }

    private static int hashCode(String s) {
        return Math.abs(s.hashCode());
    }

    private static int nextInt(int range) {
        return random.nextInt(range) + 1;
    }
}

