/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodeSingleValueAttribute;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class PseudoConflictMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void testPseudoAdd_LtR_1() throws IOException {
        Resource left = this.input.getLeftPseudoConflictAddScope();
        Resource right = this.input.getRightPseudoConflictAddScope();
        Resource origin = this.input.getOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftNodeA);
        EObject rightNodeA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightNodeA);
        EStructuralFeature feature = rightNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)rightNodeRoot).getContainmentRef1();
        Assert.assertFalse((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoAdd_LtR_2() throws IOException {
        Resource left = this.input.getLeftPseudoConflictAddScope();
        Resource right = this.input.getRightPseudoConflictAddScope();
        Resource origin = this.input.getOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftNodeA);
        EObject rightNodeA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightNodeA);
        EStructuralFeature feature = rightNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)rightNodeRoot).getContainmentRef1();
        Assert.assertFalse((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoAdd_RtL_1() throws IOException {
        Resource left = this.input.getLeftPseudoConflictAddScope();
        Resource right = this.input.getRightPseudoConflictAddScope();
        Resource origin = this.input.getOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftNodeA);
        EObject rightNodeA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightNodeA);
        EStructuralFeature feature = leftNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)leftNodeRoot).getContainmentRef1();
        Assert.assertFalse((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoAdd_RtL_2() throws IOException {
        Resource left = this.input.getLeftPseudoConflictAddScope();
        Resource right = this.input.getRightPseudoConflictAddScope();
        Resource origin = this.input.getOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftNodeA);
        EObject rightNodeA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightNodeA);
        EStructuralFeature feature = leftNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)leftNodeRoot).getContainmentRef1();
        Assert.assertFalse((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoDelete_LtR_1() throws IOException {
        Resource left = this.input.getLeftPseudoConflictDeleteScope();
        Resource right = this.input.getRightPseudoConflictDeleteScope();
        Resource origin = this.input.getOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeB = this.getNodeNamed(left, "B");
        Assert.assertNull((Object)leftNodeB);
        EObject rightNodeB = this.getNodeNamed(right, "B");
        Assert.assertNull((Object)rightNodeB);
        EStructuralFeature feature = rightNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)rightNodeRoot).getContainmentRef1();
        Assert.assertTrue((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoDelete_LtR_2() throws IOException {
        Resource left = this.input.getLeftPseudoConflictDeleteScope();
        Resource right = this.input.getRightPseudoConflictDeleteScope();
        Resource origin = this.input.getOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeB = this.getNodeNamed(left, "B");
        Assert.assertNull((Object)leftNodeB);
        EObject rightNodeB = this.getNodeNamed(right, "B");
        Assert.assertNull((Object)rightNodeB);
        EStructuralFeature feature = rightNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)rightNodeRoot).getContainmentRef1();
        Assert.assertTrue((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoDelete_RtL_1() throws IOException {
        Resource left = this.input.getLeftPseudoConflictDeleteScope();
        Resource right = this.input.getRightPseudoConflictDeleteScope();
        Resource origin = this.input.getOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeB = this.getNodeNamed(left, "B");
        Assert.assertNull((Object)leftNodeB);
        EObject rightNodeB = this.getNodeNamed(right, "B");
        Assert.assertNull((Object)rightNodeB);
        EStructuralFeature feature = leftNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)leftNodeRoot).getContainmentRef1();
        Assert.assertTrue((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoDelete_RtL_2() throws IOException {
        Resource left = this.input.getLeftPseudoConflictDeleteScope();
        Resource right = this.input.getRightPseudoConflictDeleteScope();
        Resource origin = this.input.getOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        String featureName = "containmentRef1";
        EObject leftNodeRoot = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)leftNodeRoot);
        EObject rightNodeRoot = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNodeRoot);
        EObject leftNodeB = this.getNodeNamed(left, "B");
        Assert.assertNull((Object)leftNodeB);
        EObject rightNodeB = this.getNodeNamed(right, "B");
        Assert.assertNull((Object)rightNodeB);
        EStructuralFeature feature = leftNodeRoot.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1 = ((Node)leftNodeRoot).getContainmentRef1();
        Assert.assertTrue((boolean)containmentRef1.isEmpty());
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoChange_LtR_1() throws IOException {
        Resource left = this.input.getLeftPseudoConflictChangeScope();
        Resource right = this.input.getRightPseudoConflictChangeScope();
        Resource origin = this.input.getOriginPseudoConflictChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        String featureName = "singleValuedAttribute";
        EObject leftNodeD = this.getNodeNamed(left, "D");
        Assert.assertNotNull((Object)leftNodeD);
        EObject rightNodeD = this.getNodeNamed(right, "D");
        Assert.assertNotNull((Object)rightNodeD);
        EStructuralFeature featureRight = rightNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureRight);
        EStructuralFeature featureLeft = leftNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureLeft);
        String singleValuedAttributeRight = ((NodeSingleValueAttribute)rightNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeRight);
        String singleValuedAttributeLeft = ((NodeSingleValueAttribute)leftNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeLeft);
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoChange_LtR_2() throws IOException {
        Resource left = this.input.getLeftPseudoConflictChangeScope();
        Resource right = this.input.getRightPseudoConflictChangeScope();
        Resource origin = this.input.getOriginPseudoConflictChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        String featureName = "singleValuedAttribute";
        EObject leftNodeD = this.getNodeNamed(left, "D");
        Assert.assertNotNull((Object)leftNodeD);
        EObject rightNodeD = this.getNodeNamed(right, "D");
        Assert.assertNotNull((Object)rightNodeD);
        EStructuralFeature featureRight = rightNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureRight);
        EStructuralFeature featureLeft = leftNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureLeft);
        String singleValuedAttributeRight = ((NodeSingleValueAttribute)rightNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeRight);
        String singleValuedAttributeLeft = ((NodeSingleValueAttribute)leftNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeLeft);
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoChange_RtL_1() throws IOException {
        Resource left = this.input.getLeftPseudoConflictChangeScope();
        Resource right = this.input.getRightPseudoConflictChangeScope();
        Resource origin = this.input.getOriginPseudoConflictChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        String featureName = "singleValuedAttribute";
        EObject leftNodeD = this.getNodeNamed(left, "D");
        Assert.assertNotNull((Object)leftNodeD);
        EObject rightNodeD = this.getNodeNamed(right, "D");
        Assert.assertNotNull((Object)rightNodeD);
        EStructuralFeature featureRight = rightNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureRight);
        EStructuralFeature featureLeft = leftNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureLeft);
        String singleValuedAttributeRight = ((NodeSingleValueAttribute)rightNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeRight);
        String singleValuedAttributeLeft = ((NodeSingleValueAttribute)leftNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeLeft);
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    @Test
    public void testPseudoChange_RtL_2() throws IOException {
        Resource left = this.input.getLeftPseudoConflictChangeScope();
        Resource right = this.input.getRightPseudoConflictChangeScope();
        Resource origin = this.input.getOriginPseudoConflictChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        String featureName = "singleValuedAttribute";
        EObject leftNodeD = this.getNodeNamed(left, "D");
        Assert.assertNotNull((Object)leftNodeD);
        EObject rightNodeD = this.getNodeNamed(right, "D");
        Assert.assertNotNull((Object)rightNodeD);
        EStructuralFeature featureRight = rightNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureRight);
        EStructuralFeature featureLeft = leftNodeD.eClass().getEStructuralFeature("singleValuedAttribute");
        Assert.assertNotNull((Object)featureLeft);
        String singleValuedAttributeRight = ((NodeSingleValueAttribute)rightNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeRight);
        String singleValuedAttributeLeft = ((NodeSingleValueAttribute)leftNodeD).getSingleValuedAttribute();
        Assert.assertEquals((Object)"GoodBye", (Object)singleValuedAttributeLeft);
        Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

