/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.MergeBlockedByConflictException;

public class ComputeDiffsToMerge {
    private final boolean rightToLeft;
    private Set<Diff> result = new LinkedHashSet<Diff>();
    private Set<Diff> computing = new HashSet<Diff>();
    private Predicate<? super Conflict> conflictChecker;
    private IDiffRelationshipComputer relationshipComputer;

    public ComputeDiffsToMerge(boolean rightToLeft, IMerger.Registry2 registry) {
        this(rightToLeft, new DiffRelationshipComputer(registry, IMergeCriterion.NONE));
    }

    public ComputeDiffsToMerge(boolean rightToLeft, IMerger.Registry2 registry, IMergeCriterion criterion) {
        this(rightToLeft, new DiffRelationshipComputer(registry, criterion));
    }

    public ComputeDiffsToMerge(boolean rightToLeft, IDiffRelationshipComputer relationshipComputer) {
        this.rightToLeft = rightToLeft;
        this.relationshipComputer = relationshipComputer;
    }

    public ComputeDiffsToMerge failOnRealConflictUnless(Predicate<? super Conflict> predicate) {
        this.conflictChecker = predicate;
        return this;
    }

    public Set<Diff> getAllDiffsToMerge(Diff diff) {
        this.result.clear();
        this.computing.clear();
        this.addDiff(diff);
        return this.result;
    }

    protected void addDiff(Diff diff) {
        this.addDiffs(Collections.singleton(diff), Sets.newLinkedHashSet());
    }

    protected void addDiffs(Collection<Diff> diffs, Set<Diff> diffPath) {
        if (diffs.isEmpty()) {
            return;
        }
        LinkedHashSet<Diff> consequences = new LinkedHashSet<Diff>();
        for (Diff diff : diffs) {
            this.addDiff(diff, consequences, diffPath);
        }
        this.addDiffs((Collection<Diff>)Sets.difference(consequences, this.result), diffPath);
    }

    protected void addDiff(Diff diff, Set<Diff> consequences, Set<Diff> diffPath) {
        if (!this.result.contains(diff) && this.computing.add(diff)) {
            diffPath.add(diff);
            Conflict conflict = diff.getConflict();
            if (this.conflictChecker != null && conflict != null && !this.conflictChecker.apply((Object)conflict) && diff.getConflict().getKind() == ConflictKind.REAL) {
                throw new MergeBlockedByConflictException(diffPath);
            }
            if (this.relationshipComputer.hasMerger(diff)) {
                Set<Diff> dependencies = this.relationshipComputer.getDirectMergeDependencies(diff, this.rightToLeft);
                for (Diff required : dependencies) {
                    this.addDiff(required, consequences, Sets.newLinkedHashSet(diffPath));
                }
                this.result.add(diff);
                this.computing.remove(diff);
                consequences.addAll(this.relationshipComputer.getDirectResultingMerges(diff, this.rightToLeft));
            } else {
                this.result.add(diff);
            }
        }
    }
}

