/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.qvt.oml.tools.coverage.Activator;

public class CoverageAnnotator {
    public static final String TOUCHED_MARKER_TYPE = "org.eclipse.m2m.qvt.oml.tools.coverage.markers.touchedMarker";
    public static final String UNTOUCHED_MARKER_TYPE = "org.eclipse.m2m.qvt.oml.tools.coverage.markers.untouchedMarker";
    public boolean BUSY = false;

    public void annotate(IFile file, RangeSet<Integer> ranges, String markerType, String message) {
        for (Range range : ranges.asRanges()) {
            int start = (Integer)range.lowerEndpoint();
            int end = (Integer)range.upperEndpoint();
            try {
                IMarker m = file.createMarker(markerType);
                m.setAttribute("charStart", start);
                m.setAttribute("charEnd", end);
                if (message.length() <= 0) continue;
                m.setAttribute("message", (Object)message);
            }
            catch (Exception e) {
                Activator.error((String)"Failed to setup coverage marker", (Throwable)e);
            }
        }
    }

    public void annotateTouched(IFile file, RangeSet<Integer> ranges) {
        this.removeAnnotations(file, TOUCHED_MARKER_TYPE);
        this.annotate(file, ranges, TOUCHED_MARKER_TYPE, "");
    }

    public void annotateUntouched(IFile file, RangeSet<Integer> ranges) {
        this.removeAnnotations(file, UNTOUCHED_MARKER_TYPE);
        this.annotate(file, ranges, UNTOUCHED_MARKER_TYPE, "");
    }

    public void removeAnnotations(IFile file, String markerType) {
        try {
            file.deleteMarkers(markerType, true, 2);
        }
        catch (CoreException e) {
            Activator.error((String)"Failed to clear coverage markers", (Throwable)e);
        }
    }

    public void removeAnnotations(IFile file) {
        this.removeAnnotations(file, TOUCHED_MARKER_TYPE);
        this.removeAnnotations(file, UNTOUCHED_MARKER_TYPE);
    }
}

