/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.qvt.oml.blackbox.java.JavaModelInstance;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Java2QVTTypeResolver {
    private QvtOperationalModuleEnv fEnv;
    private List<EPackage> fPackages;
    private EClassifier fHelperEClassiferAdapter;

    Java2QVTTypeResolver(QvtOperationalModuleEnv env, List<EPackage> packages) {
        this.fEnv = env;
        this.fPackages = packages;
    }

    QvtOperationalModuleEnv getEnvironment() {
        return this.fEnv;
    }

    EClassifier toEClassifier(Type type) {
        EClassifier result = this.type2EClassifier(type);
        if (result == null) {
            if (type instanceof Class) {
                EClassifier eWrapper = this.asEClassifier((Class)type);
                EClassifier asOCLType = (EClassifier)this.fEnv.getUMLReflection().asOCLType((Object)eWrapper);
                if (asOCLType != eWrapper) {
                    return asOCLType;
                }
            }
        } else {
            return (EClassifier)this.fEnv.getUMLReflection().asOCLType((Object)result);
        }
        return result;
    }

    private EClassifier type2EClassifier(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.handleParameterizedType(parameterizedType);
        }
        if (type instanceof Class) {
            return this.handleType((Class)type);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            OCLStandardLibrary stdLib = this.fEnv.getOCLStandardLibrary();
            if (((EClassifier)stdLib.getT()).getName().equals(typeVariable.getName())) {
                return (EClassifier)this.getEnvironment().getOCLStandardLibrary().getT();
            }
            if (((EClassifier)stdLib.getT2()).getName().equals(typeVariable.getName())) {
                return (EClassifier)this.getEnvironment().getOCLStandardLibrary().getT();
            }
            if (QvtOperationalStdLibrary.INSTANCE.getKeyT().getName().equals(typeVariable.getName())) {
                return QvtOperationalStdLibrary.INSTANCE.getKeyT();
            }
        }
        return null;
    }

    private EClassifier handleParameterizedType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return null;
        }
        Type actualElementType = actualTypeArguments[0];
        if (!(rawType instanceof Class)) {
            return null;
        }
        Class rawClass = (Class)rawType;
        if (rawClass == Dictionary.class) {
            EClassifier elementType;
            Type actualElementType2;
            EClassifier keyType = this.toEClassifier(actualElementType);
            Type type = actualElementType2 = actualTypeArguments.length > 1 ? actualTypeArguments[1] : null;
            if (keyType != null && actualElementType2 != null && (elementType = this.toEClassifier(actualElementType2)) != null) {
                return this.fEnv.getTypeResolver().resolveDictionaryType(keyType, elementType);
            }
        } else if (rawClass == MutableList.class) {
            EClassifier listElementType = this.toEClassifier(actualElementType);
            if (listElementType != null) {
                return this.fEnv.getTypeResolver().resolveListType(listElementType);
            }
        } else {
            if (rawClass == LinkedHashSet.class) {
                return this.resolveCollectionType(CollectionKind.ORDERED_SET_LITERAL, actualElementType);
            }
            if (Set.class.isAssignableFrom(rawClass)) {
                return this.resolveCollectionType(CollectionKind.SET_LITERAL, actualElementType);
            }
            if (rawClass == Bag.class) {
                return this.resolveCollectionType(CollectionKind.BAG_LITERAL, actualElementType);
            }
            if (List.class.isAssignableFrom(rawClass)) {
                return this.resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, actualElementType);
            }
            if (rawType == List.class) {
                return this.resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, actualElementType);
            }
            if (rawType == Collection.class) {
                return this.resolveCollectionType(CollectionKind.COLLECTION_LITERAL, actualElementType);
            }
        }
        return this.lookupByInstanceClass(parameterizedType);
    }

    private EClassifier resolveCollectionType(CollectionKind kind, Type elementType) {
        QVTOTypeResolver typeResolver = this.fEnv.getTypeResolver();
        EClassifier actualElementClassifier = null;
        if (elementType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)elementType;
            String genericJavaTypeName = typeVariable.getName();
            OCLStandardLibrary oclStdLibrary = this.fEnv.getOCLStandardLibrary();
            EClassifier typeT = (EClassifier)oclStdLibrary.getT();
            if (typeT.getName().equals(genericJavaTypeName)) {
                actualElementClassifier = typeT;
            } else {
                EClassifier typeT2 = (EClassifier)oclStdLibrary.getT2();
                if (typeT2.getName().equals(genericJavaTypeName)) {
                    actualElementClassifier = typeT2;
                }
            }
        } else if (elementType != null) {
            actualElementClassifier = this.toEClassifier(elementType);
        }
        if (actualElementClassifier != null) {
            return (EClassifier)typeResolver.resolveCollectionType(kind, actualElementClassifier);
        }
        return null;
    }

    private EClassifier handleType(Class<?> type) {
        OCLStandardLibrary stdLibrary = this.fEnv.getOCLStandardLibrary();
        if (type == Object.class) {
            return (EClassifier)stdLibrary.getOclAny();
        }
        if (type == String.class) {
            return (EClassifier)stdLibrary.getString();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (EClassifier)stdLibrary.getBoolean();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (EClassifier)stdLibrary.getInteger();
        }
        if (type == Double.class || type == Double.TYPE) {
            return (EClassifier)stdLibrary.getReal();
        }
        if (type == Void.TYPE) {
            return (EClassifier)stdLibrary.getOclVoid();
        }
        if (type == JavaModelInstance.class) {
            return this.fEnv.getQVTStandardLibrary().getModelClass();
        }
        return this.lookupByInstanceClass(type);
    }

    private EClassifier lookupByInstanceClass(Class<?> type) {
        assert (type != null);
        for (EPackage ePackage : this.fPackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (type != eClassifier.getInstanceClass()) continue;
                return eClassifier;
            }
        }
        return null;
    }

    private EClassifier lookupByInstanceClass(ParameterizedType type) {
        assert (type != null);
        for (EPackage ePackage : this.fPackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (type.getRawType() != eClassifier.getInstanceClass()) continue;
                return eClassifier;
            }
        }
        return null;
    }

    private EClassifier asEClassifier(Class<?> javaClass) {
        if (this.fHelperEClassiferAdapter == null) {
            EPackage ownerPackage = EcoreFactory.eINSTANCE.createEPackage();
            ownerPackage.setName("helper");
            ownerPackage.setNsURI(javaClass.getName());
            this.fHelperEClassiferAdapter = EcoreFactory.eINSTANCE.createEDataType();
            ownerPackage.getEClassifiers().add((Object)this.fHelperEClassiferAdapter);
        }
        this.fHelperEClassiferAdapter.setName(javaClass.getSimpleName());
        this.fHelperEClassiferAdapter.setInstanceClass(javaClass);
        return this.fHelperEClassiferAdapter;
    }
}

