/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Transformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.OverrideableVariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2InheritedProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2ResultProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2SuccessProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

abstract class AbstractRelation2MiddleType
implements Relation2MiddleType {
    protected final @NonNull Relation2TraceGroup relation2traceGroup;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Transformation2TracePackage transformation2tracePackage;
    protected final @NonNull Relation relation;
    protected final @NonNull Class middleClass;
    private @Nullable Class bagOfMiddleClass = null;
    private final @NonNull Map<@NonNull VariableDeclaration, @NonNull VariableDeclaration2TraceProperty> variable2variableDeclaration2traceProperty = new HashMap<VariableDeclaration, VariableDeclaration2TraceProperty>();
    private @Nullable Element2MiddleProperty relation2dispatchSuccessProperty = null;
    private @Nullable Element2MiddleProperty relation2globalSuccessProperty = null;
    private @Nullable Element2MiddleProperty relation2localSuccessProperty = null;
    private @Nullable Relation2ResultProperty relation2resultProperty = null;

    protected AbstractRelation2MiddleType(@NonNull Relation2TraceGroup relation2traceGroup, @NonNull String middleClassName) {
        this.relation2traceGroup = relation2traceGroup;
        this.scheduleManager = relation2traceGroup.getScheduleManager();
        this.transformation2tracePackage = relation2traceGroup.getTransformation2TracePackage();
        this.relation = relation2traceGroup.getRule();
        this.middleClass = this.transformation2tracePackage.createClass(this, middleClassName);
        assert (this.scheduleManager.getMultipleScheduleManager() == this.scheduleManager);
    }

    @Override
    public void analyzeTraceElements(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups, @NonNull RuleAnalysis ruleAnalysis) throws CompilerChainException {
    }

    protected void analyzeRootTemplateVariables(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups) {
        boolean manyTracesPerHead = headNodeGroups.size() > 2;
        for (Domain domain : QVTbaseUtil.getOwnedDomains((Rule)this.relation)) {
            TypedModel typedModel = domain.getTypedModel();
            for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((RelationDomain)((RelationDomain)domain))) {
                this.getRootVariableDeclaration2TraceProperty(typedModel, rootVariable, manyTracesPerHead);
            }
        }
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2DispatchSuccessProperty() {
        return this.relation2dispatchSuccessProperty;
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2GlobalSuccessProperty() {
        return this.relation2globalSuccessProperty;
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2LocalSuccessProperty() {
        return this.relation2localSuccessProperty;
    }

    @Override
    public @Nullable Relation2ResultProperty basicGetRelation2ResultProperty() {
        return this.relation2resultProperty;
    }

    @Override
    public @Nullable Property basicGetTraceProperty(@NonNull VariableDeclaration rVariable) {
        VariableDeclaration2TraceProperty variableDeclaration2traceProperty = this.basicGetVariableDeclaration2TraceProperty(rVariable);
        if (variableDeclaration2traceProperty == null) {
            return null;
        }
        return variableDeclaration2traceProperty.getTraceProperty();
    }

    @Override
    public @Nullable VariableDeclaration2TraceProperty basicGetVariableDeclaration2TraceProperty(@NonNull VariableDeclaration variable) {
        return this.variable2variableDeclaration2traceProperty.get(variable);
    }

    @Override
    public int compareTo(@NonNull Rule2MiddleType that) {
        return ClassUtil.safeCompareTo((Comparable)((Object)this.middleClass.getName()), (Comparable)((Object)that.getMiddleClass().getName()));
    }

    public void createRelation2ResultProperty(@NonNull String nameHint) {
        assert (this.relation2resultProperty == null);
        this.relation2resultProperty = new Relation2ResultProperty(this, nameHint, this.getRule2TraceGroup().getTraceInterface());
    }

    public @NonNull Element2MiddleProperty createRelation2DispatchSuccessProperty(@NonNull Property property) {
        assert (this.relation2dispatchSuccessProperty == null);
        this.relation2dispatchSuccessProperty = new Relation2InheritedProperty(this, property);
        return this.relation2dispatchSuccessProperty;
    }

    public @NonNull Element2MiddleProperty createRelation2GlobalSuccessProperty() {
        assert (this.relation2globalSuccessProperty == null);
        QVTrelationNameGenerator nameGenerator = this.relation2traceGroup.getNameGenerator();
        String globalSuccessPropertyName = nameGenerator.createTraceGlobalSuccessPropertyName();
        this.relation2globalSuccessProperty = new Relation2SuccessProperty(this, globalSuccessPropertyName);
        return this.relation2globalSuccessProperty;
    }

    public @NonNull Element2MiddleProperty createRelation2LocalSuccessProperty(@NonNull String nameHint) {
        assert (this.relation2localSuccessProperty == null);
        this.relation2localSuccessProperty = new Relation2SuccessProperty(this, nameHint);
        return this.relation2localSuccessProperty;
    }

    public @NonNull Element2MiddleProperty createRelation2LocalSuccessProperty(@NonNull Property property) {
        assert (this.relation2localSuccessProperty == null);
        this.relation2localSuccessProperty = new Relation2InheritedProperty(this, property);
        return this.relation2localSuccessProperty;
    }

    protected abstract @NonNull String createTracePropertyName(@Nullable TypedModel var1, @NonNull VariableDeclaration var2);

    @Override
    public @NonNull Class getBagOfMiddleClass() {
        Class bagOfMiddleClass2 = this.bagOfMiddleClass;
        if (bagOfMiddleClass2 == null) {
            this.bagOfMiddleClass = bagOfMiddleClass2 = this.transformation2tracePackage.getBagType(this.middleClass);
        }
        return bagOfMiddleClass2;
    }

    @Override
    public @NonNull Property getDispatchSuccessProperty() {
        return ((Element2MiddleProperty)ClassUtil.nonNullState((Object)this.basicGetRelation2DispatchSuccessProperty())).getTraceProperty();
    }

    @Override
    public @NonNull Property getGlobalSuccessProperty() {
        return ((Element2MiddleProperty)ClassUtil.nonNullState((Object)this.basicGetRelation2GlobalSuccessProperty())).getTraceProperty();
    }

    @Override
    public @NonNull Class getMiddleClass() {
        return this.middleClass;
    }

    @Override
    public @NonNull String getName() {
        return QVTrelationUtil.getName((NamedElement)this.relation);
    }

    public @NonNull Relation2ResultProperty getRelation2ResultProperty() {
        return (Relation2ResultProperty)ClassUtil.nonNullState((Object)this.relation2resultProperty);
    }

    public @NonNull Element2MiddleProperty getRelation2DispatchSuccessProperty() {
        return (Element2MiddleProperty)ClassUtil.nonNullState((Object)this.relation2dispatchSuccessProperty);
    }

    public @NonNull Element2MiddleProperty getRelation2GlobalSuccessProperty() {
        return (Element2MiddleProperty)ClassUtil.nonNullState((Object)this.relation2globalSuccessProperty);
    }

    public @NonNull Element2MiddleProperty getRelation2LocalSuccessProperty() {
        return (Element2MiddleProperty)ClassUtil.nonNullState((Object)this.relation2localSuccessProperty);
    }

    @Override
    public @NonNull Property getResultProperty() {
        return ((Relation2ResultProperty)ClassUtil.nonNullState((Object)this.relation2resultProperty)).getTraceProperty();
    }

    @Override
    public void getRootVariableDeclaration2TraceProperty(@Nullable TypedModel typedModel, @NonNull VariableDeclaration variable, boolean manyTraces) {
        this.getVariableDeclaration2TraceProperty(typedModel, variable, !manyTraces);
    }

    @Override
    public @NonNull Relation getRule() {
        return this.relation;
    }

    public @NonNull Relation2MiddleType getRule2TraceInterface() {
        return this;
    }

    @Override
    public @NonNull Relation2TraceGroup getRule2TraceGroup() {
        return this.relation2traceGroup;
    }

    @Override
    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    @Override
    public @NonNull Property getTraceProperty(@NonNull VariableDeclaration rVariable) {
        VariableDeclaration2TraceProperty variableDeclaration2traceProperty = this.getVariableDeclaration2TraceProperty(rVariable);
        return variableDeclaration2traceProperty.getTraceProperty();
    }

    @Override
    public @NonNull RelationalTransformation2TracePackage getTransformation2TracePackage() {
        return (RelationalTransformation2TracePackage)this.transformation2tracePackage;
    }

    public @NonNull TypedModel getTraceTypedModel() {
        return this.scheduleManager.getTraceTypedModel();
    }

    public @NonNull Iterable<@NonNull VariableDeclaration2TraceProperty> getVariableDeclaration2TraceProperties() {
        return this.variable2variableDeclaration2traceProperty.values();
    }

    @Override
    public final @NonNull VariableDeclaration2TraceProperty getVariableDeclaration2TraceProperty(@NonNull VariableDeclaration variable) {
        VariableDeclaration2TraceProperty variableDeclaration2TraceProperty = this.basicGetVariableDeclaration2TraceProperty(variable);
        return (VariableDeclaration2TraceProperty)ClassUtil.nonNullState((Object)variableDeclaration2TraceProperty);
    }

    public @NonNull VariableDeclaration2TraceProperty getVariableDeclaration2TraceProperty(@Nullable TypedModel typedModel, @NonNull VariableDeclaration variable, boolean unitOpposite) {
        VariableDeclaration2TraceProperty variableDeclaration2TraceProperty = this.variable2variableDeclaration2traceProperty.get(variable);
        if (variableDeclaration2TraceProperty == null) {
            String nameHint = this.createTracePropertyName(typedModel, variable);
            variableDeclaration2TraceProperty = new OverrideableVariableDeclaration2TraceProperty(this, nameHint, typedModel, variable, unitOpposite);
            this.variable2variableDeclaration2traceProperty.put(variable, variableDeclaration2TraceProperty);
        } else {
            assert (variableDeclaration2TraceProperty instanceof OverrideableVariableDeclaration2TraceProperty);
            assert (variableDeclaration2TraceProperty.getTypedModel() == typedModel);
            assert (((OverrideableVariableDeclaration2TraceProperty)variableDeclaration2TraceProperty).isUnitOpposite() == unitOpposite);
        }
        return variableDeclaration2TraceProperty;
    }

    @Override
    public void synthesizeTraceModel(@NonNull RuleAnalysis ruleAnalysis) {
        if (this.relation2localSuccessProperty != null) {
            this.relation2localSuccessProperty.getTraceProperty();
        }
        if (this.relation2dispatchSuccessProperty != null) {
            this.relation2dispatchSuccessProperty.getTraceProperty();
        }
        if (this.relation2globalSuccessProperty != null) {
            this.relation2globalSuccessProperty.getTraceProperty();
        }
        if (this.relation2resultProperty != null) {
            this.relation2resultProperty.getTraceProperty();
        }
        for (VariableDeclaration2TraceProperty variableDeclaration2traceProperty : this.variable2variableDeclaration2traceProperty.values()) {
            Property property = variableDeclaration2traceProperty.synthesizeTraceModel();
        }
        CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedPropertiesList((Class)this.middleClass));
    }

    public @NonNull String toString() {
        return String.valueOf(this.middleClass.getName());
    }
}

