/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.manager.FinalAnalysis;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;

public class DependencyAnalyzer {
    private final @NonNull MetamodelManager metamodelManager;
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull SchedulerConstants scheduler;
    private final @NonNull Map<@NonNull List<@Nullable Object>, @NonNull DependencyPaths> content2path = new HashMap<List<Object>, DependencyPaths>();
    private final @NonNull DependencyPaths emptyDependencyPaths = this.createDependencyPaths(null, null);
    private final @NonNull Map<@NonNull OperationId, @NonNull Map<@NonNull List<@NonNull DependencyPaths>, @NonNull OperationAnalysis>> operation2result = new HashMap<OperationId, Map<List<DependencyPaths>, OperationAnalysis>>();
    private final @NonNull Map<@NonNull DomainUsage, @NonNull DependencyStepFactory> usage2factory = new HashMap<DomainUsage, DependencyStepFactory>();
    private final @NonNull FinalAnalysis finalAnalysis;
    private final @NonNull Set<@NonNull OperationAnalysis> blockedAnalyses = new HashSet<OperationAnalysis>();
    private final @NonNull Deque<@NonNull OperationAnalysis> unblockedAnalyses = new LinkedList<OperationAnalysis>();

    public DependencyAnalyzer(@NonNull SchedulerConstants scheduler) {
        EnvironmentFactory environmentFactory = scheduler.getEnvironmentFactory();
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.domainUsageAnalysis = scheduler.getDomainAnalysis();
        this.scheduler = scheduler;
        this.finalAnalysis = new FinalAnalysis((CompleteModelInternal)environmentFactory.getCompleteModel());
    }

    public @NonNull DependencyPaths analyze(@NonNull OperationCallExp operationCallExp) {
        DependencyAnalyzerVisitor visitor = new DependencyAnalyzerVisitor(null);
        return this.analyze(visitor, (Element)operationCallExp);
    }

    /*
     * Unable to fully structure code
     */
    private @NonNull DependencyPaths analyze(@NonNull DependencyAnalyzerVisitor visitor, @NonNull Element element) {
        try {
            return visitor.analyze((Visitable)element);
        }
        catch (BlockedAnalysisException e) {
            ** while (this.unblockedAnalyses.size() > 0)
        }
lbl-1000:
        // 1 sources

        {
            analysis = this.unblockedAnalyses.removeFirst();
            this.checkAll();
            analysis.analyze();
            continue;
        }
lbl10:
        // 2 sources

        while (this.blockedAnalyses.size() > 0) {
            map = new HashMap<String, OperationAnalysis>();
            for (OperationAnalysis analysis : this.blockedAnalyses) {
                map.put(analysis.toString(), analysis);
            }
            keys = new ArrayList<K>(map.keySet());
            Collections.sort(keys);
            mostBlocked = null;
            mostBlockedCount = 0;
            for (String key : keys) {
                operationAnalysis = (OperationAnalysis)map.get(key);
                if (!DependencyAnalyzer.$assertionsDisabled && operationAnalysis == null) {
                    throw new AssertionError();
                }
                operationAnalysis.check();
                if (OperationAnalysis.access$0(operationAnalysis) == null || OperationAnalysis.access$0(operationAnalysis).size() <= mostBlockedCount) continue;
                mostBlocked = operationAnalysis;
                mostBlockedCount = OperationAnalysis.access$0(operationAnalysis).size();
            }
            if (!DependencyAnalyzer.$assertionsDisabled && mostBlocked == null) {
                throw new AssertionError();
            }
            mostBlocked.assignUnknownResult();
            while (this.unblockedAnalyses.size() > 0) {
                analysis = this.unblockedAnalyses.removeFirst();
                this.checkAll();
                analysis.analyze();
            }
        }
        map2 = new HashMap<String, OperationAnalysis>();
        for (Map<List<DependencyPaths>, OperationAnalysis> values : this.operation2result.values()) {
            for (OperationAnalysis analysis : values.values()) {
                if (this.blockedAnalyses.contains(analysis)) continue;
                map2.put(analysis.toString(), analysis);
            }
        }
        keys2 = new ArrayList<K>(map2.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            operationAnalysis = (OperationAnalysis)map2.get(key);
            if (!DependencyAnalyzer.$assertionsDisabled && operationAnalysis == null) {
                throw new AssertionError();
            }
            operationAnalysis.check();
        }
        return this.analyze(visitor, element);
    }

    public @NonNull DependencyPaths analyze(Element element, @NonNull VariableDeclaration selfVariable, @Nullable DependencyPaths selfPath) {
        assert (element != null);
        DependencyAnalyzerVisitor visitor = new DependencyAnalyzerVisitor(null);
        if (selfPath == null) {
            Class type = (Class)ClassUtil.nonNullState((Object)((Class)selfVariable.getType()));
            selfPath = this.createDependencyPaths(this.createClassDependencyStep(type, (Element)selfVariable));
        }
        visitor.addVariable(selfVariable, selfPath);
        return this.analyze(visitor, element);
    }

    protected void block(@NonNull OperationAnalysis invokingAnalysis, @NonNull OperationAnalysis failedAnalysis) {
        Scheduler.DEPENDENCY_ANALYSIS.println("Block   " + invokingAnalysis);
        this.blockedAnalyses.add(invokingAnalysis);
        invokingAnalysis.addFailedAnalysis(failedAnalysis);
        failedAnalysis.addInvokingAnalysis(invokingAnalysis);
    }

    private void checkAll() {
        for (OperationAnalysis operationAnalysis : this.blockedAnalyses) {
            operationAnalysis.check();
        }
    }

    protected @NonNull ClassDependencyStep createClassDependencyStep(@NonNull Class type, @NonNull Element element) {
        while (type instanceof CollectionType) {
            type = (Class)ClassUtil.nonNullState((Object)((Class)((CollectionType)type).getElementType()));
        }
        DomainUsage usage1 = this.domainUsageAnalysis.basicGetUsage((Element)type);
        DomainUsage usage = usage1 != null ? usage1 : this.getUsage(element);
        DependencyStepFactory factory = this.getDependencyStepFactory(usage);
        return factory.createClassDependencyStep(type, element);
    }

    protected @NonNull DependencyPaths createDependencyPaths(@NonNull DependencyStep returnStep) {
        HashSet<@NonNull List<@NonNull DependencyStep>> returnPaths = new HashSet<List<DependencyStep>>();
        returnPaths.add(Collections.singletonList(returnStep));
        return this.createDependencyPaths(returnPaths, null);
    }

    protected @NonNull DependencyPaths createDependencyPaths(@Nullable Set<@NonNull List<@NonNull DependencyStep>> returnPaths, @Nullable Set<@NonNull List<@NonNull DependencyStep>> hiddenPaths) {
        ArrayList<@Nullable Set<List<DependencyStep>>> content = new ArrayList<Set<List<DependencyStep>>>();
        content.add(returnPaths);
        content.add(hiddenPaths);
        DependencyPaths path = this.content2path.get(content);
        if (path == null) {
            path = new DependencyPaths(this, returnPaths, hiddenPaths);
            this.content2path.put(content, path);
        }
        return path;
    }

    protected @NonNull NavigationDependencyStep createPropertyDependencyStep(@NonNull NavigationCallExp navigationCallExp) {
        DomainUsage usage = this.getUsage((Element)navigationCallExp);
        DependencyStepFactory factory = this.getDependencyStepFactory(usage);
        return factory.createPropertyDependencyStep(navigationCallExp);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull DependencyPaths executeOperationCall(@NonNull OperationCallExp operationCallExp, @NonNull List<DependencyPaths> sourceAndArgumentPaths) throws BlockedAnalysisException {
        this.checkAll();
        Operation referredOperation = operationCallExp.getReferredOperation();
        assert (referredOperation != null);
        assert (sourceAndArgumentPaths.size() > 0);
        DependencyPaths sourcePath = sourceAndArgumentPaths.get(0);
        DependencyPaths result = this.emptyDependencyPaths;
        ArrayList<OperationAnalysis> failedAnalyses = null;
        for (List<DependencyStep> steps : sourcePath.getReturnPaths()) {
            int size = steps.size();
            assert (size > 0);
            DependencyStep lastStep = steps.get(size - 1);
            Class sourceClass = lastStep.getElementalType();
            CompleteClass selfClass = this.metamodelManager.getCompleteModel().getCompleteClass((Type)sourceClass);
            @NonNull Iterable overrides = this.finalAnalysis.getOverrides(referredOperation, selfClass);
            for (Operation operation : overrides) {
                DependencyPaths operationResult;
                OperationAnalysis operationAnalysis;
                OperationId operationId = operation.getOperationId();
                Map<List<DependencyPaths>, OperationAnalysis> args2result = this.operation2result.get(operationId);
                if (args2result == null) {
                    args2result = new HashMap<List<DependencyPaths>, OperationAnalysis>();
                    this.operation2result.put(operationId, args2result);
                }
                if ((operationAnalysis = args2result.get(sourceAndArgumentPaths)) == null) {
                    operationAnalysis = new OperationAnalysis(operation, sourceAndArgumentPaths);
                    args2result.put(sourceAndArgumentPaths, operationAnalysis);
                    this.unblockedAnalyses.add(operationAnalysis);
                }
                if ((operationResult = operationAnalysis.getResult()) == null) {
                    if (failedAnalyses == null) {
                        failedAnalyses = new ArrayList<OperationAnalysis>();
                    }
                    failedAnalyses.add(operationAnalysis);
                    continue;
                }
                if (failedAnalyses != null) continue;
                result = result.addReturn(operationResult);
            }
        }
        if (failedAnalyses != null) {
            throw new BlockedAnalysisException(failedAnalyses);
        }
        this.checkAll();
        return result;
    }

    protected @NonNull DependencyStepFactory getDependencyStepFactory(@NonNull DomainUsage usage) {
        DependencyStepFactory factory = this.usage2factory.get(usage);
        if (factory == null) {
            factory = new DependencyStepFactory(usage);
            this.usage2factory.put(usage, factory);
        }
        return factory;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.metamodelManager.getStandardLibrary();
    }

    protected @NonNull DomainUsage getUsage(@NonNull Element element) {
        DomainUsage usage = this.domainUsageAnalysis.basicGetUsage(element);
        assert (usage != null);
        return usage;
    }

    protected void unblock(@NonNull OperationAnalysis operationAnalysis) {
        Scheduler.DEPENDENCY_ANALYSIS.println("Unblock " + operationAnalysis);
        boolean wasRemoved = this.blockedAnalyses.remove(operationAnalysis);
        this.unblockedAnalyses.addLast(operationAnalysis);
    }

    static /* synthetic */ MetamodelManager access$1(DependencyAnalyzer dependencyAnalyzer) {
        return dependencyAnalyzer.metamodelManager;
    }

    protected static class BlockedAnalysisException
    extends RuntimeException {
        private @NonNull Collection<@NonNull OperationAnalysis> failedAnalyses;

        public BlockedAnalysisException(@NonNull Collection<@NonNull OperationAnalysis> failedAnalyses) {
            this.failedAnalyses = failedAnalyses;
        }

        public @NonNull Collection<@NonNull OperationAnalysis> getFailedAnalyses() {
            return this.failedAnalyses;
        }
    }

    protected static class ClassDependencyStep
    extends DependencyStep {
        private final @NonNull Class type;

        public ClassDependencyStep(@NonNull DomainUsage usage, @NonNull Class type, @NonNull Element element) {
            super(usage, element);
            this.type = type;
            assert (!(type instanceof CollectionType));
        }

        @Override
        public @NonNull Class getElementalType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        public String toString() {
            return this.usage + " \u00ab" + this.type.eClass().getName() + "\u00bb" + this.type.toString();
        }
    }

    protected class DependencyAnalyzerVisitor
    extends AbstractExtendingQVTimperativeVisitor<DependencyPaths, Object> {
        private final @Nullable DependencyAnalyzerVisitor parent;
        private final @NonNull Map<@NonNull VariableDeclaration, @NonNull DependencyPaths> variable2dependencies;

        protected DependencyAnalyzerVisitor(DependencyAnalyzerVisitor parent) {
            super(null);
            this.variable2dependencies = new HashMap<VariableDeclaration, DependencyPaths>();
            this.parent = parent;
        }

        private void addVariable(@NonNull VariableDeclaration variable, @NonNull DependencyPaths value) {
            this.variable2dependencies.put(variable, value);
        }

        public @NonNull DependencyPaths analyze(Visitable element) {
            DependencyPaths accept = (DependencyPaths)element.accept((Visitor)this);
            assert (accept != null);
            return accept;
        }

        protected @NonNull DependencyPaths getVariable(@NonNull VariableDeclaration variable) {
            DependencyPaths result = this.variable2dependencies.get(variable);
            if (result != null) {
                return result;
            }
            if (this.parent != null) {
                return this.parent.getVariable(variable);
            }
            Class type = (Class)ClassUtil.nonNullState((Object)((Class)variable.getType()));
            return DependencyAnalyzer.this.createDependencyPaths(DependencyAnalyzer.this.createClassDependencyStep(type, (Element)variable));
        }

        public @NonNull DependencyPaths visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public @NonNull DependencyPaths visitCollectionLiteralExp(@NonNull CollectionLiteralExp collectionLiteralExp) {
            DependencyPaths result = DependencyAnalyzer.this.emptyDependencyPaths;
            for (CollectionLiteralPart ownedPart : ClassUtil.nullFree((List)collectionLiteralExp.getOwnedParts())) {
                result = result.addReturn(this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @NonNull DependencyPaths visitCollectionItem(@NonNull CollectionItem collectionItem) {
            return this.analyze((Visitable)collectionItem.getOwnedItem());
        }

        public @NonNull DependencyPaths visitCollectionRange(@NonNull CollectionRange collectionRange) {
            return DependencyAnalyzer.this.emptyDependencyPaths;
        }

        public @NonNull DependencyPaths visitIfExp(@NonNull IfExp ifExp) {
            DependencyPaths result = this.analyze((Visitable)ifExp.getOwnedThen());
            result = result.addReturn(this.analyze((Visitable)ifExp.getOwnedElse()));
            result = result.addHidden(this.analyze((Visitable)ifExp.getOwnedCondition()));
            return result;
        }

        public @NonNull DependencyPaths visitLetExp(@NonNull LetExp letExp) {
            Variable ownedVariable = letExp.getOwnedVariable();
            DependencyPaths result = this.analyze((Visitable)ownedVariable.getOwnedInit());
            DependencyAnalyzerVisitor nestedAnalyzer = new DependencyAnalyzerVisitor(this);
            nestedAnalyzer.addVariable((VariableDeclaration)ownedVariable, result);
            return nestedAnalyzer.analyze((Visitable)letExp.getOwnedIn());
        }

        public @NonNull DependencyPaths visitLiteralExp(@NonNull LiteralExp literalExp) {
            return DependencyAnalyzer.this.emptyDependencyPaths;
        }

        public @NonNull DependencyPaths visitLoopExp(@NonNull LoopExp loopExp) {
            DependencyPaths result = this.analyze((Visitable)loopExp.getOwnedSource());
            DependencyAnalyzerVisitor nestedAnalyzer = new DependencyAnalyzerVisitor(this);
            for (Variable iterator : loopExp.getOwnedIterators()) {
                nestedAnalyzer.addVariable((VariableDeclaration)iterator, result);
            }
            return nestedAnalyzer.analyze((Visitable)loopExp.getOwnedBody());
        }

        public @NonNull DependencyPaths visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
            DependencyPaths result = DependencyAnalyzer.this.emptyDependencyPaths;
            for (MapLiteralPart ownedPart : mapLiteralExp.getOwnedParts()) {
                result = result.addReturn(this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @NonNull DependencyPaths visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
            return this.analyze((Visitable)mapLiteralPart.getOwnedValue());
        }

        public @NonNull DependencyPaths visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
            DependencyPaths sourcePaths = this.analyze((Visitable)navigationCallExp.getOwnedSource());
            NavigationDependencyStep dependencyStep = DependencyAnalyzer.this.createPropertyDependencyStep(navigationCallExp);
            return sourcePaths.append(dependencyStep);
        }

        public @NonNull DependencyPaths visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
            ArrayList<@NonNull DependencyPaths> argumentPaths = new ArrayList<DependencyPaths>();
            argumentPaths.add(this.analyze((Visitable)operationCallExp.getOwnedSource()));
            for (OCLExpression argument : operationCallExp.getOwnedArguments()) {
                argumentPaths.add(this.analyze((Visitable)argument));
            }
            Operation referredOperation = operationCallExp.getReferredOperation();
            if (referredOperation.getBodyExpression() != null) {
                return DependencyAnalyzer.this.executeOperationCall(operationCallExp, argumentPaths);
            }
            OperationId operationId = referredOperation.getOperationId();
            if (PivotUtil.isSameOperation((OperationId)operationId, (OperationId)DependencyAnalyzer.this.scheduler.getOclElementOclContainerId())) {
                return this.executeOperationCallExp_oclContainer(operationCallExp, argumentPaths);
            }
            Class returnType = (Class)ClassUtil.nonNullState((Object)((Class)operationCallExp.getType()));
            ClassDependencyStep step = DependencyAnalyzer.this.createClassDependencyStep(returnType, (Element)operationCallExp);
            DependencyPaths result = DependencyAnalyzer.this.createDependencyPaths(step);
            for (DependencyPaths argumentPath : argumentPaths) {
                result = result.addHidden(argumentPath);
            }
            return result;
        }

        private @NonNull DependencyPaths executeOperationCallExp_oclContainer(@NonNull OperationCallExp operationCallExp, @NonNull List<DependencyPaths> argumentPaths) {
            assert (argumentPaths.size() == 1);
            DependencyPaths sourcePath = argumentPaths.get(0);
            DependencyPaths result = DependencyAnalyzer.this.emptyDependencyPaths;
            for (List<DependencyStep> steps : sourcePath.getReturnPaths()) {
                int size = steps.size();
                assert (size > 0);
                DependencyStep lastStep = steps.get(size - 1);
                Class sourceClass = lastStep.getElementalType();
                for (Class containerClass : DependencyAnalyzer.this.scheduler.getClassRelationships().getContainerClasses(sourceClass)) {
                    ClassDependencyStep classDependencyStep = DependencyAnalyzer.this.createClassDependencyStep(containerClass, (Element)operationCallExp);
                    result = result.addReturn(DependencyAnalyzer.this.createDependencyPaths(classDependencyStep));
                }
            }
            return result;
        }

        public @NonNull DependencyPaths visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment propertyAssignment) {
            return this.visiting((Visitable)propertyAssignment);
        }

        public @NonNull DependencyPaths visitPropertyAssignment(@NonNull PropertyAssignment propertyAssignment) {
            return this.visiting((Visitable)propertyAssignment);
        }

        public @NonNull DependencyPaths visitShadowExp(@NonNull ShadowExp shadowExp) {
            Class shadowType = (Class)ClassUtil.nonNullState((Object)shadowExp.getType());
            ClassDependencyStep step = DependencyAnalyzer.this.createClassDependencyStep(shadowType, (Element)shadowExp);
            DependencyPaths result = DependencyAnalyzer.this.createDependencyPaths(step);
            for (ShadowPart ownedPart : shadowExp.getOwnedParts()) {
                result = result.addReturn(this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @NonNull DependencyPaths visitShadowPart(@NonNull ShadowPart shadowPart) {
            return this.analyze((Visitable)shadowPart.getOwnedInit());
        }

        public @NonNull DependencyPaths visitTupleLiteralExp(@NonNull TupleLiteralExp tupleLiteralExp) {
            DependencyPaths result = DependencyAnalyzer.this.emptyDependencyPaths;
            for (TupleLiteralPart ownedPart : tupleLiteralExp.getOwnedParts()) {
                result = result.addReturn(this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @NonNull DependencyPaths visitTupleLiteralPart(@NonNull TupleLiteralPart tupleLiteralPart) {
            return this.analyze((Visitable)tupleLiteralPart.getOwnedInit());
        }

        public @NonNull DependencyPaths visitTypeExp(@NonNull TypeExp typeExp) {
            return DependencyAnalyzer.this.emptyDependencyPaths;
        }

        public @NonNull DependencyPaths visitVariableExp(@NonNull VariableExp variableExp) {
            VariableDeclaration referredVariable = variableExp.getReferredVariable();
            assert (referredVariable != null);
            return this.getVariable(referredVariable);
        }
    }

    protected static class DependencyPaths {
        protected final @NonNull DependencyAnalyzer dependencyAnalyzer;
        private final @Nullable Set<@NonNull List<@NonNull DependencyStep>> returnPaths;
        private final @Nullable Set<@NonNull List<@NonNull DependencyStep>> hiddenPaths;

        protected DependencyPaths(@NonNull DependencyAnalyzer dependencyAnalyzer, @Nullable Set<@NonNull List<@NonNull DependencyStep>> returnPaths, @Nullable Set<@NonNull List<@NonNull DependencyStep>> hiddenPaths) {
            this.dependencyAnalyzer = dependencyAnalyzer;
            this.returnPaths = returnPaths;
            this.hiddenPaths = hiddenPaths;
        }

        public @NonNull DependencyPaths addHidden(@NonNull DependencyPaths secondPath) {
            Set<List<DependencyStep>> secondPathReturnPaths;
            Set<@NonNull List<@NonNull DependencyStep>> newHiddenPaths = this.hiddenPaths;
            Set<@NonNull List<@NonNull DependencyStep>> secondPathHiddenPaths = secondPath.hiddenPaths;
            if (secondPathHiddenPaths != null) {
                if (newHiddenPaths != null) {
                    newHiddenPaths = new HashSet<List<DependencyStep>>(newHiddenPaths);
                    newHiddenPaths.addAll(secondPathHiddenPaths);
                } else {
                    newHiddenPaths = secondPathHiddenPaths;
                }
            }
            if ((secondPathReturnPaths = secondPath.returnPaths) != null) {
                if (newHiddenPaths != null) {
                    newHiddenPaths = new HashSet<List<DependencyStep>>(newHiddenPaths);
                    newHiddenPaths.addAll(secondPathReturnPaths);
                } else {
                    newHiddenPaths = secondPathReturnPaths;
                }
            }
            return this.dependencyAnalyzer.createDependencyPaths(this.returnPaths, newHiddenPaths);
        }

        public @NonNull DependencyPaths addReturn(@NonNull DependencyPaths secondPath) {
            Set<List<DependencyStep>> newHiddenPaths;
            Set<List<DependencyStep>> newReturnPaths;
            Set<@NonNull List<@NonNull DependencyStep>> secondPathReturnPaths = secondPath.returnPaths;
            if (secondPathReturnPaths != null) {
                if (this.returnPaths != null) {
                    newReturnPaths = new HashSet<List<DependencyStep>>(this.returnPaths);
                    newReturnPaths.addAll(secondPathReturnPaths);
                } else {
                    newReturnPaths = secondPathReturnPaths;
                }
            } else {
                newReturnPaths = this.returnPaths;
            }
            Set<@NonNull List<@NonNull DependencyStep>> secondPathHiddenPaths = secondPath.hiddenPaths;
            if (secondPathHiddenPaths != null) {
                if (this.hiddenPaths != null) {
                    newHiddenPaths = new HashSet<List<DependencyStep>>(this.hiddenPaths);
                    newHiddenPaths.addAll(secondPathHiddenPaths);
                } else {
                    newHiddenPaths = secondPathHiddenPaths;
                }
            } else {
                newHiddenPaths = this.hiddenPaths;
            }
            return this.dependencyAnalyzer.createDependencyPaths(newReturnPaths, newHiddenPaths);
        }

        public @NonNull DependencyPaths append(@NonNull NavigationDependencyStep propertyDependencyStep) {
            Set<@NonNull List<@NonNull DependencyStep>> oldReturnPaths = this.returnPaths;
            if (oldReturnPaths == null) {
                return this;
            }
            if (this.isRedundant(oldReturnPaths, propertyDependencyStep.getProperty())) {
                return this;
            }
            HashSet<@NonNull List<@NonNull DependencyStep>> newReturnPaths = new HashSet<List<DependencyStep>>();
            for (List<DependencyStep> oldReturnPath : oldReturnPaths) {
                List<DependencyStep> newReturnPath = null;
                int size = oldReturnPath.size();
                assert (size > 0);
                if (size > 0 && oldReturnPath.get(size - 1) == propertyDependencyStep) {
                    newReturnPath = oldReturnPath;
                } else {
                    Class endClass = oldReturnPath.get(size - 1).getElementalType();
                    Class sourceClass = propertyDependencyStep.getProperty().getOwningClass();
                    assert (sourceClass != null);
                    if (!endClass.conformsTo(this.dependencyAnalyzer.getStandardLibrary(), (Type)sourceClass)) {
                        newReturnPath = oldReturnPath;
                    } else {
                        newReturnPath = new ArrayList<DependencyStep>(oldReturnPath);
                        newReturnPath.add(propertyDependencyStep);
                    }
                }
                newReturnPaths.add(newReturnPath);
            }
            return this.dependencyAnalyzer.createDependencyPaths(newReturnPaths, this.hiddenPaths);
        }

        public boolean conformsTo(Type typeValue) {
            return false;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Iterable<@NonNull List<@NonNull DependencyStep>> getHiddenPaths() {
            HashMap<@NonNull String, @NonNull List<@NonNull DependencyStep>> map = new HashMap<String, List<DependencyStep>>();
            if (this.hiddenPaths != null) {
                for (List<DependencyStep> list : this.hiddenPaths) {
                    map.put(String.valueOf(list), list);
                }
            }
            ArrayList<@NonNull K> sortedKeys = new ArrayList(map.keySet());
            Collections.sort(sortedKeys);
            ArrayList<@NonNull List<@NonNull DependencyStep>> sortedList = new ArrayList<List<DependencyStep>>();
            for (String key : sortedKeys) {
                @NonNull List steps = (List)map.get(key);
                assert (steps != null);
                sortedList.add(steps);
            }
            return sortedList;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Iterable<@NonNull List<@NonNull DependencyStep>> getReturnPaths() {
            HashMap<@NonNull String, @NonNull List<@NonNull DependencyStep>> map = new HashMap<String, List<DependencyStep>>();
            if (this.returnPaths != null) {
                for (List<DependencyStep> list : this.returnPaths) {
                    map.put(String.valueOf(list), list);
                }
            }
            ArrayList<@NonNull K> sortedKeys = new ArrayList(map.keySet());
            Collections.sort(sortedKeys);
            ArrayList<@NonNull List<@NonNull DependencyStep>> sortedList = new ArrayList<List<DependencyStep>>();
            for (String key : sortedKeys) {
                @NonNull List steps = (List)map.get(key);
                assert (steps != null);
                sortedList.add(steps);
            }
            return sortedList;
        }

        protected boolean isRedundant(@NonNull Set<@NonNull List<@NonNull DependencyStep>> paths, @NonNull Property property) {
            for (List<DependencyStep> path : paths) {
                int size = path.size();
                if (size <= 0) {
                    return false;
                }
                DependencyStep dependencyStep = path.get(size - 1);
                if (!(dependencyStep instanceof NavigationDependencyStep)) {
                    return false;
                }
                if (((NavigationDependencyStep)dependencyStep).getProperty() == property) continue;
                return false;
            }
            return true;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append("{");
            Iterable<@NonNull List<@NonNull DependencyStep>> returnPaths2 = this.getReturnPaths();
            boolean iFirst = true;
            for (List<DependencyStep> path : returnPaths2) {
                if (!iFirst) {
                    s.append(", ");
                }
                boolean jFirst = true;
                for (DependencyStep step : path) {
                    if (!jFirst) {
                        s.append("::");
                    }
                    s.append(step.getName());
                    jFirst = false;
                }
                iFirst = false;
            }
            s.append(" <= ");
            Iterable<@NonNull List<@NonNull DependencyStep>> hiddenPaths2 = this.getHiddenPaths();
            iFirst = true;
            for (List<DependencyStep> path : hiddenPaths2) {
                if (!iFirst) {
                    s.append(", ");
                }
                boolean jFirst = true;
                for (DependencyStep step : path) {
                    if (!jFirst) {
                        s.append("::");
                    }
                    s.append(step.getName());
                    jFirst = false;
                }
                iFirst = false;
            }
            s.append("}");
            return s.toString();
        }
    }

    protected static abstract class DependencyStep {
        protected final @NonNull DomainUsage usage;
        protected final @NonNull Element element;

        protected DependencyStep(@NonNull DomainUsage usage, @NonNull Element element) {
            this.usage = usage;
            this.element = element;
        }

        public @NonNull Element getElement() {
            return this.element;
        }

        public abstract @NonNull Class getElementalType();

        public abstract String getName();

        public @NonNull DomainUsage getUsage() {
            return this.usage;
        }
    }

    protected static class DependencyStepFactory {
        protected final @NonNull DomainUsage usage;
        private final @NonNull Map<@NonNull Class, @NonNull ClassDependencyStep> class2step = new HashMap<Class, ClassDependencyStep>();
        private final @NonNull Map<@NonNull Property, @NonNull NavigationDependencyStep> property2step = new HashMap<Property, NavigationDependencyStep>();

        protected DependencyStepFactory(@NonNull DomainUsage usage) {
            this.usage = usage;
        }

        public @NonNull ClassDependencyStep createClassDependencyStep(@NonNull Class type, @NonNull Element element) {
            ClassDependencyStep dependencyStep = this.class2step.get(type);
            if (dependencyStep == null) {
                dependencyStep = new ClassDependencyStep(this.usage, type, element);
                this.class2step.put(type, dependencyStep);
            }
            return dependencyStep;
        }

        public @NonNull NavigationDependencyStep createPropertyDependencyStep(@NonNull NavigationCallExp navigationCallExp) {
            Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
            assert (property != null);
            NavigationDependencyStep dependencyStep = this.property2step.get(property);
            if (dependencyStep == null) {
                dependencyStep = new NavigationDependencyStep(this.usage, property, navigationCallExp);
                this.property2step.put(property, dependencyStep);
            }
            return dependencyStep;
        }

        public @NonNull DomainUsage getUsage() {
            return this.usage;
        }
    }

    protected static class NavigationDependencyStep
    extends DependencyStep {
        protected final @NonNull Property property;

        public NavigationDependencyStep(@NonNull DomainUsage usage, @NonNull Property property, @NonNull NavigationCallExp element) {
            super(usage, (Element)element);
            this.property = property;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public @NonNull Class getElementalType() {
            type = this.property.getType();
            if (NavigationDependencyStep.$assertionsDisabled || type != null) ** GOTO lbl7
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                type = ((CollectionType)type).getElementType();
                if (!NavigationDependencyStep.$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
lbl7:
                // 3 sources

                ** while (type instanceof CollectionType)
            }
lbl8:
            // 1 sources

            return (Class)type;
        }

        @Override
        public String getName() {
            return this.property.getName();
        }

        public @NonNull NavigationCallExp getNavigationCallExp() {
            return (NavigationCallExp)this.element;
        }

        public @NonNull Property getProperty() {
            return this.property;
        }

        public String toString() {
            return this.usage + " \u00ab" + this.property.eClass().getName() + "\u00bb" + this.property.toString();
        }
    }

    protected class OperationAnalysis {
        private final @NonNull Operation operation;
        private final @NonNull List<@NonNull DependencyPaths> sourceAndArgumentPaths;
        private DependencyPaths result = null;
        private Collection<@NonNull OperationAnalysis> failedAnalyses = null;
        private Set<@NonNull OperationAnalysis> invokingAnalyses = null;

        public OperationAnalysis(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull Operation operation, List<DependencyPaths> sourceAndArgumentPaths) {
            this.operation = operation;
            this.sourceAndArgumentPaths = sourceAndArgumentPaths;
            Scheduler.DEPENDENCY_ANALYSIS.println("Create  " + this);
        }

        private void addFailedAnalysis(@NonNull OperationAnalysis failedAnalysis) {
            if (this.failedAnalyses == null) {
                this.failedAnalyses = new HashSet<OperationAnalysis>();
            }
            this.failedAnalyses.add(failedAnalysis);
        }

        private void addInvokingAnalysis(@NonNull OperationAnalysis invokingAnalysis) {
            if (this.invokingAnalyses == null) {
                this.invokingAnalyses = new HashSet<OperationAnalysis>();
            }
            this.invokingAnalyses.add(invokingAnalysis);
        }

        /*
         * Unable to fully structure code
         */
        public @Nullable DependencyPaths analyze() {
            block11: {
                if (this.result != null) {
                    return this.result;
                }
                Scheduler.DEPENDENCY_ANALYSIS.println("Start   " + this);
                try {
                    visitor = new DependencyAnalyzerVisitor(null);
                    if (this.operation instanceof Function) {
                        function = (Function)this.operation;
                        transformation = QVTbaseUtil.getContainingTransformation((EObject)function);
                        if (transformation != null) {
                            thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)DependencyAnalyzer.access$1(DependencyAnalyzer.this).getStandardLibrary(), (Transformation)transformation);
                            DependencyAnalyzerVisitor.access$20(visitor, (VariableDeclaration)thisVariable, (DependencyPaths)ClassUtil.nonNullState((Object)this.sourceAndArgumentPaths.get(0)));
                        }
                        ownedParameters = function.getOwnedParameters();
                        ownedBody = function.getQueryExpression();
                    } else {
                        bodyExpression = (LanguageExpression)ClassUtil.nonNullState((Object)this.operation.getBodyExpression());
                        specification = DependencyAnalyzer.access$1(DependencyAnalyzer.this).parseSpecification(bodyExpression);
                        DependencyAnalyzerVisitor.access$20(visitor, (VariableDeclaration)ClassUtil.nonNullState((Object)specification.getOwnedContext()), (DependencyPaths)ClassUtil.nonNullState((Object)this.sourceAndArgumentPaths.get(0)));
                        ownedParameters = specification.getOwnedParameters();
                        ownedBody = specification.getOwnedBody();
                    }
                    iMax = Math.min(ownedParameters.size(), this.sourceAndArgumentPaths.size() - 1);
                    i = 0;
                    while (i < iMax) {
                        DependencyAnalyzerVisitor.access$20(visitor, (VariableDeclaration)ClassUtil.nonNullState((Object)((VariableDeclaration)ownedParameters.get(i))), (DependencyPaths)ClassUtil.nonNullState((Object)this.sourceAndArgumentPaths.get(i + 1)));
                        ++i;
                    }
                    this.result = visitor.analyze((Visitable)ownedBody);
                    if (this.invokingAnalyses != null) {
                        for (OperationAnalysis invokingAnalysis : this.invokingAnalyses) {
                            invokingAnalysis.removeFailedAnalysis(this);
                        }
                        this.invokingAnalyses.clear();
                    }
                    Scheduler.DEPENDENCY_ANALYSIS.println("Finish  " + this);
                    return this.result;
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    break block11;
                }
                catch (BlockedAnalysisException e) {
                    Scheduler.DEPENDENCY_ANALYSIS.println("Fail    " + this);
                    ** for (analysis : e.getFailedAnalyses())
                }
lbl-1000:
                // 1 sources

                {
                    DependencyAnalyzer.this.block(this, analysis);
                    continue;
                }
            }
            return null;
        }

        public void assignUnknownResult() {
            DependencyPaths dependencyPaths = this.sourceAndArgumentPaths.get(0);
            Iterable<@NonNull List<@NonNull DependencyStep>> returnPaths = dependencyPaths.getReturnPaths();
            DependencyStep step = returnPaths.iterator().next().get(0);
            this.result = DependencyAnalyzer.this.createDependencyPaths(new UnknownDependencyStep(step.getUsage(), step.getElementalType(), step.getElement()));
            if (this.invokingAnalyses != null) {
                for (OperationAnalysis invokingAnalysis : new ArrayList<OperationAnalysis>(this.invokingAnalyses)) {
                    this.invokingAnalyses.remove(invokingAnalysis);
                    invokingAnalysis.removeFailedAnalysis(this);
                }
            }
            if (this.failedAnalyses != null) {
                for (OperationAnalysis failedAnalysis : new ArrayList<OperationAnalysis>(this.failedAnalyses)) {
                    this.failedAnalyses.remove(failedAnalysis);
                    failedAnalysis.removeInvokingAnalysis(this);
                }
            }
            DependencyAnalyzer.this.unblock(this);
            DependencyAnalyzer.this.checkAll();
        }

        public void check() {
            if (this.failedAnalyses != null && !this.failedAnalyses.isEmpty()) {
                assert (DependencyAnalyzer.this.blockedAnalyses.contains(this)) : "should be blocked " + this;
                for (OperationAnalysis blockingAnalysis : this.failedAnalyses) {
                    assert (blockingAnalysis.invokingAnalyses.contains(this));
                }
            }
            if (this.invokingAnalyses != null) {
                for (OperationAnalysis blockedAnalysis : this.invokingAnalyses) {
                    assert (DependencyAnalyzer.this.blockedAnalyses.contains(blockedAnalysis));
                    assert (blockedAnalysis.failedAnalyses.contains(this));
                }
            }
        }

        public @Nullable DependencyPaths getResult() {
            return this.result;
        }

        private void removeFailedAnalysis(@NonNull OperationAnalysis operationAnalysis) {
            assert (this.failedAnalyses != null);
            boolean wasRemoved = this.failedAnalyses.remove(operationAnalysis);
            assert (wasRemoved);
            if (this.failedAnalyses.size() <= 0) {
                this.failedAnalyses = null;
                DependencyAnalyzer.this.unblock(this);
            }
        }

        private void removeInvokingAnalysis(@NonNull OperationAnalysis operationAnalysis) {
            assert (this.invokingAnalyses != null);
            boolean wasRemoved = this.invokingAnalyses.remove(operationAnalysis);
            assert (wasRemoved);
        }

        public @NonNull String toString() {
            return String.valueOf(this.operation.toString()) + " <= " + this.sourceAndArgumentPaths;
        }

        static /* synthetic */ Set access$0(OperationAnalysis operationAnalysis) {
            return operationAnalysis.invokingAnalyses;
        }
    }

    protected static class UnknownDependencyStep
    extends DependencyStep {
        private final @NonNull Class type;

        public UnknownDependencyStep(@NonNull DomainUsage usage, @NonNull Class type, @NonNull Element element) {
            super(usage, element);
            this.type = type;
            assert (!(type instanceof CollectionType));
        }

        @Override
        public @NonNull Class getElementalType() {
            return this.type;
        }

        @Override
        public String getName() {
            return "???";
        }

        public String toString() {
            return this.usage + " ??\u00ab" + this.type.eClass().getName() + "\u00bb" + this.type.toString();
        }
    }
}

