/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.m2m.atl.adt.debug.AtlDebugPlugin;

public class AtlBreakpoint
extends LineBreakpoint {
    public static final String ATL_BREAKPOINT_MARKER = "org.eclipse.m2m.atl.adt.debug.atlBreakpointMarker";
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");

    public AtlBreakpoint() {
    }

    public AtlBreakpoint(final IResource resource, final String location, final int lineNumber, final int charStart, final int charEnd) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AtlBreakpoint.this.setMarker(resource.createMarker(AtlBreakpoint.ATL_BREAKPOINT_MARKER));
                AtlBreakpoint.this.addBreakpointAttributes(AtlBreakpoint.this.getModelIdentifier(), location, true, lineNumber, charStart, charEnd);
                AtlBreakpoint.this.setRegistered(true);
            }
        };
        this.run(wr);
    }

    private void addBreakpointAttributes(String modelIdentifier, String location, boolean enabled, int lineNumber, int charStart, int charEnd) {
        try {
            IMarker marker = this.ensureMarker();
            marker.setAttribute("org.eclipse.debug.core.id", (Object)modelIdentifier);
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("org.eclipse.debug.core.enabled", (Object)new Boolean(enabled));
            marker.setAttribute("lineNumber", (Object)new Integer(lineNumber));
            marker.setAttribute("charStart", (Object)new Integer(charStart));
            marker.setAttribute("charEnd", (Object)new Integer(charEnd));
            marker.setAttribute("org.eclipse.debug.core.registered", false);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public String getModelIdentifier() {
        return AtlDebugPlugin.getUniqueIdentifier();
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }
}

